/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.buildship.ui.internal.util.selection.SelectionUtils;
import org.eclipse.buildship.ui.internal.view.task.BaseProjectNode;
import org.eclipse.buildship.ui.internal.view.task.TaskNode;
import org.eclipse.buildship.ui.internal.view.task.TaskView;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.PlatformUI;

public final class TreeViewerSelectionChangeListener
implements ISelectionChangedListener {
    private final TaskView taskView;

    public TreeViewerSelectionChangeListener(TaskView taskView) {
        this.taskView = (TaskView)Preconditions.checkNotNull((Object)taskView);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.taskView.getState().isLinkToSelection()) {
            this.findAndUpdateViewSelections(event.getSelection());
        }
    }

    private void findAndUpdateViewSelections(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ImmutableList<IProject> projects = this.collectProjectNodesToSelect(structuredSelection.toList());
            this.updateViewSelection((List<IProject>)projects);
        }
    }

    private ImmutableList<IProject> collectProjectNodesToSelect(List<?> selectedNodes) {
        ImmutableList.Builder projects = ImmutableList.builder();
        for (Object selectedNode : selectedNodes) {
            Optional<IProject> project;
            if (selectedNode instanceof BaseProjectNode) {
                project = ((BaseProjectNode)selectedNode).getWorkspaceProject();
                if (!project.isPresent()) continue;
                projects.add((Object)((IProject)project.get()));
                continue;
            }
            if (!(selectedNode instanceof TaskNode) || !(project = ((TaskNode)selectedNode).getParentProjectNode().getWorkspaceProject()).isPresent()) continue;
            projects.add((Object)((IProject)project.get()));
        }
        return projects.build();
    }

    private void updateViewSelection(List<IProject> projects) {
        SelectionUtils.selectAndReveal(projects, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }
}

