/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui.editor;

import java.util.Map;
import org.eclipse.cdt.internal.qt.ui.editor.QMLContentAssistProcessor;
import org.eclipse.cdt.internal.qt.ui.editor.QMLEditor;
import org.eclipse.cdt.internal.qt.ui.editor.QMLKeywords;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.text.IColorManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class QMLSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private Token defaultToken;
    private Token multiLineCommentToken;
    private Token singleLineCommentToken;
    private Token keywordToken;
    private Token stringToken;
    private Token taskTagToken;
    private final QMLEditor editor;

    public QMLSourceViewerConfiguration(QMLEditor editor, IPreferenceStore prefs) {
        super(prefs);
        this.editor = editor;
        this.initTokens(prefs);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer viewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning("___qml_partitioning");
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.createMultiLineCommentTokenScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__qml_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__qml_multiline_comment");
        dr = new DefaultDamagerRepairer(this.createSingleLineCommentTokenScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__qml_single_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__qml_single_comment");
        dr = new DefaultDamagerRepairer(this.createStringTokenScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__qml_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__qml_string");
        dr = new DefaultDamagerRepairer(this.createDefaultTokenScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    private ITokenScanner createMultiLineCommentTokenScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setDefaultReturnToken((IToken)this.multiLineCommentToken);
        scanner.setRules(new IRule[]{this.createTaskTagRule((IToken)this.multiLineCommentToken)});
        return scanner;
    }

    private ITokenScanner createSingleLineCommentTokenScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setDefaultReturnToken((IToken)this.singleLineCommentToken);
        scanner.setRules(new IRule[]{this.createTaskTagRule((IToken)this.singleLineCommentToken)});
        return scanner;
    }

    private ITokenScanner createStringTokenScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setDefaultReturnToken((IToken)this.stringToken);
        return scanner;
    }

    private ITokenScanner createDefaultTokenScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        WordRule wordRule = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }
        }, (IToken)this.defaultToken);
        String[] stringArray = QMLKeywords.getKeywords(true);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            wordRule.addWord(keyword, (IToken)this.keywordToken);
            ++n2;
        }
        scanner.setRules(new IRule[]{wordRule});
        return scanner;
    }

    private IRule createTaskTagRule(IToken defaultToken) {
        WordRule wordRule = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }
        }, defaultToken);
        wordRule.addWord("TODO", (IToken)this.taskTagToken);
        wordRule.addWord("FIXME", (IToken)this.taskTagToken);
        wordRule.addWord("XXX", (IToken)this.taskTagToken);
        return wordRule;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant contentAssistant = new ContentAssistant();
        QMLContentAssistProcessor processor = new QMLContentAssistProcessor(this.editor);
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        contentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return contentAssistant;
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.cdt.qt.ui.qml", this.editor);
        return targets;
    }

    private void initTokens(IPreferenceStore prefStore) {
        IColorManager colorManager = CDTUITools.getColorManager();
        this.defaultToken = new Token(null);
        this.multiLineCommentToken = new Token((Object)this.createTextAttribute(colorManager, "c_multi_line_comment"));
        this.singleLineCommentToken = new Token((Object)this.createTextAttribute(colorManager, "c_single_line_comment"));
        this.keywordToken = new Token((Object)this.createTextAttribute(colorManager, "c_keyword"));
        this.stringToken = new Token((Object)this.createTextAttribute(colorManager, "c_string"));
        this.taskTagToken = new Token((Object)this.createTextAttribute(colorManager, "c_comment_task_tag"));
    }

    private TextAttribute createTextAttribute(IColorManager colorManager, String colorKey) {
        int style;
        Color color = colorManager.getColor(colorKey);
        if (color == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey);
            colorManager.unbindColor(colorKey);
            colorManager.bindColor(colorKey, rgb);
            color = colorManager.getColor(colorKey);
        }
        String boldKey = String.valueOf(colorKey) + "_bold";
        String italicKey = String.valueOf(colorKey) + "_italic";
        String strikethroughKey = String.valueOf(colorKey) + "_strikethrough";
        String underlineKey = String.valueOf(colorKey) + "_underline";
        int n = style = this.fPreferenceStore.getBoolean(boldKey) ? 1 : 0;
        if (this.fPreferenceStore.getBoolean(italicKey)) {
            style |= 2;
        }
        if (this.fPreferenceStore.getBoolean(strikethroughKey)) {
            style |= 0x20000000;
        }
        if (this.fPreferenceStore.getBoolean(underlineKey)) {
            style |= 0x40000000;
        }
        return new TextAttribute(color, null, style);
    }

    public void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        IColorManager colorManager = CDTUITools.getColorManager();
        String property = event.getProperty();
        if (property.startsWith("c_multi_line_comment")) {
            this.multiLineCommentToken.setData((Object)this.createTextAttribute(colorManager, "c_multi_line_comment"));
        }
        if (property.startsWith("c_single_line_comment")) {
            this.singleLineCommentToken.setData((Object)this.createTextAttribute(colorManager, "c_single_line_comment"));
        }
        if (property.startsWith("c_keyword")) {
            this.keywordToken.setData((Object)this.createTextAttribute(colorManager, "c_keyword"));
        }
        if (property.startsWith("c_string")) {
            this.stringToken.setData((Object)this.createTextAttribute(colorManager, "c_string"));
        }
        if (property.startsWith("c_comment_task_tag")) {
            this.taskTagToken.setData((Object)this.createTextAttribute(colorManager, "c_comment_task_tag"));
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        String property = event.getProperty();
        return property.startsWith("c_multi_line_comment") || property.startsWith("c_single_line_comment") || property.startsWith("c_keyword") || property.startsWith("c_string") || property.startsWith("c_comment_task_tag");
    }
}

