/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.callhierarchy;

import java.text.MessageFormat;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.dltk.internal.ui.util.SelectionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;

class FocusOnSelectionAction
extends Action {
    private CallHierarchyViewPart fPart;

    public FocusOnSelectionAction(CallHierarchyViewPart part) {
        super(CallHierarchyMessages.FocusOnSelectionAction_focusOnSelection_text);
        this.fPart = part;
        this.setDescription(CallHierarchyMessages.FocusOnSelectionAction_focusOnSelection_description);
        this.setToolTipText(CallHierarchyMessages.FocusOnSelectionAction_focusOnSelection_tooltip);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    public boolean canActionBeAdded() {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        IMethod method = this.getSelectedMethod(element);
        if (method != null) {
            this.setText(MessageFormat.format(CallHierarchyMessages.FocusOnSelectionAction_focusOn_text, method.getElementName()));
            return true;
        }
        return false;
    }

    private IMethod getSelectedMethod(Object element) {
        IModelElement member;
        IMethod method = null;
        if (element instanceof IMethod) {
            method = (IMethod)element;
        } else if (element instanceof MethodWrapper && (member = ((MethodWrapper)((Object)element)).getMember()).getElementType() == 9) {
            method = (IMethod)member;
        }
        return method;
    }

    public void run() {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        IMethod method = this.getSelectedMethod(element);
        if (method != null) {
            this.fPart.setMethod(method);
        }
    }

    private ISelection getSelection() {
        ISelectionProvider provider = this.fPart.getSite().getSelectionProvider();
        if (provider != null) {
            return provider.getSelection();
        }
        return null;
    }
}

