/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.libprov.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jst.common.project.facet.core.libprov.IPropertyChangeListener;

public abstract class PropertiesHost {
    private final Set<IPropertyChangeListener> globalListeners = new CopyOnWriteArraySet<IPropertyChangeListener>();
    private final Map<String, Set<IPropertyChangeListener>> propertySpecificListeners = new HashMap<String, Set<IPropertyChangeListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IPropertyChangeListener listener, String ... properties) {
        if (properties.length == 0) {
            Set<IPropertyChangeListener> set = this.globalListeners;
            synchronized (set) {
                this.globalListeners.add(listener);
            }
        }
        Map<String, Set<IPropertyChangeListener>> map = this.propertySpecificListeners;
        synchronized (map) {
            String[] stringArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                Set<IPropertyChangeListener> list = this.propertySpecificListeners.get(property);
                if (list == null) {
                    list = new CopyOnWriteArraySet<IPropertyChangeListener>();
                    this.propertySpecificListeners.put(property, list);
                }
                list.add(listener);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IPropertyChangeListener listener) {
        boolean globalListenerRemoveResult;
        Object object = this.globalListeners;
        synchronized (object) {
            globalListenerRemoveResult = this.globalListeners.remove(listener);
        }
        if (!globalListenerRemoveResult) {
            object = this.propertySpecificListeners;
            synchronized (object) {
                for (Set<IPropertyChangeListener> listeners : this.propertySpecificListeners.values()) {
                    listeners.remove(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(String property, Object oldValue, Object newValue) {
        Set<IPropertyChangeListener> listeners;
        for (IPropertyChangeListener listener : this.globalListeners) {
            listener.propertyChanged(property, oldValue, newValue);
        }
        Map<String, Set<IPropertyChangeListener>> map = this.propertySpecificListeners;
        synchronized (map) {
            listeners = this.propertySpecificListeners.get(property);
        }
        if (listeners != null) {
            for (IPropertyChangeListener listener : listeners) {
                listener.propertyChanged(property, oldValue, newValue);
            }
        }
    }
}

