/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.archetype;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.maven.DefaultMaven;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.launch.IMavenLauncher;
import org.eclipse.m2e.core.project.IArchetype;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ArchetypeGenerator.class})
public class ArchetypeGenerator {
    @Reference
    IProjectConfigurationManager projectConfigurationManager;
    @Reference
    MavenModelManager mavenModelManager;
    @Reference
    IMavenLauncher mavenLauncher;

    public Collection<MavenProjectInfo> createArchetypeProjects(IPath location, IArchetype archetype, String groupId, String artifactId, String version, String javaPackage, Properties properties, IProgressMonitor monitor) throws CoreException {
        return this.createArchetypeProjects(location, archetype, groupId, artifactId, version, javaPackage, properties, false, monitor);
    }

    /*
     * WARNING - void declaration
     */
    public Collection<MavenProjectInfo> createArchetypeProjects(IPath location, IArchetype archetype, String groupId, String artifactId, String version, String javaPackage, Properties properties, boolean interactive, IProgressMonitor monitor) throws CoreException {
        Object maven;
        File basedir;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.ProjectConfigurationManager_task_creating_project1, (Object)artifactId), (int)3);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        subMonitor.subTask(NLS.bind((String)Messages.ProjectConfigurationManager_task_executing_archetype, (Object)archetype.getGroupId(), (Object)archetype.getArtifactId()));
        if (location == null) {
            location = workspaceRoot.getLocation();
        }
        if ((basedir = location.toFile()) == null || !basedir.mkdirs() && !basedir.isDirectory()) {
            throw new CoreException(Status.error((String)Messages.ProjectConfigurationManager_error_failed));
        }
        Properties userProperties = new Properties(properties);
        userProperties.setProperty("archetypeGroupId", archetype.getGroupId());
        userProperties.setProperty("archetypeArtifactId", archetype.getArtifactId());
        userProperties.setProperty("archetypeVersion", archetype.getVersion());
        userProperties.setProperty("groupId", groupId);
        userProperties.setProperty("artifactId", artifactId);
        userProperties.setProperty("version", version);
        userProperties.setProperty("package", javaPackage);
        userProperties.setProperty("outputDirectory", basedir.getAbsolutePath());
        String projectFolder = location.append(artifactId).toFile().getAbsolutePath();
        File emptyPom = this.getEmptyPom(basedir);
        try {
            String goals = "-U archetype:generate";
            if (emptyPom != null) {
                goals = String.valueOf(goals) + " -f " + emptyPom.getAbsolutePath();
            }
            maven = this.mavenLauncher.runMaven(basedir, goals, userProperties, interactive);
            subMonitor.worked(1);
            Display current = Display.getCurrent();
            while (!((CompletableFuture)maven).isDone()) {
                if (current != null) {
                    while (!current.isDisposed() && current.readAndDispatch()) {
                    }
                }
                Thread.onSpinWait();
            }
            ((CompletableFuture)maven).get();
            subMonitor.worked(1);
            LocalProjectScanner scanner = new LocalProjectScanner(List.of(projectFolder), true, this.mavenModelManager);
            try {
                scanner.run((IProgressMonitor)subMonitor.split(1));
            }
            catch (InterruptedException e) {
                List<MavenProjectInfo> list = List.of();
                if (emptyPom != null) {
                    emptyPom.delete();
                }
                return list;
            }
            Set set = this.projectConfigurationManager.collectProjects((Collection)scanner.getProjects());
            return set;
        }
        catch (InterruptedException | CancellationException ex) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (ExecutionException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof CoreException && (maven = (CoreException)throwable) == (CoreException)throwable) {
                void coreException;
                throw coreException;
            }
            throw new CoreException(Status.error((String)Messages.ProjectConfigurationManager_error_failed, (Throwable)ex));
        }
        finally {
            if (emptyPom != null) {
                emptyPom.delete();
            }
        }
    }

    private File getEmptyPom(File basedir) {
        if (new File(basedir, "pom.xml").isFile()) {
            try {
                File tempFile = File.createTempFile("pom", ".xml", basedir);
                tempFile.deleteOnExit();
                URL standalone = DefaultMaven.class.getResource("project/standalone.xml");
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream stream = standalone.openStream();){
                    Files.copy(stream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return tempFile;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

