/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryRefreshJob;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={IMavenProjectRegistry.class})
public class MavenProjectManager
implements IMavenProjectRegistry {
    public static final String STATE_FILENAME = "workspacestate.properties";
    @Reference
    private ProjectRegistryManager manager;
    @Reference
    private ProjectRegistryRefreshJob mavenBackgroundJob;
    @Reference
    private IMavenConfiguration configuration;
    @Reference
    private IWorkspace workspace;
    private File workspaceStateFile;

    @Activate
    void init(BundleContext bundleContext) {
        IPath result = Platform.getStateLocation((Bundle)bundleContext.getBundle());
        File bundleStateLocation = result.toFile();
        this.workspaceStateFile = new File(bundleStateLocation, STATE_FILENAME);
        boolean updateProjectsOnStartup = this.configuration.isUpdateProjectsOnStartup();
        if (updateProjectsOnStartup || this.manager.getProjects().isEmpty()) {
            this.refresh(new MavenUpdateRequest(Arrays.asList(this.workspace.getRoot().getProjects()), this.configuration.isOffline(), false));
        }
    }

    @Override
    public void refresh(MavenUpdateRequest request) {
        this.mavenBackgroundJob.refresh(request);
    }

    @Override
    public void refresh(Collection<IFile> pomFiles, IProgressMonitor monitor) throws CoreException {
        this.manager.refresh(pomFiles, monitor);
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addMavenProjectChangedListener(IMavenProjectChangedListener listener) {
        this.manager.addMavenProjectChangedListener(listener);
    }

    @Override
    public void removeMavenProjectChangedListener(IMavenProjectChangedListener listener) {
        this.manager.removeMavenProjectChangedListener(listener);
    }

    @Override
    public IMavenProjectFacade create(IFile pom, boolean load, IProgressMonitor monitor) {
        return this.manager.create(pom, load, monitor);
    }

    @Override
    public IMavenProjectFacade create(IProject project, IProgressMonitor monitor) {
        return this.manager.create(project, monitor);
    }

    @Override
    public List<IMavenProjectFacade> getProjects() {
        return this.manager.getProjects();
    }

    @Override
    public IMavenProjectFacade getProject(IProject project) {
        return this.manager.getProject(project);
    }

    @Override
    public IMavenProjectFacade getMavenProject(String groupId, String artifactId, String version) {
        return this.manager.getMavenProject(groupId, artifactId, version);
    }

    public File getWorkspaceStateFile() {
        return this.workspaceStateFile;
    }

    @Override
    public <V> V execute(IMavenProjectFacade facade, ICallable<V> callable, IProgressMonitor monitor) throws CoreException {
        IMavenExecutionContext context = this.manager.createExecutionContext(facade.getPom(), facade.getResolverConfiguration());
        return (V)context.execute((context1, monitor1) -> context1.execute(facade.getMavenProject(monitor1), callable, monitor1), monitor);
    }
}

