/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SmallSet<T>
implements Set<T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static int SMALL_TO_LARGE_THRESHOLD = 5;
    private @Nullable Collection<T> contents;
    private boolean isList;

    public SmallSet() {
        this.contents = null;
        this.isList = false;
    }

    public SmallSet(Collection<? extends T> c) {
        if (c.size() >= SMALL_TO_LARGE_THRESHOLD) {
            this.contents = new HashSet<T>(c);
            this.isList = false;
        } else {
            this.contents = new ArrayList<T>();
            this.isList = true;
            for (T aT : c) {
                this.add(aT);
            }
        }
    }

    public SmallSet(int initialCapacity) {
        if (initialCapacity <= 0) {
            this.contents = null;
            this.isList = false;
        } else if (initialCapacity >= SMALL_TO_LARGE_THRESHOLD) {
            this.contents = new HashSet<T>(initialCapacity);
            this.isList = false;
        } else {
            this.contents = new ArrayList<T>(initialCapacity);
            this.isList = true;
        }
    }

    @Override
    public boolean add(T e) {
        Collection<T> contents2 = this.contents;
        if (contents2 == null) {
            contents2 = new ArrayList<T>();
            this.contents = contents2;
            this.isList = true;
        } else if (this.isList) {
            int newSize = contents2.size() + 1;
            if (newSize > SMALL_TO_LARGE_THRESHOLD) {
                contents2 = new HashSet<T>(contents2);
                this.contents = contents2;
                this.isList = false;
            } else if (contents2.contains(e)) {
                return false;
            }
        }
        return contents2.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        Collection<T> contents2 = this.contents;
        if (contents2 == null) {
            contents2 = new ArrayList<T>();
            this.contents = contents2;
            this.isList = true;
        } else if (this.isList) {
            int newSize = contents2.size() + c.size();
            if (newSize > SMALL_TO_LARGE_THRESHOLD) {
                contents2 = new HashSet<T>(this.contents);
                this.contents = contents2;
                this.isList = false;
            } else {
                boolean isChanged = false;
                for (T aT : c) {
                    if (contents2.contains(aT)) continue;
                    contents2.add(aT);
                    isChanged = true;
                }
                return isChanged;
            }
        }
        return contents2.addAll(c);
    }

    @Override
    public void clear() {
        this.contents = null;
    }

    @Override
    public boolean contains(Object o) {
        return this.contents != null ? this.contents.contains(o) : false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.contents != null ? this.contents.containsAll(c) : false;
    }

    @Override
    public boolean isEmpty() {
        return this.contents != null ? this.contents.isEmpty() : true;
    }

    @Override
    public @NonNull Iterator<T> iterator() {
        return this.contents != null ? this.contents.iterator() : Collections.emptyIterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.contents != null ? this.contents.remove(o) : false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.contents != null ? this.contents.removeAll(c) : false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.contents != null ? this.contents.retainAll(c) : false;
    }

    @Override
    public int size() {
        return this.contents != null ? this.contents.size() : 0;
    }

    @Override
    public Object[] toArray() {
        return this.contents != null ? this.contents.toArray() : EMPTY_ARRAY;
    }

    @Override
    public <T2> T2 @NonNull [] toArray(T2[] a) {
        return (this.contents != null ? this.contents : Collections.emptyList()).toArray(a);
    }
}

