/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.wizards.cheatsheet;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.pde.internal.ua.core.cheatsheet.comp.CompCSWorkspaceModel;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCS;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSIntro;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModelFactory;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSOnCompletion;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTask;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskGroup;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskObject;
import org.eclipse.pde.internal.ua.ui.wizards.cheatsheet.BaseCSCreationOperation;
import org.eclipse.pde.internal.ua.ui.wizards.cheatsheet.CSWizardMessages;

public class CompCSCreationOperation
extends BaseCSCreationOperation {
    public CompCSCreationOperation(IFile file) {
        super(file);
    }

    public CompCSCreationOperation(ISchedulingRule rule) {
        super(rule);
    }

    @Override
    protected void createContent() {
        CompCSWorkspaceModel model = new CompCSWorkspaceModel(this.fFile, false);
        this.initializeCS(model.getCompCS());
        model.save();
        model.dispose();
    }

    private void initializeCS(ICompCS compCS) {
        ICompCSTaskGroup taskGroup = CompCSCreationOperation.createBasicGroup((ICompCSObject)compCS);
        ICompCSTask task = CompCSCreationOperation.createBasicTask((ICompCSObject)taskGroup);
        taskGroup.addFieldTaskObject((ICompCSTaskObject)task);
        compCS.setFieldName(CSWizardMessages.CompCSCreationOperation_title);
        compCS.setFieldTaskObject((ICompCSTaskObject)taskGroup);
    }

    public static ICompCSTask createBasicTask(ICompCSObject parent) {
        ICompCSModelFactory factory = parent.getModel().getFactory();
        ICompCSTask task = factory.createCompCSTask(parent);
        ICompCSIntro taskIntro = factory.createCompCSIntro((ICompCSObject)task);
        taskIntro.setFieldContent(CompCSCreationOperation.formatTextBold(CSWizardMessages.CompCSCreationOperation_intro));
        ICompCSOnCompletion taskConclusion = factory.createCompCSOnCompletion((ICompCSObject)task);
        taskConclusion.setFieldContent(CompCSCreationOperation.formatTextBold(CSWizardMessages.CompCSCreationOperation_conclusion));
        task.setFieldName(CSWizardMessages.CompCSCreationOperation_task);
        task.setFieldKind("cheatsheet");
        task.setFieldIntro(taskIntro);
        task.setFieldOnCompletion(taskConclusion);
        return task;
    }

    public static ICompCSTaskGroup createBasicGroup(ICompCSObject parent) {
        ICompCSModelFactory factory = parent.getModel().getFactory();
        ICompCSTaskGroup taskGroup = factory.createCompCSTaskGroup(parent);
        ICompCSIntro taskGroupIntro = factory.createCompCSIntro((ICompCSObject)taskGroup);
        taskGroupIntro.setFieldContent(CompCSCreationOperation.formatTextBold(CSWizardMessages.CompCSCreationOperation_intro));
        ICompCSOnCompletion taskGroupConclusion = factory.createCompCSOnCompletion((ICompCSObject)taskGroup);
        taskGroupConclusion.setFieldContent(CompCSCreationOperation.formatTextBold(CSWizardMessages.CompCSCreationOperation_conclusion));
        taskGroup.setFieldName(CSWizardMessages.CompCSCreationOperation_group);
        taskGroup.setFieldKind("set");
        taskGroup.setFieldIntro(taskGroupIntro);
        taskGroup.setFieldOnCompletion(taskGroupConclusion);
        return taskGroup;
    }
}

