/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.ui.refactoring.LineBreakpointTypeChange;
import org.eclipse.php.internal.debug.ui.refactoring.RefactoringMessages;

public abstract class BreakpointRenameParticipant
extends RenameParticipant {
    private IModelElement fElement;

    protected boolean initialize(Object element) {
        if (!(element instanceof IModelElement) || !this.accepts((IModelElement)element)) {
            return false;
        }
        this.fElement = (IModelElement)element;
        return true;
    }

    protected IModelElement getOriginalElement() {
        return this.fElement;
    }

    protected abstract boolean accepts(IModelElement var1);

    public String getName() {
        return RefactoringMessages.BreakpointRenameParticipant_0;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ArrayList<Change> changes = new ArrayList<Change>();
        IResource resource = this.getBreakpointContainer();
        IMarker[] markers = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
        this.gatherChanges(markers, changes, this.getArguments().getNewName());
        if (changes.size() > 1) {
            return new CompositeChange(RefactoringMessages.BreakpointRenameParticipant_1, changes.toArray(new Change[changes.size()]));
        }
        if (changes.size() == 1) {
            return (Change)changes.get(0);
        }
        return null;
    }

    protected void gatherChanges(IMarker[] markers, List<Change> changes, String destPackageName) throws CoreException, OperationCanceledException {
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            IBreakpoint breakpoint = this.getBreakpoint(marker);
            if (breakpoint instanceof PHPLineBreakpoint) {
                PHPLineBreakpoint javaBreakpoint = (PHPLineBreakpoint)breakpoint;
                changes.add(this.createTypeChange(javaBreakpoint, marker.getResource(), this.getDestResource(marker.getResource(), destPackageName)));
            }
            ++i;
        }
    }

    protected IResource getDestResource(IResource resource, String destName) {
        IResource oldRes = this.fElement.getResource();
        IFile newRes = null;
        if (oldRes != null) {
            IPath renamedPath = oldRes.getFullPath();
            renamedPath = renamedPath.removeLastSegments(1).append(destName).append(resource.getFullPath().removeFirstSegments(renamedPath.segmentCount()));
            newRes = ResourcesPlugin.getWorkspace().getRoot().getFile(renamedPath);
        }
        return newRes;
    }

    protected IResource getBreakpointContainer() {
        return this.fElement.getResource();
    }

    protected IBreakpoint getBreakpoint(IMarker marker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
    }

    protected Change createTypeChange(PHPLineBreakpoint breakpoint, IResource originalType, IResource destType) throws CoreException {
        return new LineBreakpointTypeChange(breakpoint, originalType, destType);
    }

    protected boolean isContained(IModelElement container, IType type) {
        IType parent = type;
        while (parent != null) {
            if (parent.equals(container)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

