/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtrelation.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.QVTrelationPackage;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomainAssignment;
import org.eclipse.qvtd.pivot.qvtrelation.RelationImplementation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.xtext.qvtbase.ui.labeling.QVTbaseLabelProvider;
import org.eclipse.qvtd.xtext.qvtrelationcs.TopLevelCS;

public class QVTrelationLabelProvider
extends QVTbaseLabelProvider {
    @Inject
    public QVTrelationLabelProvider(@NonNull AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected String image(CollectionTemplateExp ele) {
        return "CollectionTemplateExp.gif";
    }

    protected String image(DomainPattern ele) {
        return "DomainPattern.gif";
    }

    protected String image(Key ele) {
        return "Key.gif";
    }

    protected String image(ObjectTemplateExp ele) {
        return "ObjectTemplateExp.gif";
    }

    protected String image(PropertyTemplateItem ele) {
        return "PropertyTemplateItem.gif";
    }

    protected String image(Relation ele) {
        return "Relation.gif";
    }

    protected String image(RelationCallExp ele) {
        return "RelationCallExp.gif";
    }

    protected String image(RelationDomain ele) {
        return "RelationDomain.gif";
    }

    protected String image(RelationDomainAssignment ele) {
        return "RelationDomainAssignment.gif";
    }

    protected String image(RelationImplementation ele) {
        return "RelationImplementation.gif";
    }

    protected String image(RelationalTransformation ele) {
        return "RelationalTransformation.gif";
    }

    protected String image(TopLevelCS ele) {
        return "QVTrModelFile.gif";
    }

    protected String text(Key ele) {
        StringBuilder s = new StringBuilder();
        this.appendName(s, (NamedElement)ele.getIdentifies());
        s.append("{");
        String prefix = "";
        for (NamedElement usedPackage : ele.getPart()) {
            s.append(prefix);
            this.appendName(s, usedPackage);
            prefix = ",";
        }
        s.append("}");
        return s.toString();
    }

    protected String text(Pattern ele) {
        EStructuralFeature eContainingFeature = ele.eContainingFeature();
        if (eContainingFeature == QVTrelationPackage.Literals.RELATION__WHEN) {
            return "\u00abwhen\u00bb";
        }
        if (eContainingFeature == QVTrelationPackage.Literals.RELATION__WHERE) {
            return "\u00abwhere\u00bb";
        }
        return "\u00abpattern\u00bb";
    }

    protected String text(PropertyTemplateItem ele) {
        return String.valueOf(NameUtil.getSafeName((Nameable)(ele != null ? QVTrelationUtil.basicGetReferredProperty((PropertyTemplateItem)ele) : null))) + " =";
    }

    protected String text(Relation ele) {
        StringBuilder s = new StringBuilder();
        this.appendName(s, (NamedElement)ele);
        return s.toString();
    }

    protected String text(RelationDomain ele) {
        StringBuilder s = new StringBuilder();
        if (ele.isIsEnforceable()) {
            s.append("\u00abenforceable\u00bb ");
        } else if (ele.isIsCheckable()) {
            s.append("\u00abcheckable\u00bb ");
        }
        this.appendName(s, (NamedElement)ele);
        return s.toString();
    }

    protected String text(RelationCallExp ele) {
        assert (ele != null);
        StringBuilder s = new StringBuilder();
        Relation referredRelation = ele.getReferredRelation();
        if (referredRelation != null) {
            this.appendName(s, (NamedElement)referredRelation);
            s.append("(");
            String prefix = "";
            for (Domain csDomain : referredRelation.getDomain()) {
                s.append(prefix);
                this.appendName(s, (NamedElement)csDomain);
                prefix = ", ";
            }
            s.append(")");
        } else {
            s.append("<<null>>");
        }
        return s.toString();
    }

    protected String text(Variable ele) {
        assert (ele != null);
        if (ele.getName() == null) {
            StringBuilder s = new StringBuilder();
            s.append("_ : ");
            Type type = ele.getType();
            if (type != null) {
                s.append(PrettyPrinter.printType((Element)type));
            }
            return s.toString();
        }
        return super.text(ele);
    }
}

