/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.core.lookup;

import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Control;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class WorkbenchPartLookup {
    private static WorkbenchPartLookup instance;
    private IEclipseContext e4Context = WorkbenchPartLookup.getEclipseContext();

    protected static IEclipseContext getEclipseContext() {
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(WorkbenchPartLookup.class).getBundleContext());
        return ((IWorkbench)serviceContext.get(IWorkbench.class)).getApplication().getContext();
    }

    private WorkbenchPartLookup() {
    }

    public static WorkbenchPartLookup getInstance() {
        if (instance == null) {
            instance = new WorkbenchPartLookup();
        }
        return instance;
    }

    public MPart getActiveWorkbenchPart() {
        EPartService partService = (EPartService)this.e4Context.get(EPartService.class);
        return partService.getActivePart();
    }

    public MPart getWorkbenchPartWithLabel(String label) {
        EPartService partService = (EPartService)this.e4Context.get(EPartService.class);
        for (MPart part : partService.getParts()) {
            if (!label.equals(part.getLabel())) continue;
            return part;
        }
        return null;
    }

    public Control getActiveWorkbenchPartControl() {
        return this.getWorkbenchControl(this.getActiveWorkbenchPart());
    }

    public String getActiveWorkbenchPartTitle() {
        MPart activePart = this.getActiveWorkbenchPart();
        if (activePart != null) {
            return activePart.getLabel();
        }
        return null;
    }

    public Control getWorkbenchControl(MPart workbenchPart) {
        if (workbenchPart != null && workbenchPart.getWidget() instanceof Control) {
            return (Control)workbenchPart.getWidget();
        }
        return null;
    }
}

