/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.runner;

import java.util.List;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.execution.TestMethodShouldRun;
import org.eclipse.reddeer.junit.execution.annotation.RunIf;
import org.eclipse.reddeer.junit.extensionpoint.IAfterTest;
import org.eclipse.reddeer.junit.extensionpoint.IBeforeTest;
import org.eclipse.reddeer.junit.internal.requirement.Requirements;
import org.eclipse.reddeer.junit.internal.requirement.inject.RequirementsInjector;
import org.eclipse.reddeer.junit.internal.runner.statement.CleanUpRequirementStatement;
import org.eclipse.reddeer.junit.internal.runner.statement.FulfillRequirementsStatement;
import org.eclipse.reddeer.junit.internal.runner.statement.RunAfterClasses;
import org.eclipse.reddeer.junit.internal.runner.statement.RunAfters;
import org.eclipse.reddeer.junit.internal.runner.statement.RunBeforeClasses;
import org.eclipse.reddeer.junit.internal.runner.statement.RunBefores;
import org.eclipse.reddeer.junit.internal.runner.statement.RunIAfterClassExtensions;
import org.eclipse.reddeer.junit.internal.runner.statement.RunIAfterTestExtensions;
import org.eclipse.reddeer.junit.internal.runner.statement.RunIBeforeClassExtensions;
import org.eclipse.reddeer.junit.internal.runner.statement.RunIBeforeTestExtensions;
import org.eclipse.reddeer.junit.internal.runner.statement.RunTestMethod;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class RequirementsRunner
extends BlockJUnit4ClassRunner {
    private static final Logger log = Logger.getLogger(RequirementsRunner.class);
    protected Requirements requirements;
    protected RunListener[] runListeners;
    protected RequirementsInjector requirementsInjector = new RequirementsInjector();
    protected String configId;
    protected List<IBeforeTest> beforeTestExtensions;
    protected List<IAfterTest> afterTestExtensions;

    protected RequirementsRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    public RequirementsRunner(Class<?> clazz, Requirements requirements, String configId, RunListener[] runListeners, List<IBeforeTest> beforeTestExtensions) throws InitializationError {
        this(clazz, requirements, configId, runListeners, beforeTestExtensions, null);
    }

    public RequirementsRunner(Class<?> clazz, Requirements requirements, String configId, RunListener[] runListeners, List<IBeforeTest> beforeTestExtensions, List<IAfterTest> afterTestExtensions) throws InitializationError {
        super(clazz);
        this.requirements = requirements;
        this.configId = configId;
        this.runListeners = runListeners;
        this.beforeTestExtensions = beforeTestExtensions;
        this.afterTestExtensions = afterTestExtensions;
    }

    public RequirementsRunner(Class<?> clazz, Requirements requirements, String configId) throws InitializationError {
        this(clazz, requirements, configId, null, null);
    }

    public Object createTest() throws Exception {
        Object testInstance = super.createTest();
        log.debug("Injecting fulfilled requirements into test instance: " + this.requirements.getClass().getName());
        this.requirementsInjector.inject(testInstance, this.requirements);
        return testInstance;
    }

    public void run(RunNotifier runNotifier) {
        RunListener listener;
        int n;
        int n2;
        RunListener[] runListenerArray;
        LoggingRunListener loggingRunListener = new LoggingRunListener();
        runNotifier.addListener((RunListener)loggingRunListener);
        if (this.runListeners != null) {
            runListenerArray = this.runListeners;
            n2 = this.runListeners.length;
            n = 0;
            while (n < n2) {
                listener = runListenerArray[n];
                runNotifier.addListener(listener);
                ++n;
            }
        }
        super.run(runNotifier);
        if (this.runListeners != null) {
            runListenerArray = this.runListeners;
            n2 = this.runListeners.length;
            n = 0;
            while (n < n2) {
                listener = runListenerArray[n];
                runNotifier.removeListener(listener);
                ++n;
            }
        }
        runNotifier.removeListener((RunListener)loggingRunListener);
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (this.isIgnored(method)) {
            notifier.fireTestIgnored(description);
        } else {
            this.runLeaf(this.methodBlock(method), description, notifier);
        }
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        return new RunTestMethod(this.configId, this.getTestClass(), method, test);
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        RunAfters runAfters = new RunAfters(this.configId, statement, this.getTestClass(), method, target, this.requirements);
        RunIAfterTestExtensions runAftersExtensions = new RunIAfterTestExtensions(this.configId, runAfters, this.getTestClass(), method, target, this.afterTestExtensions);
        return runAftersExtensions;
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        RunBefores runBefores = new RunBefores(this.configId, statement, this.getTestClass(), method, target, this.requirements);
        RunIBeforeTestExtensions runBeforesExtensions = new RunIBeforeTestExtensions(this.configId, runBefores, this.getTestClass(), method, target, this.beforeTestExtensions);
        return runBeforesExtensions;
    }

    protected Statement withAfterClasses(Statement statement) {
        RunAfterClasses runAfterClass = new RunAfterClasses(this.configId, statement, this.getTestClass(), this.requirements);
        CleanUpRequirementStatement runRequirements = new CleanUpRequirementStatement(this.requirements, runAfterClass);
        RunIAfterClassExtensions runAfterClassExtensions = new RunIAfterClassExtensions(this.configId, runRequirements, this.getTestClass(), this.afterTestExtensions);
        return runAfterClassExtensions;
    }

    protected Statement withBeforeClasses(Statement statement) {
        RunBeforeClasses runBeforeClass = new RunBeforeClasses(this.configId, statement, this.getTestClass(), this.requirements);
        FulfillRequirementsStatement runRequirements = new FulfillRequirementsStatement(this.requirements, runBeforeClass);
        RunIBeforeClassExtensions runBeforeClassExtensions = new RunIBeforeClassExtensions(this.configId, runRequirements, this.getTestClass(), this.beforeTestExtensions);
        return runBeforeClassExtensions;
    }

    protected String testName(FrameworkMethod method) {
        return String.valueOf(method.getName()) + " " + this.configId;
    }

    protected Statement classBlock(RunNotifier notifier) {
        log.debug("Injecting fulfilled requirements into static fields of test class: " + this.requirements.getClass().getName());
        this.requirementsInjector.inject(this.getTestClass().getJavaClass(), this.requirements);
        return super.classBlock(notifier);
    }

    protected String getName() {
        return String.valueOf(super.getName()) + " " + this.configId;
    }

    protected boolean isIgnored(FrameworkMethod child) {
        boolean ignoreAnnotationIsPresented;
        RunIf runIfAnnotation = (RunIf)child.getAnnotation(RunIf.class);
        String testIsIgnoredTemplate = "Test method " + child.getName() + " is ignored because ";
        boolean bl = ignoreAnnotationIsPresented = child.getAnnotation(Ignore.class) != null;
        if (runIfAnnotation != null) {
            block6: {
                if (!this.shouldRun(runIfAnnotation, child)) break block6;
                if (ignoreAnnotationIsPresented) {
                    log.info(String.valueOf(testIsIgnoredTemplate) + " @Ignore annotation is presented.");
                    return true;
                }
                return false;
            }
            try {
                log.info(String.valueOf(testIsIgnoredTemplate) + " shouldRun method of RunIf conditional run is not met.");
                return true;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RedDeerException("Cannot instantiate class of conditional running. Be sure that class has default constructor (is not hidden by another constructor) and is in its own file, not as nested class.", (Throwable)e);
            }
        }
        if (ignoreAnnotationIsPresented) {
            log.info(String.valueOf(testIsIgnoredTemplate) + " @Ignore annotation is presented.");
            return true;
        }
        return false;
    }

    public void setRequirementsInjector(RequirementsInjector requirementsInjector) {
        this.requirementsInjector = requirementsInjector;
    }

    private boolean shouldRun(RunIf runIfAnnotation, FrameworkMethod child) throws IllegalAccessException, InstantiationException {
        boolean isAnd = RunIf.Operation.AND.equals((Object)runIfAnnotation.operation());
        Class<? extends TestMethodShouldRun>[] classArray = runIfAnnotation.conditionClass();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends TestMethodShouldRun> coditionClass = classArray[n2];
            boolean b = coditionClass.newInstance().shouldRun(child);
            if (isAnd != b) {
                return b;
            }
            ++n2;
        }
        return isAnd;
    }

    private class LoggingRunListener
    extends RunListener {
        private LoggingRunListener() {
        }

        public void testFailure(Failure failure) throws Exception {
            Throwable throwable = failure.getException();
            if (throwable instanceof AssertionError) {
                log.error("Failed test: " + failure.getDescription(), throwable);
            } else {
                log.error("Exception in test: " + failure.getDescription(), throwable);
            }
            super.testFailure(failure);
        }

        public void testFinished(Description description) throws Exception {
            log.info("Finished test: " + description);
            super.testFinished(description);
        }

        public void testIgnored(Description description) throws Exception {
            log.info("Ignored test: " + description);
            super.testIgnored(description);
        }

        public void testStarted(Description description) throws Exception {
            log.info("Started test: " + description);
            super.testStarted(description);
        }
    }
}

