/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;

public class SeriesMapper {
    private static final Map<String, ISeriesSettings> MAPPINGS = new HashMap<String, ISeriesSettings>();
    private BaseChart baseChart;

    public SeriesMapper(BaseChart baseChart) {
        this.baseChart = baseChart;
    }

    public static void clear() {
        MAPPINGS.clear();
    }

    public static void remove(String key) {
        MAPPINGS.remove(key);
    }

    public static Set<Map.Entry<String, ISeriesSettings>> getMappings() {
        return Collections.unmodifiableSet(MAPPINGS.entrySet());
    }

    public void mapSettings(ISeries<?>[] seriesArray) {
        if (this.baseChart != null) {
            ISeries<?>[] iSeriesArray = seriesArray;
            int n = seriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries<?> series = iSeriesArray[n2];
                String id = series.getId();
                ISeriesSettings seriesSettings = this.baseChart.getSeriesSettings(id);
                if (seriesSettings != null) {
                    seriesSettings.setVisible(series.isVisible());
                    seriesSettings.setVisibleInLegend(series.isVisibleInLegend());
                    this.adjustColor(series, seriesSettings);
                    seriesSettings.setDescription(series.getDescription());
                    MAPPINGS.put(id, seriesSettings);
                }
                ++n2;
            }
        }
    }

    public void adjustSettings(ISeries<?>[] seriesArray) {
        if (this.baseChart != null) {
            ISeries<?>[] iSeriesArray = seriesArray;
            int n = seriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries<?> series = iSeriesArray[n2];
                String id = series.getId();
                ISeriesSettings settingsBase = this.baseChart.getSeriesSettings(id);
                ISeriesSettings settingsAdjusted = MAPPINGS.get(id);
                if (settingsBase != null && settingsAdjusted != null) {
                    settingsBase.setVisible(settingsAdjusted.isVisible());
                    settingsBase.setVisibleInLegend(settingsAdjusted.isVisibleInLegend());
                    this.adjustColor(settingsBase, settingsAdjusted);
                    settingsBase.setDescription(settingsAdjusted.getDescription());
                    this.baseChart.applySeriesSettings(series, settingsBase);
                }
                ++n2;
            }
            this.baseChart.redraw();
        }
    }

    private void adjustColor(ISeries<?> series, ISeriesSettings seriesSettings) {
        if (series instanceof IBarSeries && seriesSettings instanceof IBarSeriesSettings) {
            IBarSeries barSeries = (IBarSeries)series;
            IBarSeriesSettings barSeriesSettings = (IBarSeriesSettings)seriesSettings;
            barSeriesSettings.setBarColor(barSeries.getBarColor());
        } else if (series instanceof ILineSeries && seriesSettings instanceof ILineSeriesSettings) {
            ILineSeries lineSeries = (ILineSeries)series;
            ILineSeriesSettings lineSeriesSettings = (ILineSeriesSettings)seriesSettings;
            lineSeriesSettings.setLineColor(lineSeries.getLineColor());
        }
    }

    private void adjustColor(ISeriesSettings settingsBase, ISeriesSettings settingsAdjusted) {
        if (settingsBase instanceof IBarSeriesSettings && settingsAdjusted instanceof IBarSeriesSettings) {
            IBarSeriesSettings barSettingsBase = (IBarSeriesSettings)settingsBase;
            IBarSeriesSettings barSettingsAdjusted = (IBarSeriesSettings)settingsAdjusted;
            barSettingsBase.setBarColor(barSettingsAdjusted.getBarColor());
        } else if (settingsBase instanceof ILineSeriesSettings && settingsAdjusted instanceof ILineSeriesSettings) {
            ILineSeriesSettings lineSettingsBase = (ILineSeriesSettings)settingsBase;
            ILineSeriesSettings lineSettingAdjusted = (ILineSeriesSettings)settingsAdjusted;
            lineSettingsBase.setLineColor(lineSettingAdjusted.getLineColor());
        }
    }
}

