/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.swt.listener;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tcf.te.ui.swt.listener.AbstractCellPaintListener;

public abstract class AbstractDecorationCellPaintListener
extends AbstractCellPaintListener {
    public static final int STATE_NONE = 0;
    public static final int STATE_INFO = 1;
    public static final int STATE_WARNING = 2;
    public static final int STATE_ERROR = 3;

    public AbstractDecorationCellPaintListener(Widget widget, int ... columns) {
        super(widget, columns);
    }

    @Override
    protected Point getPaintOrigin(Event event, Image image) {
        return new Point(event.x, event.y);
    }

    @Override
    protected Image getImageToDraw(Item item, int columnIndex) {
        int state;
        Assert.isNotNull((Object)item);
        if (this.isPaintImageInColumn(columnIndex) && (state = this.getDecorationState(item.getData(), columnIndex)) >= 0) {
            FieldDecoration fieldDeco;
            String decorationId = null;
            switch (state) {
                case 1: {
                    decorationId = "DEC_INFORMATION";
                    break;
                }
                case 2: {
                    decorationId = "DEC_WARNING";
                    break;
                }
                case 3: {
                    decorationId = "DEC_ERROR";
                }
            }
            if (decorationId != null && (fieldDeco = FieldDecorationRegistry.getDefault().getFieldDecoration(decorationId)) != null) {
                return fieldDeco.getImage();
            }
        }
        return null;
    }

    protected abstract int getDecorationState(Object var1, int var2);
}

