/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.synchronization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.synchronization.SynchronizationAlgorithm;

public class SynchronizationBackend {
    private static final int SYNC_FILE_MAGIC_NUMBER = 233615104;
    private static final int FILE_VERSION = 1;
    private static final int HEADER_SIZE = 20;
    private final File fSyncFile;

    public SynchronizationBackend(File syncFile) throws IOException {
        this(syncFile, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SynchronizationBackend(File syncFile, boolean throwErrors) throws IOException {
        this.fSyncFile = syncFile;
        if (syncFile == null) {
            return;
        }
        if (!syncFile.exists()) {
            if (!throwErrors) return;
            throw new IOException("Selected synchronization file does not exist");
        }
        if (syncFile.length() <= 0L) {
            if (!throwErrors) return;
            throw new IOException("Invalid synchronization file selected, target file is empty");
        }
        Throwable throwable = null;
        Object var5_5 = null;
        try {
            FileInputStream fis = new FileInputStream(syncFile);
            try {
                try (FileChannel fc = fis.getChannel();){
                    ByteBuffer buffer = ByteBuffer.allocate(20);
                    buffer.clear();
                    fc.read(buffer);
                    buffer.flip();
                    int res = buffer.getInt();
                    if (res != 233615104) {
                        throw new IOException("Selected file does notlook like a synchronization file");
                    }
                    res = buffer.getInt();
                    if (res != 1) {
                        throw new IOException("Select synchronization file is of an older format. Synchronization will have to be computed again.");
                    }
                    res = buffer.getInt();
                }
                if (fis == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public SynchronizationAlgorithm openExistingSync() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveSync(SynchronizationAlgorithm syncAlgo) throws FileNotFoundException {
        if (this.fSyncFile == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try {
                FileOutputStream fos = new FileOutputStream(this.fSyncFile, false);
                try {
                    try (FileChannel fc = fos.getChannel();){
                        ByteBuffer buffer = ByteBuffer.allocate(20);
                        buffer.clear();
                        fc.position(0L);
                        buffer.putInt(233615104);
                        buffer.putInt(1);
                        buffer.flip();
                        int res = fc.write(buffer);
                        if (res > 20) {
                            throw new IOException("Wrote more data than the header size");
                        }
                        fc.position(20L);
                        Throwable throwable2 = null;
                        Object var9_15 = null;
                        try (ObjectOutputStream oos = new ObjectOutputStream(fos);){
                            oos.writeObject(syncAlgo);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                } else {
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            Activator.logError("Error saving trace synchronization data", e);
        }
    }
}

