/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.SingleValueExtendOperationExecutor;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

public class IterateOverEDatatypeInstances
implements IIteratingSearchOperation {
    private final EDataType dataType;
    private final EDataTypeInSlotsKey type;
    private static final TupleMask indexerMask = TupleMask.empty((int)1);
    private final int position;

    public IterateOverEDatatypeInstances(int position, EDataType dataType) {
        this.position = position;
        this.dataType = dataType;
        this.type = new EDataTypeInSlotsKey(dataType);
    }

    public EDataType getDataType() {
        return this.dataType;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor(this.position);
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "extend    " + this.dataType.getName() + "(-" + variableMapping.apply(this.position) + ") indexed";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Collections.singletonList(this.position);
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return this.type;
    }

    private class Executor
    extends SingleValueExtendOperationExecutor<Object> {
        public Executor(int position) {
            super(position);
        }

        @Override
        public Iterator<? extends Object> getIterator(MatchingFrame frame, ISearchContext context) {
            return context.getRuntimeContext().enumerateValues((IInputKey)IterateOverEDatatypeInstances.this.type, indexerMask, (ITuple)Tuples.staticArityFlatTupleOf()).iterator();
        }

        @Override
        public ISearchOperation getOperation() {
            return IterateOverEDatatypeInstances.this;
        }
    }
}

