/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef;

import java.lang.reflect.Constructor;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartFactory;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class MatchingEditPartFactory
implements IEditPartFactory {
    private final List<String> m_modelPackages;
    private final List<String> m_partPackages;

    public MatchingEditPartFactory(List<String> modelPackages, List<String> partPackages) {
        Assert.equals(modelPackages.size(), partPackages.size());
        this.m_modelPackages = modelPackages;
        this.m_partPackages = partPackages;
    }

    @Override
    public EditPart createEditPart(EditPart context, Object model) {
        Class<?> modelClass = model.getClass();
        while (modelClass != null) {
            EditPart editPart = this.createEditPart(model, modelClass);
            if (editPart != null) {
                return editPart;
            }
            modelClass = modelClass.getSuperclass();
        }
        return null;
    }

    private EditPart createEditPart(Object model, Class<?> modelClass) {
        EditPart editPart = this.createEditPart(model, modelClass, "Info");
        if (editPart != null) {
            return editPart;
        }
        editPart = this.createEditPart(model, modelClass, "");
        if (editPart != null) {
            return editPart;
        }
        String modelClassName = modelClass.getName();
        if (modelClassName.contains("$")) {
            modelClassName = StringUtils.remove((String)modelClassName, (String)"Info");
            EditPart editPart2 = this.createEditPart(model, modelClass, modelClassName = StringUtils.remove((String)modelClassName, (String)"$"), "");
            if (editPart2 != null) {
                return editPart2;
            }
        }
        return null;
    }

    private EditPart createEditPart(Object model, Class<?> modelClass, String modelSuffix) {
        String modelClassName = modelClass.getName();
        return this.createEditPart(model, modelClass, modelClassName, modelSuffix);
    }

    private EditPart createEditPart(Object model, Class<?> modelClass, String modelClassName, String modelSuffix) {
        int i = 0;
        while (i < this.m_modelPackages.size()) {
            String modelPackage = this.m_modelPackages.get(i);
            String partPackage = this.m_partPackages.get(i);
            if (modelClassName.startsWith(modelPackage) && modelClassName.endsWith(modelSuffix)) {
                String componentName = modelClassName;
                componentName = componentName.substring(modelPackage.length());
                componentName = StringUtils.chomp((String)componentName, (String)modelSuffix);
                String partClassName = String.valueOf(partPackage) + componentName + "EditPart";
                EditPart editPart = MatchingEditPartFactory.createEditPart0(model, modelClass, partClassName);
                if (editPart != null) {
                    return editPart;
                }
            }
            ++i;
        }
        return null;
    }

    private static EditPart createEditPart0(Object model, Class<?> modelClass, String partClassName) {
        try {
            ClassLoader classLoader = modelClass.getClassLoader();
            Class<?> partClass = classLoader.loadClass(partClassName);
            Constructor<?>[] constructorArray = partClass.getConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constructor = constructorArray[n2];
                try {
                    return (EditPart)constructor.newInstance(model);
                }
                catch (Throwable throwable) {
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

