/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.Kernel32;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.Disks;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.jna.platform.windows.PdhUtil;
import oshi.jna.platform.windows.WbemcliUtil;
import oshi.util.MapUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.PerfDataUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsDisks
implements Disks {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsDisks.class);
    private static Map<String, Long> readMap = new HashMap<String, Long>();
    private static Map<String, Long> readByteMap = new HashMap<String, Long>();
    private static Map<String, Long> writeMap = new HashMap<String, Long>();
    private static Map<String, Long> writeByteMap = new HashMap<String, Long>();
    private static Map<String, Long> xferTimeMap = new HashMap<String, Long>();
    private static Map<String, Long> timeStampMap = new HashMap<String, Long>();
    private static Map<String, List<String>> driveToPartitionMap = new HashMap<String, List<String>>();
    private static Map<String, String> partitionToLogicalDriveMap = new HashMap<String, String>();
    private static Map<String, HWPartition> partitionMap = new HashMap<String, HWPartition>();
    private static final String PHYSICALDRIVE_PREFIX = "\\\\.\\PHYSICALDRIVE";
    private static final String PHYSICAL_DISK = "PhysicalDisk";
    private static final String PHYSICAL_DISK_LOCALIZED = PdhUtil.PdhLookupPerfNameByIndex(null, PdhUtil.PdhLookupPerfIndexByEnglishName("PhysicalDisk"));
    private static final String TOTAL_INSTANCE = "_Total";
    private static final Pattern DEVICE_ID = Pattern.compile(".*\\.DeviceID=\"(.*)\"");
    private static final int BUFSIZE = 255;
    private static final WbemcliUtil.WmiQuery<DiskDriveProperty> DISK_DRIVE_QUERY = WbemcliUtil.createQuery("Win32_DiskDrive", DiskDriveProperty.class);
    private static final WbemcliUtil.WmiQuery<DriveToPartitionProperty> DRIVE_TO_PARTITION_QUERY = WbemcliUtil.createQuery("Win32_DiskDriveToDiskPartition", DriveToPartitionProperty.class);
    private static final WbemcliUtil.WmiQuery<DriveToPartitionProperty> DISK_TO_PARTITION_QUERY = WbemcliUtil.createQuery("Win32_LogicalDiskToPartition", DriveToPartitionProperty.class);
    private static final WbemcliUtil.WmiQuery<DiskPartitionProperty> PARTITION_QUERY = WbemcliUtil.createQuery("Win32_DiskPartition", DiskPartitionProperty.class);
    private static Map<String, PerfDataUtil.PerfCounter> diskReadsCounterMap = new HashMap<String, PerfDataUtil.PerfCounter>();
    private static Map<String, PerfDataUtil.PerfCounter> diskReadBytesCounterMap = new HashMap<String, PerfDataUtil.PerfCounter>();
    private static Map<String, PerfDataUtil.PerfCounter> diskWritesCounterMap = new HashMap<String, PerfDataUtil.PerfCounter>();
    private static Map<String, PerfDataUtil.PerfCounter> diskWriteBytesCounterMap = new HashMap<String, PerfDataUtil.PerfCounter>();
    private static Map<String, PerfDataUtil.PerfCounter> diskXferTimeCounterMap = new HashMap<String, PerfDataUtil.PerfCounter>();
    private static WbemcliUtil.WmiQuery<PhysicalDiskProperty> physicalDiskQuery = null;

    public static boolean updateDiskStats(HWDiskStore diskStore) {
        String index = null;
        HWPartition[] partitions = diskStore.getPartitions();
        if (partitions.length > 0) {
            index = Integer.toString(partitions[0].getMajor());
        } else if (diskStore.getName().startsWith(PHYSICALDRIVE_PREFIX)) {
            index = diskStore.getName().substring(PHYSICALDRIVE_PREFIX.length(), diskStore.getName().length());
        } else {
            LOG.warn("Couldn't match index for {}", (Object)diskStore.getName());
            return false;
        }
        WindowsDisks.populateReadWriteMaps(index);
        if (readMap.containsKey(index)) {
            diskStore.setReads(MapUtil.getOrDefault(readMap, index, 0L));
            diskStore.setReadBytes(MapUtil.getOrDefault(readByteMap, index, 0L));
            diskStore.setWrites(MapUtil.getOrDefault(writeMap, index, 0L));
            diskStore.setWriteBytes(MapUtil.getOrDefault(writeByteMap, index, 0L));
            diskStore.setTransferTime(MapUtil.getOrDefault(xferTimeMap, index, 0L));
            diskStore.setTimeStamp(MapUtil.getOrDefault(timeStampMap, index, 0L));
            return true;
        }
        return false;
    }

    @Override
    public HWDiskStore[] getDisks() {
        ArrayList<HWDiskStore> result = new ArrayList<HWDiskStore>();
        WindowsDisks.populateReadWriteMaps(null);
        this.populatePartitionMaps();
        WbemcliUtil.WmiResult<DiskDriveProperty> vals = WmiUtil.queryWMI(DISK_DRIVE_QUERY);
        for (int i = 0; i < vals.getResultCount(); ++i) {
            HWDiskStore ds = new HWDiskStore();
            ds.setName(vals.getString(DiskDriveProperty.NAME, i));
            ds.setModel(String.format("%s %s", vals.getString(DiskDriveProperty.MODEL, i), vals.getString(DiskDriveProperty.MANUFACTURER, i)).trim());
            ds.setSerial(ParseUtil.hexStringToString(vals.getString(DiskDriveProperty.SERIALNUMBER, i)));
            String index = vals.getInteger(DiskDriveProperty.INDEX, i).toString();
            ds.setReads(MapUtil.getOrDefault(readMap, index, 0L));
            ds.setReadBytes(MapUtil.getOrDefault(readByteMap, index, 0L));
            ds.setWrites(MapUtil.getOrDefault(writeMap, index, 0L));
            ds.setWriteBytes(MapUtil.getOrDefault(writeByteMap, index, 0L));
            ds.setTransferTime(MapUtil.getOrDefault(xferTimeMap, index, 0L));
            ds.setTimeStamp(MapUtil.getOrDefault(timeStampMap, index, 0L));
            ds.setSize(ParseUtil.parseLongOrDefault(vals.getString(DiskDriveProperty.SIZE, i), 0L));
            ArrayList<HWPartition> partitions = new ArrayList<HWPartition>();
            List<String> partList = driveToPartitionMap.get(ds.getName());
            if (partList != null && !partList.isEmpty()) {
                for (String part : partList) {
                    if (!partitionMap.containsKey(part)) continue;
                    partitions.add(partitionMap.get(part));
                }
            }
            ds.setPartitions(partitions.toArray(new HWPartition[partitions.size()]));
            result.add(ds);
        }
        return result.toArray(new HWDiskStore[result.size()]);
    }

    private static void populateReadWriteMaps(String index) {
        PdhUtil.PdhEnumObjectItems objectItems;
        if (index == null) {
            readMap.clear();
            readByteMap.clear();
            writeMap.clear();
            writeByteMap.clear();
            xferTimeMap.clear();
            timeStampMap.clear();
        }
        if (physicalDiskQuery != null) {
            WbemcliUtil.WmiResult<PhysicalDiskProperty> result = WmiUtil.queryWMI(physicalDiskQuery);
            for (int i = 0; i < result.getResultCount(); ++i) {
                String name = WindowsDisks.getIndexFromName(result.getString(PhysicalDiskProperty.NAME, i));
                if (index != null && !index.equals(name) || TOTAL_INSTANCE.equals(name)) continue;
                readMap.put(name, result.getInteger(PhysicalDiskProperty.DISKREADSPERSEC, i).longValue());
                readByteMap.put(name, ParseUtil.parseLongOrDefault(result.getString(PhysicalDiskProperty.DISKREADBYTESPERSEC, i), 0L));
                writeMap.put(name, result.getInteger(PhysicalDiskProperty.DISKWRITESPERSEC, i).longValue());
                writeByteMap.put(name, ParseUtil.parseLongOrDefault(result.getString(PhysicalDiskProperty.DISKWRITEBYTESPERSEC, i), 0L));
                xferTimeMap.put(name, ParseUtil.parseLongOrDefault(result.getString(PhysicalDiskProperty.PERCENTDISKTIME, i), 0L) / 10000L);
                long timestamp = ParseUtil.parseLongOrDefault(result.getString(PhysicalDiskProperty.TIMESTAMP_SYS100NS, i), 0L);
                timeStampMap.put(name, timestamp > 0L ? PerfDataUtil.filetimeToUtcMs(timestamp, false) : System.currentTimeMillis());
            }
            return;
        }
        try {
            objectItems = PdhUtil.PdhEnumObjectItems(null, null, PHYSICAL_DISK_LOCALIZED, 100);
        }
        catch (PdhUtil.PdhException e) {
            LOG.error("Unable to enumerate instances for {}.", (Object)PHYSICAL_DISK_LOCALIZED);
            return;
        }
        List<String> instances = objectItems.getInstances();
        instances.remove(TOTAL_INSTANCE);
        HashSet<String> unseenInstances = new HashSet<String>(diskReadsCounterMap.keySet());
        for (String instance : instances) {
            PerfDataUtil.PerfCounter counter;
            unseenInstances.remove(instance);
            if (!diskReadsCounterMap.containsKey(instance)) {
                counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Disk Reads/sec");
                diskReadsCounterMap.put(instance, counter);
                if (!PerfDataUtil.addCounterToQuery(counter)) {
                    diskReadsCounterMap.remove(instance);
                }
            }
            if (!diskReadBytesCounterMap.containsKey(instance)) {
                counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Disk Read Bytes/sec");
                diskReadBytesCounterMap.put(instance, counter);
                if (!PerfDataUtil.addCounterToQuery(counter)) {
                    diskReadBytesCounterMap.remove(instance);
                }
            }
            if (!diskWritesCounterMap.containsKey(instance)) {
                counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Disk Writes/sec");
                diskWritesCounterMap.put(instance, counter);
                if (!PerfDataUtil.addCounterToQuery(counter)) {
                    diskWritesCounterMap.remove(instance);
                }
            }
            if (!diskWriteBytesCounterMap.containsKey(instance)) {
                counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Disk Write Bytes/sec");
                diskWriteBytesCounterMap.put(instance, counter);
                if (!PerfDataUtil.addCounterToQuery(counter)) {
                    diskWriteBytesCounterMap.remove(instance);
                }
            }
            if (diskXferTimeCounterMap.containsKey(instance)) continue;
            counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "% Disk Time");
            diskXferTimeCounterMap.put(instance, counter);
            if (PerfDataUtil.addCounterToQuery(counter)) continue;
            diskXferTimeCounterMap.remove(instance);
        }
        long timestamp = PerfDataUtil.updateQuery(PHYSICAL_DISK);
        for (String instance : instances) {
            String name = WindowsDisks.getIndexFromName(instance);
            if (index != null && !index.equals(name)) continue;
            readMap.put(name, PerfDataUtil.queryCounter(diskReadsCounterMap.get(instance)));
            readByteMap.put(name, PerfDataUtil.queryCounter(diskReadBytesCounterMap.get(instance)));
            writeMap.put(name, PerfDataUtil.queryCounter(diskWritesCounterMap.get(instance)));
            writeByteMap.put(name, PerfDataUtil.queryCounter(diskWriteBytesCounterMap.get(instance)));
            xferTimeMap.put(name, PerfDataUtil.queryCounter(diskXferTimeCounterMap.get(instance)) / 10000L);
            timeStampMap.put(name, timestamp);
        }
        for (String instance : unseenInstances) {
            PerfDataUtil.PerfCounter counter = diskReadsCounterMap.get(instance);
            PerfDataUtil.removeCounterFromQuery(counter);
            counter = diskReadBytesCounterMap.get(instance);
            PerfDataUtil.removeCounterFromQuery(counter);
            counter = diskWritesCounterMap.get(instance);
            PerfDataUtil.removeCounterFromQuery(counter);
            counter = diskWriteBytesCounterMap.get(instance);
            PerfDataUtil.removeCounterFromQuery(counter);
            counter = diskXferTimeCounterMap.get(instance);
            PerfDataUtil.removeCounterFromQuery(counter);
        }
    }

    private void populatePartitionMaps() {
        Matcher mDep;
        Matcher mAnt;
        driveToPartitionMap.clear();
        partitionToLogicalDriveMap.clear();
        partitionMap.clear();
        WbemcliUtil.WmiResult<DriveToPartitionProperty> drivePartitionMap = WmiUtil.queryWMI(DRIVE_TO_PARTITION_QUERY);
        for (int i = 0; i < drivePartitionMap.getResultCount(); ++i) {
            mAnt = DEVICE_ID.matcher(drivePartitionMap.getString(DriveToPartitionProperty.ANTECEDENT, i));
            mDep = DEVICE_ID.matcher(drivePartitionMap.getString(DriveToPartitionProperty.DEPENDENT, i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            MapUtil.createNewListIfAbsent(driveToPartitionMap, mAnt.group(1).replaceAll("\\\\\\\\", "\\\\")).add(mDep.group(1));
        }
        WbemcliUtil.WmiResult<DriveToPartitionProperty> diskPartitionMap = WmiUtil.queryWMI(DISK_TO_PARTITION_QUERY);
        for (int i = 0; i < diskPartitionMap.getResultCount(); ++i) {
            mAnt = DEVICE_ID.matcher(diskPartitionMap.getString(DriveToPartitionProperty.ANTECEDENT, i));
            mDep = DEVICE_ID.matcher(diskPartitionMap.getString(DriveToPartitionProperty.DEPENDENT, i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            partitionToLogicalDriveMap.put(mAnt.group(1), mDep.group(1) + "\\");
        }
        WbemcliUtil.WmiResult<DiskPartitionProperty> hwPartitionQueryMap = WmiUtil.queryWMI(PARTITION_QUERY);
        for (int i = 0; i < hwPartitionQueryMap.getResultCount(); ++i) {
            String deviceID = hwPartitionQueryMap.getString(DiskPartitionProperty.DEVICEID, i);
            String logicalDrive = MapUtil.getOrDefault(partitionToLogicalDriveMap, deviceID, "");
            String uuid = "";
            if (!logicalDrive.isEmpty()) {
                char[] volumeChr = new char[255];
                Kernel32.INSTANCE.GetVolumeNameForVolumeMountPoint(logicalDrive, volumeChr, 255);
                uuid = ParseUtil.parseUuidOrDefault(new String(volumeChr).trim(), "");
            }
            partitionMap.put(deviceID, new HWPartition(hwPartitionQueryMap.getString(DiskPartitionProperty.NAME, i), hwPartitionQueryMap.getString(DiskPartitionProperty.TYPE, i), hwPartitionQueryMap.getString(DiskPartitionProperty.DESCRIPTION, i), uuid, ParseUtil.parseLongOrDefault(hwPartitionQueryMap.getString(DiskPartitionProperty.SIZE, i), 0L), hwPartitionQueryMap.getInteger(DiskPartitionProperty.DISKINDEX, i), hwPartitionQueryMap.getInteger(DiskPartitionProperty.INDEX, i), logicalDrive));
        }
    }

    private static String getIndexFromName(String s) {
        if (s.isEmpty()) {
            return s;
        }
        return s.split("\\s")[0];
    }

    static {
        String physicalDisk = PdhUtil.PdhLookupPerfNameByIndex(null, PdhUtil.PdhLookupPerfIndexByEnglishName(PHYSICAL_DISK));
        boolean enumeration = true;
        try {
            PdhUtil.PdhEnumObjectItems objectItems = PdhUtil.PdhEnumObjectItems(null, null, physicalDisk, 100);
            if (!objectItems.getInstances().isEmpty()) {
                List<String> instances = objectItems.getInstances();
                for (int i = 0; i < instances.size(); ++i) {
                    String instance = instances.get(i);
                    PerfDataUtil.PerfCounter counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Disk Reads/sec");
                    diskReadsCounterMap.put(instance, counter);
                    if (!PerfDataUtil.addCounterToQuery(counter)) {
                        throw new PdhUtil.PdhException(0);
                    }
                    counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Disk Read Bytes/sec");
                    diskReadBytesCounterMap.put(instance, counter);
                    if (!PerfDataUtil.addCounterToQuery(counter)) {
                        throw new PdhUtil.PdhException(0);
                    }
                    counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Disk Writes/sec");
                    diskWritesCounterMap.put(instance, counter);
                    if (!PerfDataUtil.addCounterToQuery(counter)) {
                        throw new PdhUtil.PdhException(0);
                    }
                    counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "Disk Write Bytes/sec");
                    diskWriteBytesCounterMap.put(instance, counter);
                    if (!PerfDataUtil.addCounterToQuery(counter)) {
                        throw new PdhUtil.PdhException(0);
                    }
                    counter = PerfDataUtil.createCounter(PHYSICAL_DISK, instance, "% Disk Time");
                    diskXferTimeCounterMap.put(instance, counter);
                    if (PerfDataUtil.addCounterToQuery(counter)) continue;
                    throw new PdhUtil.PdhException(0);
                }
            }
        }
        catch (PdhUtil.PdhException e) {
            LOG.warn("Unable to enumerate performance counter instances for {}.", (Object)physicalDisk);
            enumeration = false;
        }
        if (!enumeration) {
            PerfDataUtil.removeAllCounters(PHYSICAL_DISK);
            diskReadsCounterMap = null;
            diskReadBytesCounterMap = null;
            diskWritesCounterMap = null;
            diskWriteBytesCounterMap = null;
            diskXferTimeCounterMap = null;
            physicalDiskQuery = WbemcliUtil.createQuery("Win32_PerfRawData_PerfDisk_PhysicalDisk", PhysicalDiskProperty.class);
        }
    }

    static enum PhysicalDiskProperty {
        NAME,
        DISKREADSPERSEC,
        DISKREADBYTESPERSEC,
        DISKWRITESPERSEC,
        DISKWRITEBYTESPERSEC,
        PERCENTDISKTIME,
        TIMESTAMP_SYS100NS;

    }

    static enum DiskPartitionProperty {
        DESCRIPTION,
        DEVICEID,
        DISKINDEX,
        INDEX,
        NAME,
        SIZE,
        TYPE;

    }

    static enum DriveToPartitionProperty {
        ANTECEDENT,
        DEPENDENT;

    }

    static enum DiskDriveProperty {
        INDEX,
        MANUFACTURER,
        MODEL,
        NAME,
        SERIALNUMBER,
        SIZE;

    }
}

