/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.language.settings.providers;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncherManager;
import org.eclipse.cdt.core.language.settings.providers.ICListenerAgent;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsBroadcastingProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsChangeEvent;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsChangeListener;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsSerializableProvider;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsStorage;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.XmlUtil;
import org.eclipse.cdt.internal.core.language.settings.providers.LanguageSettingsDelta;
import org.eclipse.cdt.internal.core.language.settings.providers.LanguageSettingsExtensionManager;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationSpecSettings;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LanguageSettingsProvidersSerializer {
    public static final String PROVIDER_EXTENSION_POINT_ID = "org.eclipse.cdt.core.LanguageSettingsProvider";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_CLASS = "class";
    public static final String ELEM_PROVIDER = "provider";
    public static final String ELEM_LANGUAGE_SCOPE = "language-scope";
    public static final String JOB_FAMILY_SERIALIZE_LANGUAGE_SETTINGS_PROJECT = "CDT_JOB_FAMILY_SERIALIZE_LANGUAGE_SETTINGS_PROJECT";
    public static final String JOB_FAMILY_SERIALIZE_LANGUAGE_SETTINGS_WORKSPACE = "CDT_JOB_FAMILY_SERIALIZE_LANGUAGE_SETTINGS_WORKSPACE";
    private static final String PREFERENCE_WORSPACE_PROVIDERS_SET = "language.settings.providers.workspace.prefs.toggle";
    private static final String CPROJECT_STORAGE_MODULE_LANGUAGE_SETTINGS_PROVIDERS = "org.eclipse.cdt.core.LanguageSettingsProviders";
    private static final String STORAGE_WORKSPACE_LANGUAGE_SETTINGS = "language.settings.xml";
    private static final String STORAGE_PROJECT_PATH = ".settings/language.settings.xml";
    private static final int PROGRESS_MONITOR_SCALE = 100;
    private static final int TICKS_SERIALIZING = 100;
    private static final String ELEM_PLUGIN = "plugin";
    private static final String ELEM_EXTENSION = "extension";
    private static final String ATTR_EXTENSION_POINT = "point";
    private static final String ELEM_PROJECT = "project";
    private static final String ELEM_CONFIGURATION = "configuration";
    private static final String ELEM_PROVIDER_REFERENCE = "provider-reference";
    private static final String ATTR_STORE_ENTRIES_WITH_PROJECT = "store-entries-with-project";
    private static final String ATTR_REF = "ref";
    private static final String VALUE_REF_SHARED_PROVIDER = "shared-provider";
    private static final String ATTR_COPY_OF = "copy-of";
    private static final String VALUE_COPY_OF_EXTENSION = "extension";
    private static Map<String, ILanguageSettingsProvider> rawGlobalWorkspaceProviders = new HashMap<String, ILanguageSettingsProvider>();
    private static Map<String, ILanguageSettingsProvider> globalWorkspaceProviders = new HashMap<String, ILanguageSettingsProvider>();
    private static ListenerList<ILanguageSettingsChangeListener> fLanguageSettingsChangeListeners = new ListenerList(1);
    private static ILock serializingLock = Job.getJobManager().newLock();
    private static ILock serializingLockWsp = Job.getJobManager().newLock();

    static {
        try {
            LanguageSettingsProvidersSerializer.loadLanguageSettingsWorkspace();
        }
        catch (Throwable e) {
            CCorePlugin.log("Error loading workspace language settings providers", e);
        }
    }

    public static boolean isStoringEntriesInProjectArea(LanguageSettingsSerializableProvider provider) {
        return provider.getPropertyBool(ATTR_STORE_ENTRIES_WITH_PROJECT);
    }

    public static void setStoringEntriesInProjectArea(LanguageSettingsSerializableProvider provider, boolean storeEntriesWithProject) {
        provider.setPropertyBool(ATTR_STORE_ENTRIES_WITH_PROJECT, storeEntriesWithProject);
    }

    private static IFile getStoreInProjectArea(IProject project) {
        return project.getFile(STORAGE_PROJECT_PATH);
    }

    private static URI getStoreInWorkspaceArea(String store) {
        IPath location = CCorePlugin.getDefault().getStateLocation().append(store);
        return URIUtil.toURI((IPath)location);
    }

    public static void setWorkspaceProviders(List<ILanguageSettingsProvider> providers) throws CoreException {
        LanguageSettingsProvidersSerializer.setWorkspaceProvidersInternal(providers);
        LanguageSettingsProvidersSerializer.serializeLanguageSettingsWorkspaceInBackground();
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core");
        prefs.putBoolean(PREFERENCE_WORSPACE_PROVIDERS_SET, !prefs.getBoolean(PREFERENCE_WORSPACE_PROVIDERS_SET, false));
    }

    private static void setWorkspaceProvidersInternal(List<ILanguageSettingsProvider> providers) {
        LanguageSettingsWorkspaceProvider wspProvider;
        HashMap<String, ILanguageSettingsProvider> rawNewProviders = new HashMap<String, ILanguageSettingsProvider>();
        if (providers != null) {
            for (ILanguageSettingsProvider provider : providers) {
                if (LanguageSettingsProvidersSerializer.isWorkspaceProvider(provider)) {
                    provider = rawGlobalWorkspaceProviders.get(provider.getId());
                }
                if (provider == null) continue;
                rawNewProviders.put(provider.getId(), provider);
            }
        }
        for (String id : LanguageSettingsExtensionManager.getExtensionProviderIds()) {
            if (rawNewProviders.containsKey(id)) continue;
            ILanguageSettingsProvider provider = LanguageSettingsExtensionManager.getExtensionProviderCopy(id, true);
            if (provider == null) {
                provider = LanguageSettingsExtensionManager.loadProvider(id);
            }
            if (provider == null) continue;
            rawNewProviders.put(provider.getId(), provider);
        }
        List<ICListenerAgent> oldListeners = LanguageSettingsProvidersSerializer.selectListeners(rawGlobalWorkspaceProviders.values());
        List<ICListenerAgent> newListeners = LanguageSettingsProvidersSerializer.selectListeners(rawNewProviders.values());
        for (ICListenerAgent oldListener : oldListeners) {
            if (LanguageSettingsProvidersSerializer.isInList(newListeners, oldListener) || (wspProvider = (LanguageSettingsWorkspaceProvider)globalWorkspaceProviders.get(((ILanguageSettingsProvider)((Object)oldListener)).getId())) == null || wspProvider.getProjectCount() <= 0) continue;
            oldListener.unregisterListener();
        }
        for (ICListenerAgent newListener : newListeners) {
            if (LanguageSettingsProvidersSerializer.isInList(oldListeners, newListener) || (wspProvider = (LanguageSettingsWorkspaceProvider)globalWorkspaceProviders.get(((ILanguageSettingsProvider)((Object)newListener)).getId())) == null || wspProvider.getProjectCount() <= 0) continue;
            newListener.registerListener(null);
        }
        rawGlobalWorkspaceProviders = rawNewProviders;
    }

    private static LanguageSettingsChangeEvent createEvent(ICProjectDescription prjDescription, List<String> providerIds) {
        ICConfigurationDescription[] cfgDescriptions;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgDescriptions = prjDescription.getConfigurations();
        int n = cfgDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfgDescription = iCConfigurationDescriptionArray[n2];
            if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
                for (ILanguageSettingsProvider provider : ((ILanguageSettingsProvidersKeeper)((Object)cfgDescription)).getLanguageSettingProviders()) {
                    if (!LanguageSettingsProvidersSerializer.isWorkspaceProvider(provider) || !providerIds.contains(provider.getId())) continue;
                    LanguageSettingsChangeEvent event = new LanguageSettingsChangeEvent(prjDescription);
                    if (event.getConfigurationDescriptionIds().length > 0) {
                        return event;
                    }
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }

    private static List<LanguageSettingsChangeEvent> createLanguageSettingsChangeEvents(List<ILanguageSettingsBroadcastingProvider> providers) {
        IProject[] projects;
        ArrayList<LanguageSettingsChangeEvent> events = new ArrayList<LanguageSettingsChangeEvent>();
        ArrayList<String> providerIds = new ArrayList<String>();
        for (ILanguageSettingsBroadcastingProvider provider : providers) {
            providerIds.add(provider.getId());
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                LanguageSettingsChangeEvent event;
                ICProjectDescription prjDescription;
                if (project.isAccessible() && (prjDescription = CCorePlugin.getDefault().getProjectDescription(project, false)) != null && (event = LanguageSettingsProvidersSerializer.createEvent(prjDescription, providerIds)) != null) {
                    events.add(event);
                }
            }
            catch (Throwable e) {
                CCorePlugin.log("Error creating event about changes in workspace language settings providers, project=" + project.getName(), e);
            }
            ++n2;
        }
        return events;
    }

    public static void serializeLanguageSettingsWorkspace() throws CoreException {
        URI uriStoreWsp = LanguageSettingsProvidersSerializer.getStoreInWorkspaceArea(STORAGE_WORKSPACE_LANGUAGE_SETTINGS);
        ArrayList<ILanguageSettingsBroadcastingProvider> broadcastingWorkspaceProviders = new ArrayList<ILanguageSettingsBroadcastingProvider>();
        ArrayList<LanguageSettingsSerializableProvider> serializingWorkspaceProviders = new ArrayList<LanguageSettingsSerializableProvider>();
        for (ILanguageSettingsProvider provider : rawGlobalWorkspaceProviders.values()) {
            if (provider instanceof ILanguageSettingsBroadcastingProvider) {
                broadcastingWorkspaceProviders.add((ILanguageSettingsBroadcastingProvider)provider);
            }
            if (!(provider instanceof LanguageSettingsSerializableProvider) || LanguageSettingsManager.isEqualExtensionProvider(provider, true)) continue;
            serializingWorkspaceProviders.add((LanguageSettingsSerializableProvider)provider);
        }
        try {
            List<LanguageSettingsChangeEvent> events = null;
            if (serializingWorkspaceProviders.isEmpty()) {
                File fileStoreWsp = new File(uriStoreWsp);
                try {
                    serializingLockWsp.acquire();
                    fileStoreWsp.delete();
                    events = LanguageSettingsProvidersSerializer.createLanguageSettingsChangeEvents(broadcastingWorkspaceProviders);
                }
                finally {
                    serializingLockWsp.release();
                }
            }
            Document doc = XmlUtil.newDocument();
            Element rootElement = XmlUtil.appendElement(doc, ELEM_PLUGIN);
            Element elementExtension = XmlUtil.appendElement(rootElement, "extension", new String[]{ATTR_EXTENSION_POINT, PROVIDER_EXTENSION_POINT_ID});
            for (LanguageSettingsSerializableProvider provider : serializingWorkspaceProviders) {
                provider.serialize(elementExtension);
            }
            try {
                serializingLockWsp.acquire();
                XmlUtil.serializeXml(doc, uriStoreWsp);
                events = LanguageSettingsProvidersSerializer.createLanguageSettingsChangeEvents(broadcastingWorkspaceProviders);
            }
            finally {
                serializingLockWsp.release();
            }
            for (LanguageSettingsChangeEvent event : events) {
                LanguageSettingsProvidersSerializer.notifyLanguageSettingsChangeListeners(event);
            }
        }
        catch (Exception e) {
            String msg = "Internal error while trying to serialize language settings";
            CCorePlugin.log(msg, e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", msg, (Throwable)e));
        }
    }

    public static void serializeLanguageSettingsWorkspaceInBackground() {
        Object job;
        Job[] jobs;
        Job[] jobArray = jobs = Job.getJobManager().find((Object)JOB_FAMILY_SERIALIZE_LANGUAGE_SETTINGS_WORKSPACE);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            job = jobArray[n2];
            if (job.getState() == 2) {
                return;
            }
            ++n2;
        }
        job = new WorkspaceJob(SettingsModelMessages.getString("LanguageSettingsProvidersSerializer.SerializeJobName")){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask(SettingsModelMessages.getString("LanguageSettingsProvidersSerializer.SerializingForWorkspace"), 100);
                    LanguageSettingsProvidersSerializer.serializeLanguageSettingsWorkspace();
                    monitor.worked(100);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Throwable e) {
                    String msg = "Internal error running job of serializing language settings in workspace";
                    Status status = new Status(4, "org.eclipse.cdt.core", msg, e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }

            public boolean belongsTo(Object family) {
                return family == LanguageSettingsProvidersSerializer.JOB_FAMILY_SERIALIZE_LANGUAGE_SETTINGS_WORKSPACE;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    public static void loadLanguageSettingsWorkspace() {
        Document doc;
        ArrayList<ILanguageSettingsProvider> providers;
        block15: {
            try {
                Job.getJobManager().join((Object)JOB_FAMILY_SERIALIZE_LANGUAGE_SETTINGS_WORKSPACE, null);
            }
            catch (OperationCanceledException e) {
                return;
            }
            catch (InterruptedException e) {
                CCorePlugin.log(e);
                Thread.currentThread().interrupt();
            }
            providers = null;
            URI uriStoreWsp = LanguageSettingsProvidersSerializer.getStoreInWorkspaceArea(STORAGE_WORKSPACE_LANGUAGE_SETTINGS);
            doc = null;
            try {
                try {
                    serializingLockWsp.acquire();
                    doc = XmlUtil.loadXml(uriStoreWsp);
                }
                catch (Exception e) {
                    CCorePlugin.log("Can't load preferences from file " + uriStoreWsp, e);
                    serializingLockWsp.release();
                    break block15;
                }
            }
            catch (Throwable throwable) {
                serializingLockWsp.release();
                throw throwable;
            }
            serializingLockWsp.release();
        }
        if (doc != null) {
            Element rootElement = doc.getDocumentElement();
            NodeList providerNodes = rootElement.getElementsByTagName(ELEM_PROVIDER);
            ArrayList<String> userDefinedProvidersIds = new ArrayList<String>(providerNodes.getLength());
            providers = new ArrayList<ILanguageSettingsProvider>(providerNodes.getLength());
            int i = 0;
            while (i < providerNodes.getLength()) {
                Node providerNode = providerNodes.item(i);
                String providerId = XmlUtil.determineAttributeValue(providerNode, ATTR_ID);
                if (userDefinedProvidersIds.contains(providerId)) {
                    String msg = "Ignored an attempt to persist duplicate language settings provider, id=" + providerId;
                    CCorePlugin.log((IStatus)new Status(2, "org.eclipse.cdt.core", msg, (Throwable)new Exception()));
                } else {
                    userDefinedProvidersIds.add(providerId);
                    ILanguageSettingsProvider provider = null;
                    try {
                        provider = LanguageSettingsProvidersSerializer.loadProvider(providerNode);
                    }
                    catch (Exception e) {
                        CCorePlugin.log("Error initializing workspace language settings providers", e);
                    }
                    if (provider == null) {
                        provider = new NotAccessibleProvider(providerId);
                    }
                    providers.add(provider);
                }
                ++i;
            }
        }
        LanguageSettingsProvidersSerializer.setWorkspaceProvidersInternal(providers);
    }

    public static void serializeLanguageSettingsInternal(Element projectElementPrjStore, Element projectElementWspStore, ICProjectDescription prjDescription) {
        ICConfigurationDescription[] cfgDescriptions;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgDescriptions = prjDescription.getConfigurations();
        int n = cfgDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfgDescription = iCConfigurationDescriptionArray[n2];
            if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
                Element elementConfiguration = XmlUtil.appendElement(projectElementPrjStore, ELEM_CONFIGURATION, new String[]{ATTR_ID, cfgDescription.getId(), ATTR_NAME, cfgDescription.getName()});
                Element elementConfigurationWsp = null;
                List<ILanguageSettingsProvider> providers = ((ILanguageSettingsProvidersKeeper)((Object)cfgDescription)).getLanguageSettingProviders();
                if (providers.size() > 0) {
                    Element elementExtension = null;
                    Element elementExtensionWsp = null;
                    for (ILanguageSettingsProvider provider : providers) {
                        if (LanguageSettingsProvidersSerializer.isWorkspaceProvider(provider)) {
                            if (elementExtension == null) {
                                elementExtension = XmlUtil.appendElement(elementConfiguration, "extension", new String[]{ATTR_EXTENSION_POINT, PROVIDER_EXTENSION_POINT_ID});
                            }
                            XmlUtil.appendElement(elementExtension, ELEM_PROVIDER_REFERENCE, new String[]{ATTR_ID, provider.getId(), ATTR_REF, VALUE_REF_SHARED_PROVIDER});
                            continue;
                        }
                        if (!(provider instanceof LanguageSettingsSerializableProvider)) {
                            if (elementExtension == null) {
                                elementExtension = XmlUtil.appendElement(elementConfiguration, "extension", new String[]{ATTR_EXTENSION_POINT, PROVIDER_EXTENSION_POINT_ID});
                            }
                            XmlUtil.appendElement(elementExtension, ELEM_PROVIDER, new String[]{ATTR_ID, provider.getId(), ATTR_NAME, provider.getName(), ATTR_CLASS, provider.getClass().getCanonicalName()});
                            continue;
                        }
                        if (LanguageSettingsManager.isEqualExtensionProvider(provider, true)) {
                            if (elementExtension == null) {
                                elementExtension = XmlUtil.appendElement(elementConfiguration, "extension", new String[]{ATTR_EXTENSION_POINT, PROVIDER_EXTENSION_POINT_ID});
                            }
                            XmlUtil.appendElement(elementExtension, ELEM_PROVIDER, new String[]{ATTR_ID, provider.getId(), ATTR_COPY_OF, "extension"});
                            continue;
                        }
                        try {
                            boolean isWspStorageAvailable;
                            LanguageSettingsSerializableProvider lss = (LanguageSettingsSerializableProvider)provider;
                            boolean bl = isWspStorageAvailable = projectElementWspStore != null && projectElementPrjStore != projectElementWspStore;
                            if (LanguageSettingsProvidersSerializer.isStoringEntriesInProjectArea(lss) || !isWspStorageAvailable) {
                                if (elementExtension == null) {
                                    elementExtension = XmlUtil.appendElement(elementConfiguration, "extension", new String[]{ATTR_EXTENSION_POINT, PROVIDER_EXTENSION_POINT_ID});
                                }
                                lss.serialize(elementExtension);
                                continue;
                            }
                            if (elementExtension == null) {
                                elementExtension = XmlUtil.appendElement(elementConfiguration, "extension", new String[]{ATTR_EXTENSION_POINT, PROVIDER_EXTENSION_POINT_ID});
                            }
                            if (elementExtensionWsp == null) {
                                if (elementConfigurationWsp == null) {
                                    elementConfigurationWsp = XmlUtil.appendElement(projectElementWspStore, ELEM_CONFIGURATION, new String[]{ATTR_ID, cfgDescription.getId(), ATTR_NAME, cfgDescription.getName()});
                                }
                                elementExtensionWsp = XmlUtil.appendElement(elementConfigurationWsp, "extension", new String[]{ATTR_EXTENSION_POINT, PROVIDER_EXTENSION_POINT_ID});
                            }
                            Element elementProviderWsp = XmlUtil.appendElement(elementExtensionWsp, ELEM_PROVIDER, new String[]{ATTR_ID, provider.getId()});
                            lss.serializeAttributes(elementExtension);
                            lss.serializeEntries(elementProviderWsp);
                        }
                        catch (Throwable e) {
                            CCorePlugin.log("Exception trying serialize provider " + provider.getId(), e);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private static boolean isEqualToDefaultProviders(ICProjectDescription prjDescription) {
        ICConfigurationDescription[] cfgDescriptions;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgDescriptions = prjDescription.getConfigurations();
        int n = cfgDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfgDescription = iCConfigurationDescriptionArray[n2];
            if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
                List<ILanguageSettingsProvider> providers;
                String[] defaultIds = ((ILanguageSettingsProvidersKeeper)((Object)cfgDescription)).getDefaultLanguageSettingsProvidersIds();
                if (defaultIds == null) {
                    defaultIds = ScannerDiscoveryLegacySupport.getDefaultProviderIdsLegacy(cfgDescription);
                }
                if ((providers = ((ILanguageSettingsProvidersKeeper)((Object)cfgDescription)).getLanguageSettingProviders()).size() != defaultIds.length) {
                    return false;
                }
                int i = 0;
                while (i < defaultIds.length) {
                    ILanguageSettingsProvider provider = providers.get(i);
                    if (!provider.getId().equals(defaultIds[i])) {
                        return false;
                    }
                    ++i;
                }
                for (ILanguageSettingsProvider provider : providers) {
                    if (!(LanguageSettingsManager.isPreferShared(provider.getId()) ? !LanguageSettingsProvidersSerializer.isWorkspaceProvider(provider) : !LanguageSettingsManager.isEqualExtensionProvider(provider, true))) continue;
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public static void serializeLanguageSettings(ICProjectDescription prjDescription) throws CoreException {
        IProject project = prjDescription.getProject();
        try {
            prjDescription.getStorage(CPROJECT_STORAGE_MODULE_LANGUAGE_SETTINGS_PROVIDERS, true);
        }
        catch (CoreException e) {
            CCorePlugin.log("Internal error while trying to serialize language settings", e);
        }
        try {
            Document docStorePrj = XmlUtil.newDocument();
            Element projectElementStorePrj = XmlUtil.appendElement(docStorePrj, ELEM_PROJECT);
            Document docStoreWsp = XmlUtil.newDocument();
            Element projectElementStoreWsp = XmlUtil.appendElement(docStoreWsp, ELEM_PROJECT);
            URI uriStoreWsp = LanguageSettingsProvidersSerializer.getStoreInWorkspaceArea(String.valueOf(project.getName()) + '.' + STORAGE_WORKSPACE_LANGUAGE_SETTINGS);
            LanguageSettingsChangeEvent event = null;
            try {
                boolean isWorkspaceStoreEmpty;
                boolean isProjectStoreEmpty;
                serializingLock.acquire();
                if (!LanguageSettingsProvidersSerializer.isEqualToDefaultProviders(prjDescription)) {
                    LanguageSettingsProvidersSerializer.serializeLanguageSettingsInternal(projectElementStorePrj, projectElementStoreWsp, prjDescription);
                }
                IFile fileStorePrj = LanguageSettingsProvidersSerializer.getStoreInProjectArea(project);
                boolean bl = isProjectStoreEmpty = projectElementStorePrj.getChildNodes().getLength() == 0;
                if (isProjectStoreEmpty) {
                    if (fileStorePrj.exists()) {
                        fileStorePrj.delete(true, null);
                    }
                } else {
                    IStatus editStatus;
                    if (fileStorePrj.isReadOnly() && !(editStatus = project.getWorkspace().validateEdit(new IFile[]{fileStorePrj}, IWorkspace.VALIDATE_PROMPT)).isOK()) {
                        throw new CoreException(editStatus);
                    }
                    IContainer folder = fileStorePrj.getParent();
                    if (folder instanceof IFolder && !folder.exists()) {
                        ((IFolder)folder).create(true, true, null);
                    }
                    XmlUtil.serializeXml(docStorePrj, fileStorePrj);
                }
                boolean bl2 = isWorkspaceStoreEmpty = projectElementStoreWsp.getChildNodes().getLength() == 0;
                if (isWorkspaceStoreEmpty) {
                    new File(uriStoreWsp).delete();
                } else {
                    XmlUtil.serializeXml(docStoreWsp, uriStoreWsp);
                }
                event = new LanguageSettingsChangeEvent(prjDescription);
            }
            finally {
                serializingLock.release();
            }
            if (event.getConfigurationDescriptionIds().length > 0) {
                LanguageSettingsProvidersSerializer.notifyLanguageSettingsChangeListeners(event);
            }
        }
        catch (Exception e) {
            String msg = "Internal error while trying to serialize language settings";
            CCorePlugin.log(msg, e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", msg, (Throwable)e));
        }
    }

    public static void serializeLanguageSettingsInBackground(final ICProjectDescription prjDescription) {
        Job job = new Job(SettingsModelMessages.getString("LanguageSettingsProvidersSerializer.SerializeJobName")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(NLS.bind((String)SettingsModelMessages.getString("LanguageSettingsProvidersSerializer.SerializingForProject"), (Object)prjDescription.getName()), 100);
                    LanguageSettingsProvidersSerializer.serializeLanguageSettings(prjDescription);
                    monitor.worked(100);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Throwable e) {
                    String msg = "Internal error running job of serializing language settings for project " + prjDescription.getName();
                    Status status = new Status(4, "org.eclipse.cdt.core", msg, e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }

            public boolean belongsTo(Object family) {
                return family == LanguageSettingsProvidersSerializer.JOB_FAMILY_SERIALIZE_LANGUAGE_SETTINGS_PROJECT;
            }
        };
        IWorkspaceRoot rule = null;
        IProject project = prjDescription.getProject();
        if (project != null) {
            IFile fileStorePrj = LanguageSettingsProvidersSerializer.getStoreInProjectArea(project);
            IContainer folder = fileStorePrj.getParent();
            if (folder instanceof IFolder && !folder.exists()) {
                try {
                    ((IFolder)folder).create(true, true, null);
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
            if (folder.isAccessible()) {
                rule = folder;
            }
        }
        if (rule == null) {
            rule = ResourcesPlugin.getWorkspace().getRoot();
        }
        job.setRule((ISchedulingRule)rule);
        job.schedule();
    }

    public static void loadLanguageSettingsInternal(Element projectElementPrj, Element projectElementWsp, ICProjectDescription prjDescription) {
        NodeList configurationNodes = projectElementPrj.getChildNodes();
        int ic = 0;
        while (ic < configurationNodes.getLength()) {
            Node cfgNode = configurationNodes.item(ic);
            if (LanguageSettingsProvidersSerializer.isElementWithName(cfgNode, ELEM_CONFIGURATION)) {
                ArrayList<ILanguageSettingsProvider> providers = new ArrayList<ILanguageSettingsProvider>();
                String cfgId = XmlUtil.determineAttributeValue(cfgNode, ATTR_ID);
                NodeList extensionNodes = cfgNode.getChildNodes();
                int ie = 0;
                while (ie < extensionNodes.getLength()) {
                    Node extNode = extensionNodes.item(ie);
                    if (LanguageSettingsProvidersSerializer.isElementWithName(extNode, "extension")) {
                        NodeList providerNodes = extNode.getChildNodes();
                        int ip = 0;
                        while (ip < providerNodes.getLength()) {
                            ILanguageSettingsProvider provider = null;
                            Node providerNode = providerNodes.item(ip);
                            if (LanguageSettingsProvidersSerializer.isElementWithName(providerNode, ELEM_PROVIDER_REFERENCE)) {
                                String providerId = XmlUtil.determineAttributeValue(providerNode, ATTR_ID);
                                provider = LanguageSettingsProvidersSerializer.getWorkspaceProvider(providerId);
                            } else if (LanguageSettingsProvidersSerializer.isElementWithName(providerNode, ELEM_PROVIDER)) {
                                String providerClass = XmlUtil.determineAttributeValue(providerNode, ATTR_CLASS);
                                if (providerClass == null || providerClass.isEmpty()) {
                                    String providerId = XmlUtil.determineAttributeValue(providerNode, ATTR_ID);
                                    provider = LanguageSettingsManager.getExtensionProviderCopy(providerId, true);
                                    if (provider == null) {
                                        msg = "Internal Error trying to retrieve copy of extension provider id=" + providerId;
                                        CCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.core", msg, (Throwable)new Exception(msg)));
                                        provider = LanguageSettingsManager.getWorkspaceProvider(providerId);
                                    }
                                } else {
                                    LanguageSettingsSerializableProvider lss;
                                    try {
                                        provider = LanguageSettingsProvidersSerializer.loadProvider(providerNode);
                                    }
                                    catch (CoreException e) {
                                        msg = "Error loading provider class=[" + providerClass + "] " + "in project=" + prjDescription.getProject().getName() + ", cfg=[" + cfgId + "]";
                                        CCorePlugin.log(msg, e);
                                    }
                                    if (provider instanceof LanguageSettingsSerializableProvider && !LanguageSettingsProvidersSerializer.isStoringEntriesInProjectArea(lss = (LanguageSettingsSerializableProvider)provider) && projectElementWsp != null) {
                                        LanguageSettingsProvidersSerializer.loadProviderEntries(lss, cfgId, projectElementWsp);
                                    }
                                }
                            }
                            if (provider != null) {
                                providers.add(provider);
                            }
                            ++ip;
                        }
                    }
                    ++ie;
                }
                ICConfigurationDescription cfgDescription = prjDescription.getConfigurationById(cfgId);
                LanguageSettingsProvidersSerializer.setProvidersWithoutNotification(cfgDescription, providers);
            }
            ++ic;
        }
    }

    private static void setProvidersWithoutNotification(ICConfigurationDescription cfgDescription, List<ILanguageSettingsProvider> providers) {
        if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
            ((ILanguageSettingsProvidersKeeper)((Object)cfgDescription)).setLanguageSettingProviders(providers);
            if (cfgDescription instanceof IInternalCCfgInfo) {
                try {
                    ((IInternalCCfgInfo)((Object)cfgDescription)).getSpecSettings().dropDelta();
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
        }
    }

    private static boolean isElementWithName(Node cfgNode, String name) {
        return cfgNode instanceof Element && cfgNode.getNodeName().equals(name);
    }

    private static void loadProviderEntries(LanguageSettingsSerializableProvider provider, String cfgId, Element projectElement) {
        NodeList configurationNodes = projectElement.getChildNodes();
        int ic = 0;
        while (ic < configurationNodes.getLength()) {
            String cfgIdXml;
            Node cfgNode = configurationNodes.item(ic);
            if (LanguageSettingsProvidersSerializer.isElementWithName(cfgNode, ELEM_CONFIGURATION) && cfgId.equals(cfgIdXml = XmlUtil.determineAttributeValue(cfgNode, ATTR_ID))) {
                NodeList extensionNodes = cfgNode.getChildNodes();
                int ie = 0;
                while (ie < extensionNodes.getLength()) {
                    Node extNode = extensionNodes.item(ie);
                    if (LanguageSettingsProvidersSerializer.isElementWithName(extNode, "extension")) {
                        NodeList providerNodes = extNode.getChildNodes();
                        int ip = 0;
                        while (ip < providerNodes.getLength()) {
                            Node providerNode = providerNodes.item(ip);
                            if (LanguageSettingsProvidersSerializer.isElementWithName(providerNode, ELEM_PROVIDER)) {
                                String id = XmlUtil.determineAttributeValue(providerNode, ATTR_ID);
                                if (provider.getId().equals(id)) {
                                    provider.loadEntries((Element)providerNode);
                                    return;
                                }
                            }
                            ++ip;
                        }
                    }
                    ++ie;
                }
            }
            ++ic;
        }
    }

    private static ILanguageSettingsProvider loadProvider(Node providerNode) throws CoreException {
        String attrClass = XmlUtil.determineAttributeValue(providerNode, ATTR_CLASS);
        ILanguageSettingsProvider provider = LanguageSettingsExtensionManager.instantiateProviderClass(attrClass);
        if (provider instanceof LanguageSettingsSerializableProvider) {
            ((LanguageSettingsSerializableProvider)provider).load((Element)providerNode);
        }
        return provider;
    }

    public static void loadLanguageSettings(ICProjectDescription prjDescription) {
        IProject project = prjDescription.getProject();
        IFile storeInPrjArea = LanguageSettingsProvidersSerializer.getStoreInProjectArea(project);
        boolean isStoreInProjectAreaExist = storeInPrjArea.exists();
        if (isStoreInProjectAreaExist) {
            Document doc = null;
            try {
                doc = XmlUtil.loadXml(storeInPrjArea);
                Element rootElementPrj = doc.getDocumentElement();
                URI uriStoreWsp = LanguageSettingsProvidersSerializer.getStoreInWorkspaceArea(String.valueOf(project.getName()) + '.' + STORAGE_WORKSPACE_LANGUAGE_SETTINGS);
                Document docWsp = null;
                try {
                    serializingLock.acquire();
                    docWsp = XmlUtil.loadXml(uriStoreWsp);
                }
                finally {
                    serializingLock.release();
                }
                Element rootElementWsp = null;
                if (docWsp != null) {
                    rootElementWsp = docWsp.getDocumentElement();
                }
                LanguageSettingsProvidersSerializer.loadLanguageSettingsInternal(rootElementPrj, rootElementWsp, prjDescription);
            }
            catch (Exception e) {
                CCorePlugin.log("Can't load preferences from file " + storeInPrjArea.getLocation(), e);
            }
        } else {
            ICConfigurationDescription[] iCConfigurationDescriptionArray = prjDescription.getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                String[] ids;
                ICConfigurationDescription cfgDescription = iCConfigurationDescriptionArray[n2];
                if (cfgDescription instanceof ILanguageSettingsProvidersKeeper && (ids = ((ILanguageSettingsProvidersKeeper)((Object)cfgDescription)).getDefaultLanguageSettingsProvidersIds()) != null) {
                    ArrayList<ILanguageSettingsProvider> providers = new ArrayList<ILanguageSettingsProvider>(ids.length);
                    String[] stringArray = ids;
                    int n3 = ids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String id = stringArray[n4];
                        if (LanguageSettingsExtensionManager.isPreferShared(id)) {
                            providers.add(LanguageSettingsManager.getWorkspaceProvider(id));
                        } else {
                            providers.add(LanguageSettingsManager.getExtensionProviderCopy(id, true));
                        }
                        ++n4;
                    }
                    ((ILanguageSettingsProvidersKeeper)((Object)cfgDescription)).setLanguageSettingProviders(providers);
                }
                ++n2;
            }
        }
        ScannerDiscoveryLegacySupport.defineLanguageSettingsEnablement(project);
    }

    public static ILanguageSettingsProvider getWorkspaceProvider(String id) {
        ILanguageSettingsProvider provider = globalWorkspaceProviders.get(id);
        if (provider == null) {
            provider = new LanguageSettingsWorkspaceProvider(id);
            globalWorkspaceProviders.put(id, provider);
        }
        return provider;
    }

    public static ILanguageSettingsProvider getRawWorkspaceProvider(String id) {
        return rawGlobalWorkspaceProviders.get(id);
    }

    public static List<ILanguageSettingsProvider> getWorkspaceProviders() {
        ArrayList<ILanguageSettingsProvider> workspaceProviders = new ArrayList<ILanguageSettingsProvider>();
        for (ILanguageSettingsProvider rawProvider : rawGlobalWorkspaceProviders.values()) {
            workspaceProviders.add(LanguageSettingsProvidersSerializer.getWorkspaceProvider(rawProvider.getId()));
        }
        return workspaceProviders;
    }

    public static boolean isWorkspaceProvider(ILanguageSettingsProvider provider) {
        return provider instanceof LanguageSettingsWorkspaceProvider;
    }

    private static <T> boolean isInList(Collection<T> list, T element) {
        for (T elem : list) {
            if (elem != element) continue;
            return true;
        }
        return false;
    }

    private static boolean isListenerInTheListOfAssociations(Collection<ListenerAssociation> list, ICListenerAgent element) {
        for (ListenerAssociation la : list) {
            if (la.listener != element) continue;
            return true;
        }
        return false;
    }

    private static List<ICListenerAgent> getListeners(ICProjectDescription prjDescription) {
        ArrayList<ICListenerAgent> listeners = new ArrayList<ICListenerAgent>();
        if (prjDescription != null) {
            ICConfigurationDescription[] iCConfigurationDescriptionArray = prjDescription.getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cfgDescription = iCConfigurationDescriptionArray[n2];
                if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
                    List<ILanguageSettingsProvider> providers = ((ILanguageSettingsProvidersKeeper)((Object)cfgDescription)).getLanguageSettingProviders();
                    for (ILanguageSettingsProvider provider : providers) {
                        ICListenerAgent listener;
                        if (!(provider instanceof ICListenerAgent) || LanguageSettingsProvidersSerializer.isInList(listeners, listener = (ICListenerAgent)((Object)provider))) continue;
                        listeners.add(listener);
                    }
                }
                ++n2;
            }
        }
        return listeners;
    }

    private static List<ICListenerAgent> selectListeners(Collection<ILanguageSettingsProvider> values) {
        ArrayList<ICListenerAgent> listeners = new ArrayList<ICListenerAgent>();
        for (ILanguageSettingsProvider provider : values) {
            if (!(provider instanceof ICListenerAgent)) continue;
            listeners.add((ICListenerAgent)((Object)provider));
        }
        return listeners;
    }

    private static List<ListenerAssociation> getListenersAssociations(ICProjectDescription prjDescription) {
        ArrayList<ListenerAssociation> associations = new ArrayList<ListenerAssociation>();
        if (prjDescription != null) {
            ICConfigurationDescription[] iCConfigurationDescriptionArray = prjDescription.getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cfgDescription = iCConfigurationDescriptionArray[n2];
                if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
                    List<ILanguageSettingsProvider> providers = ((ILanguageSettingsProvidersKeeper)((Object)cfgDescription)).getLanguageSettingProviders();
                    List<ICListenerAgent> listeners = LanguageSettingsProvidersSerializer.selectListeners(providers);
                    for (ICListenerAgent listener : listeners) {
                        if (LanguageSettingsProvidersSerializer.isListenerInTheListOfAssociations(associations, listener)) continue;
                        associations.add(new ListenerAssociation(listener, cfgDescription));
                    }
                }
                ++n2;
            }
        }
        return associations;
    }

    public static void reRegisterListeners(ICProjectDescription oldPrjDescription, ICProjectDescription newPrjDescription) {
        if (oldPrjDescription == newPrjDescription) {
            return;
        }
        List<ICListenerAgent> oldListeners = LanguageSettingsProvidersSerializer.getListeners(oldPrjDescription);
        List<ListenerAssociation> newAssociations = LanguageSettingsProvidersSerializer.getListenersAssociations(newPrjDescription);
        for (ICListenerAgent oldListener : oldListeners) {
            if (LanguageSettingsProvidersSerializer.isListenerInTheListOfAssociations(newAssociations, oldListener)) continue;
            int count = 0;
            if (oldListener instanceof LanguageSettingsWorkspaceProvider) {
                count = ((LanguageSettingsWorkspaceProvider)oldListener).decrementProjectCount();
            }
            if (count > 0) continue;
            try {
                oldListener.unregisterListener();
            }
            catch (Throwable e) {
                CCorePlugin.log("Exception trying unregister listener " + ((ILanguageSettingsProvider)((Object)oldListener)).getId(), e);
            }
        }
        for (ListenerAssociation newListenerAssociation : newAssociations) {
            ICListenerAgent newListener = newListenerAssociation.listener;
            if (LanguageSettingsProvidersSerializer.isInList(oldListeners, newListener)) continue;
            int count = 1;
            if (newListener instanceof LanguageSettingsWorkspaceProvider) {
                count = ((LanguageSettingsWorkspaceProvider)newListener).incrementProjectCount();
            }
            if (count != true) continue;
            try {
                newListener.registerListener(newListenerAssociation.cfgDescription);
            }
            catch (Throwable e) {
                CCorePlugin.log("Exception trying register listener " + ((ILanguageSettingsProvider)((Object)newListener)).getId(), e);
            }
        }
    }

    public static void registerLanguageSettingsChangeListener(ILanguageSettingsChangeListener listener) {
        fLanguageSettingsChangeListeners.add((Object)listener);
    }

    public static void unregisterLanguageSettingsChangeListener(ILanguageSettingsChangeListener listener) {
        fLanguageSettingsChangeListeners.remove((Object)listener);
    }

    private static void notifyLanguageSettingsChangeListeners(ILanguageSettingsChangeEvent event) {
        for (ILanguageSettingsChangeListener listener : fLanguageSettingsChangeListeners) {
            listener.handleEvent(event);
        }
    }

    private static List<ICLanguageSettingEntry> getSettingEntriesPooled(ILanguageSettingsProvider provider, ICConfigurationDescription cfgDescription, IResource rc, String languageId) {
        try {
            return LanguageSettingsStorage.getPooledList(provider.getSettingEntries(cfgDescription, rc, languageId));
        }
        catch (Throwable e) {
            String cfgId = cfgDescription != null ? cfgDescription.getId() : null;
            String msg = "Exception in provider " + provider.getId() + ": getSettingEntries(" + cfgId + ", " + rc + ", " + languageId + ")";
            CCorePlugin.log(msg, e);
            return LanguageSettingsStorage.getPooledEmptyList();
        }
    }

    public static List<ICLanguageSettingEntry> getSettingEntriesUpResourceTree(ILanguageSettingsProvider provider, ICConfigurationDescription cfgDescription, IResource rc, String languageId) {
        Assert.isTrue((!(rc instanceof IWorkspaceRoot) ? 1 : 0) != 0);
        if (provider != null) {
            List<ICLanguageSettingEntry> entries = LanguageSettingsProvidersSerializer.getSettingEntriesPooled(provider, cfgDescription, rc, languageId);
            if (entries != null) {
                return entries;
            }
            if (rc != null) {
                IContainer parentFolder;
                IContainer iContainer = parentFolder = rc instanceof IProject ? null : rc.getParent();
                if (parentFolder != null) {
                    return LanguageSettingsProvidersSerializer.getSettingEntriesUpResourceTree(provider, cfgDescription, (IResource)parentFolder, languageId);
                }
                entries = LanguageSettingsProvidersSerializer.getSettingEntriesPooled(provider, cfgDescription, null, languageId);
                if (entries != null) {
                    return entries;
                }
                entries = LanguageSettingsProvidersSerializer.getSettingEntriesPooled(provider, null, null, languageId);
                if (entries != null) {
                    return entries;
                }
            }
        }
        return LanguageSettingsStorage.getPooledEmptyList();
    }

    private static boolean checkBit(int flags, int bit) {
        return (flags & bit) == bit;
    }

    private static List<ICLanguageSettingEntry> getSettingEntriesByKind(ICConfigurationDescription cfgDescription, IResource rc, String languageId, int kind, boolean checkLocality, boolean isLocal) {
        if (!(cfgDescription instanceof ILanguageSettingsProvidersKeeper)) {
            return null;
        }
        ArrayList<ICLanguageSettingEntry> entries = new ArrayList<ICLanguageSettingEntry>();
        ArrayList<String> alreadyAdded = new ArrayList<String>();
        List<ILanguageSettingsProvider> providers = ((ILanguageSettingsProvidersKeeper)((Object)cfgDescription)).getLanguageSettingProviders();
        for (ILanguageSettingsProvider provider : providers) {
            List<ICLanguageSettingEntry> providerEntries = LanguageSettingsProvidersSerializer.getSettingEntriesUpResourceTree(provider, cfgDescription, rc, languageId);
            for (ICLanguageSettingEntry entry : providerEntries) {
                boolean isRightLocal;
                if (entry == null) continue;
                String entryName = entry.getName();
                boolean isRightKind = LanguageSettingsProvidersSerializer.checkBit(kind, entry.getKind());
                if (!isRightKind || alreadyAdded.contains(entryName)) continue;
                int flags = entry.getFlags();
                boolean bl = isRightLocal = !checkLocality || LanguageSettingsProvidersSerializer.checkBit(flags, 4) == isLocal;
                if (!isRightLocal) continue;
                if (!LanguageSettingsProvidersSerializer.checkBit(flags, 32)) {
                    entries.add(entry);
                }
                alreadyAdded.add(entryName);
            }
        }
        return entries;
    }

    public static List<ICLanguageSettingEntry> getSettingEntriesByKind(ICConfigurationDescription cfgDescription, IResource rc, String languageId, int kind) {
        return LanguageSettingsProvidersSerializer.getSettingEntriesByKind(cfgDescription, rc, languageId, kind, false, false);
    }

    public static List<ICLanguageSettingEntry> getSystemSettingEntriesByKind(ICConfigurationDescription cfgDescription, IResource rc, String languageId, int kind) {
        return LanguageSettingsProvidersSerializer.getSettingEntriesByKind(cfgDescription, rc, languageId, kind, true, false);
    }

    public static List<ICLanguageSettingEntry> getLocalSettingEntriesByKind(ICConfigurationDescription cfgDescription, IResource rc, String languageId, int kind) {
        return LanguageSettingsProvidersSerializer.getSettingEntriesByKind(cfgDescription, rc, languageId, kind, true, true);
    }

    public static List<ILanguageSettingsProvider> cloneProviders(List<ILanguageSettingsProvider> baseProviders) {
        ArrayList<ILanguageSettingsProvider> newProviders = new ArrayList<ILanguageSettingsProvider>();
        for (ILanguageSettingsProvider provider : baseProviders) {
            ILanguageSettingsEditableProvider newProvider;
            if (provider instanceof ILanguageSettingsEditableProvider && (newProvider = LanguageSettingsManager.getProviderCopy((ILanguageSettingsEditableProvider)provider, true)) != null) {
                provider = newProvider;
            }
            newProviders.add(provider);
        }
        return new ArrayList<ILanguageSettingsProvider>(newProviders);
    }

    private static class LanguageSettingsChangeEvent
    implements ILanguageSettingsChangeEvent {
        private String projectName = null;
        private Map<String, LanguageSettingsDelta> deltaMap = new HashMap<String, LanguageSettingsDelta>();

        public LanguageSettingsChangeEvent(ICProjectDescription prjDescription) {
            ICConfigurationDescription[] cfgDescriptions;
            if (!prjDescription.isReadOnly()) {
                String msg = "Project description " + prjDescription.getName() + " is expected to be read-only";
                CCorePlugin.log((IStatus)new Status(2, "org.eclipse.cdt.core", msg, (Throwable)new Exception(msg)));
            }
            this.projectName = prjDescription.getName();
            ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgDescriptions = prjDescription.getConfigurations();
            int n = cfgDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cfgDescription = iCConfigurationDescriptionArray[n2];
                if (cfgDescription instanceof IInternalCCfgInfo) {
                    CConfigurationSpecSettings specSettings = null;
                    try {
                        specSettings = ((IInternalCCfgInfo)((Object)cfgDescription)).getSpecSettings();
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                    if (specSettings != null) {
                        String cfgId = cfgDescription.getId();
                        if (ScannerDiscoveryLegacySupport.isLanguageSettingsProvidersFunctionalityEnabled(prjDescription.getProject())) {
                            LanguageSettingsDelta delta = specSettings.dropDelta();
                            if (delta != null) {
                                this.deltaMap.put(cfgId, delta);
                            }
                        } else {
                            this.deltaMap.remove(cfgId);
                        }
                    } else {
                        Status ss = new Status(4, "org.eclipse.cdt.core", "Internal error: Missing specSettings for " + cfgDescription.getClass().getSimpleName());
                        CCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.core", ss.getMessage(), (Throwable)new CoreException((IStatus)ss)));
                    }
                }
                ++n2;
            }
        }

        @Override
        public String getProjectName() {
            return this.projectName;
        }

        @Override
        public String[] getConfigurationDescriptionIds() {
            return this.deltaMap.keySet().toArray(new String[this.deltaMap.size()]);
        }

        public String toString() {
            return "LanguageSettingsChangeEvent for project=[" + this.getProjectName() + "]" + ", configurations=" + this.deltaMap.keySet();
        }

        @Override
        public Set<IResource> getAffectedResources(String cfgId) {
            Set<String> paths;
            LanguageSettingsDelta delta = this.deltaMap.get(cfgId);
            if (delta != null && !(paths = delta.getAffectedResourcePaths()).isEmpty()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
                HashSet<IResource> resources = new HashSet<IResource>();
                for (String path : paths) {
                    IResource rc = project.findMember(path);
                    if (rc == null) continue;
                    resources.add(rc);
                }
                return resources;
            }
            return null;
        }
    }

    private static class LanguageSettingsWorkspaceProvider
    implements ILanguageSettingsProvider,
    ICListenerAgent {
        private String providerId;
        private int projectCount = 0;

        private LanguageSettingsWorkspaceProvider(String id) {
            Assert.isNotNull((Object)id);
            this.providerId = id;
        }

        @Override
        public String getId() {
            return this.providerId;
        }

        @Override
        public String getName() {
            ILanguageSettingsProvider rawProvider = this.getRawProvider();
            String name = rawProvider != null ? rawProvider.getName() : null;
            return name;
        }

        @Override
        public List<ICLanguageSettingEntry> getSettingEntries(ICConfigurationDescription cfgDescription, IResource rc, String languageId) {
            List<ICLanguageSettingEntry> entries;
            ILanguageSettingsProvider rawProvider = this.getRawProvider();
            List<ICLanguageSettingEntry> list = entries = rawProvider != null ? rawProvider.getSettingEntries(cfgDescription, rc, languageId) : null;
            if (cfgDescription != null) {
                IProject project = cfgDescription.getProjectDescription().getProject();
                entries = CommandLauncherManager.getInstance().getLanguageSettingEntries(project, entries);
            }
            return entries;
        }

        private ILanguageSettingsProvider getRawProvider() {
            return LanguageSettingsProvidersSerializer.getRawWorkspaceProvider(this.providerId);
        }

        public boolean equals(Object obj) {
            if (obj instanceof LanguageSettingsWorkspaceProvider) {
                LanguageSettingsWorkspaceProvider that = (LanguageSettingsWorkspaceProvider)obj;
                return this.providerId.equals(that.providerId);
            }
            return false;
        }

        public String toString() {
            return "id=" + this.getId() + ", name=" + this.getName();
        }

        private int getProjectCount() {
            return this.projectCount;
        }

        private synchronized int incrementProjectCount() {
            ++this.projectCount;
            return this.projectCount;
        }

        private synchronized int decrementProjectCount() {
            --this.projectCount;
            return this.projectCount;
        }

        @Override
        public void registerListener(ICConfigurationDescription cfgDescription) {
            ILanguageSettingsProvider rawProvider = this.getRawProvider();
            if (rawProvider instanceof ICListenerAgent) {
                ((ICListenerAgent)((Object)rawProvider)).registerListener(null);
            }
        }

        @Override
        public void unregisterListener() {
            ILanguageSettingsProvider rawProvider = this.getRawProvider();
            if (rawProvider instanceof ICListenerAgent) {
                ((ICListenerAgent)((Object)rawProvider)).unregisterListener();
            }
        }
    }

    private static class ListenerAssociation {
        private ICListenerAgent listener;
        private ICConfigurationDescription cfgDescription;

        public ListenerAssociation(ICListenerAgent la, ICConfigurationDescription cfgd) {
            this.listener = la;
            this.cfgDescription = cfgd;
        }
    }

    private static class NotAccessibleProvider
    implements ILanguageSettingsProvider {
        private final String id;

        private NotAccessibleProvider(String providerId) {
            this.id = providerId;
        }

        @Override
        public List<ICLanguageSettingEntry> getSettingEntries(ICConfigurationDescription cfgDescription, IResource rc, String languageId) {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String getId() {
            return this.id;
        }
    }
}

