/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.internal.core.util;

import java.io.StringWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.util.SaveDDLUtility;

public class RTEHelper {
    private static String LINE_RETURN = System.getProperty("line.separator");

    public static IFile saveDDL(String[] ddlStatements, DatabaseDefinition databaseDefinition, IPath path, String statementTerminator) {
        IFile ddlFile = null;
        StringWriter writer = new StringWriter();
        String terminator = RTEHelper.getDefaultStatementTerminator(databaseDefinition);
        if (statementTerminator != null) {
            terminator = statementTerminator;
        }
        int i = 0;
        while (i < ddlStatements.length) {
            writer.write(String.valueOf(ddlStatements[i]) + terminator);
            ++i;
        }
        ddlFile = SaveDDLUtility.getInstance().saveDDLFileAsResource(writer, path.toString());
        return ddlFile;
    }

    private static String getDefaultStatementTerminator(DatabaseDefinition dbDef) {
        String statementTerminator = dbDef.getSQLTerminationCharacter();
        String fullStatementTermination = "";
        fullStatementTermination = statementTerminator.length() < 2 ? String.valueOf(fullStatementTermination) + statementTerminator + LINE_RETURN + LINE_RETURN : String.valueOf(fullStatementTermination) + LINE_RETURN + statementTerminator + LINE_RETURN + LINE_RETURN;
        return fullStatementTermination;
    }
}

