/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.validators;

import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildContextExtension;
import org.eclipse.dltk.core.caching.IContentCache;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.ast.TclModuleDeclaration;
import org.eclipse.dltk.tcl.internal.core.TclASTCache;
import org.eclipse.dltk.tcl.internal.parser.NewTclSourceParser;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;
import org.eclipse.dltk.tcl.parser.TclErrorCollector;
import org.eclipse.dltk.tcl.parser.TclParser;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionManager;
import org.eclipse.dltk.tcl.parser.definitions.IScopeProcessor;

public class TclBuildContext {
    private static final String NEW_AST = "new_ast";
    private static final String NEW_PROBLEMS = "new_ast_problems";
    private static final String PROBLEMS_REPORTED = "problemsReported";

    private static boolean isReported(IBuildContext context) {
        return context.get(PROBLEMS_REPORTED) != null;
    }

    private static void setReported(IBuildContext context) {
        context.set(PROBLEMS_REPORTED, (Object)Boolean.TRUE);
    }

    public static TclModule getStatements(IBuildContext context) {
        TclModuleDeclaration decl;
        TclModule tclModule;
        ProblemCollector collector;
        Object object = context.get(NEW_AST);
        if (object != null && object instanceof TclModule) {
            if (!TclBuildContext.isReported(context)) {
                Object object2 = context.get(NEW_PROBLEMS);
                if (object2 instanceof ProblemCollector) {
                    ProblemCollector collector2 = (ProblemCollector)object2;
                    collector2.copyTo(context.getProblemReporter());
                }
                TclBuildContext.setReported(context);
            }
            TclModule module = (TclModule)object;
            TclBuildContext.restoreLineTracker(context, module);
            return module;
        }
        ISourceModuleInfoCache infoCache = SourceParserUtil.getCache();
        ISourceModuleInfoCache.ISourceModuleInfo info = infoCache.get(context.getSourceModule());
        IModuleDeclaration cache = SourceParserUtil.getModuleFromCache((ISourceModuleInfoCache.ISourceModuleInfo)info, (IProblemReporter)(collector = new ProblemCollector()));
        if (cache instanceof TclModuleDeclaration && (tclModule = (decl = (TclModuleDeclaration)cache).getTclModule()) != null) {
            if (!TclBuildContext.isReported(context)) {
                collector.copyTo(context.getProblemReporter());
                TclBuildContext.setReported(context);
            }
            TclBuildContext.restoreLineTracker(context, tclModule);
            return tclModule;
        }
        IFileHandle handle = EnvironmentPathUtils.getFile((IModelElement)context.getSourceModule());
        if (handle != null) {
            IContentCache coreCache = ModelManager.getModelManager().getCoreCache();
            TclModule module = TclASTCache.restoreTclModuleFromCache((IFileHandle)handle, (IContentCache)coreCache, (IProblemReporter)collector);
            if (!TclBuildContext.isReported(context)) {
                collector.copyTo(context.getProblemReporter());
                TclBuildContext.setReported(context);
            }
            if (module != null) {
                context.set(NEW_AST, (Object)module);
                context.set(NEW_PROBLEMS, (Object)collector);
                TclBuildContext.restoreLineTracker(context, module);
                return module;
            }
        }
        TclParser parser = new TclParser();
        TclErrorCollector tclCollector = new TclErrorCollector();
        TclModule module = parser.parseModule(new String(context.getContents()), (ITclErrorReporter)tclCollector, (IScopeProcessor)DefinitionManager.getInstance().createProcessor());
        if (!TclBuildContext.isReported(context)) {
            tclCollector.reportAll(context.getProblemReporter(), context.getLineTracker());
            TclBuildContext.setReported(context);
        }
        context.set(NEW_AST, (Object)module);
        context.set(NEW_PROBLEMS, (Object)collector);
        TclBuildContext.restoreLineTracker(context, module);
        return module;
    }

    private static void restoreLineTracker(IBuildContext context, TclModule module) {
        IBuildContextExtension eContext = (IBuildContextExtension)context;
        if (!eContext.isLineTrackerCreated()) {
            eContext.setLineTracker(NewTclSourceParser.createLineTracker((TclModule)module));
        }
    }
}

