/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ProjectFolderPickerDialog
extends TitleAreaDialog {
    private TreeViewer viewer;
    private IProject project;
    private String srcPath;
    private String value;

    protected ProjectFolderPickerDialog(Shell parentShell, IProject project, String srcPath) {
        super(parentShell);
        this.project = project;
        this.srcPath = srcPath;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.setText(Messages.ProjectFolderPickerDialog_useSourceDirectory);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectFolderPickerDialog.this.value = Path.fromOSString((String)ProjectFolderPickerDialog.this.srcPath).removeLastSegments(1).toOSString();
                ProjectFolderPickerDialog.super.okPressed();
            }
        });
        button.moveAbove((Control)this.getButton(1));
        ((GridLayout)parent.getLayout()).numColumns = 3;
    }

    protected void okPressed() {
        Object selected = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (selected == null || selected instanceof String) {
            this.value = "";
        } else {
            IResource resource = (IResource)selected;
            this.value = resource.getFullPath().removeFirstSegments(1).toOSString();
        }
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = (Composite)super.createDialogArea(parent);
        this.viewer = new TreeViewer(ret);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.viewer.setInput((Object)this.project);
        this.viewer.expandToLevel(2);
        this.viewer.addDoubleClickListener(event -> this.okPressed());
        if (this.srcPath != null) {
            IPath path = Path.fromOSString((String)this.srcPath);
            Composite compPath = new Composite(ret, 0);
            compPath.setLayoutData((Object)new GridData(4, 4, true, true));
            compPath.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(compPath, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setText(Messages.ProjectFolderPickerDialog_sourceResourceName);
            Label label2 = new Label(compPath, 0);
            label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label2.setText(path.lastSegment());
            Label label3 = new Label(compPath, 0);
            label3.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label3.setText(Messages.ProjectFolderPickerDialog_sourceResourceDirectory);
            Label lblResourcePath = new Label(compPath, 0);
            lblResourcePath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            lblResourcePath.setText(path.removeLastSegments(1).toOSString());
        }
        String message = Messages.ProjectFolderPickerDialog_6;
        this.getShell().setText(message);
        this.setTitle(message);
        this.setMessage(message);
        return ret;
    }

    public String getValue() {
        return this.value;
    }

    static class ProjectContentProvider
    implements ITreeContentProvider {
        private IProject project;
        Boolean found = false;

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.project = (IProject)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{this.project.getName()};
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                return this.getChildren(this.project);
            }
            IResource resource = (IResource)parentElement;
            ArrayList list = new ArrayList();
            IResourceProxyVisitor visitor = proxy -> {
                if (proxy.getType() == 2 && proxy.requestResource().getParent() == resource && !proxy.requestResource().equals((Object)resource)) {
                    list.add(proxy.requestResource());
                }
                return true;
            };
            try {
                resource.accept(visitor, 1);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return list.toArray(new Object[0]);
        }

        public Object getParent(Object element) {
            IResource resource = (IResource)element;
            return resource.getParent();
        }

        public boolean hasChildren(Object element) {
            if (element instanceof String) {
                return true;
            }
            IResource resource = (IResource)element;
            try {
                this.found = false;
                resource.accept(proxy -> {
                    if (proxy.getType() == 2 && !proxy.requestResource().equals((Object)resource)) {
                        this.found = true;
                        return false;
                    }
                    return true;
                }, 1);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return this.found;
        }
    }

    static class ProjectLabelProvider
    extends ColumnLabelProvider {
        ProjectLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return element.toString();
            }
            IResource resource = (IResource)element;
            return resource.getName();
        }

        public Image getImage(Object element) {
            try {
                if (element instanceof String) {
                    return new Image((Device)Display.getDefault(), new URL(Messages.ProjectFolderPickerDialog_0).openStream());
                }
                Throwable throwable = null;
                Object var3_4 = null;
                try (InputStream is = new URL("platform:/plugin/org.eclipse.ui.ide/icons/full/obj16/folder.png").openStream();){
                    return new Image((Device)Display.getDefault(), is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                return super.getImage(element);
            }
        }
    }
}

