/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.jsf.core.internal.IJSFPreferenceModel;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.jst.jsf.ui.internal.validation.PreferencesMessages;
import org.eclipse.jst.jsf.ui.internal.validation.ScrolledPageContent;
import org.eclipse.jst.jsf.validation.internal.Severity;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

abstract class OptionsConfigurationBlock {
    protected final IJSFPreferenceModel _prefs;
    private static final String REBUILD_COUNT_KEY = "preferences_build_requested";
    private static final String SETTINGS_EXPANDED = "expanded";
    private final ArrayList fCheckBoxes;
    private final ArrayList fComboBoxes;
    private final ArrayList fTextBoxes;
    private final HashMap fLabels;
    private final ArrayList fExpandedComposites;
    private SelectionListener fSelectionListener;
    private ModifyListener fTextModifyListener;
    private final IProject fProject;
    private final Key[] fAllKeys;
    private IScopeContext[] fLookupOrder;
    private Shell fShell;
    private final IWorkingCopyManager fManager;
    private IWorkbenchPreferenceContainer fContainer;
    private Map fDisabledProjectSettings;
    private int fRebuildCount;

    OptionsConfigurationBlock(IJSFPreferenceModel prefs, IProject project, Key[] allKeys, IWorkbenchPreferenceContainer container) {
        this.fProject = project;
        this.fAllKeys = allKeys;
        this.fContainer = container;
        this._prefs = prefs;
        this.fManager = container == null ? new WorkingCopyManager() : container.getWorkingCopyManager();
        this.fLookupOrder = this.fProject != null ? new IScopeContext[]{new ProjectScope(this.fProject), new InstanceScope(), new DefaultScope()} : new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        this.testIfOptionsComplete(allKeys);
        if (this.fProject == null || this.hasProjectSpecificOptions(this.fProject)) {
            this.fDisabledProjectSettings = null;
        } else {
            this.fDisabledProjectSettings = new IdentityHashMap();
            int i = 0;
            while (i < allKeys.length) {
                Key curr = allKeys[i];
                this.fDisabledProjectSettings.put(curr, curr.getCurValue(this._prefs, this.fLookupOrder, false, this.fManager));
                ++i;
            }
        }
        this.fCheckBoxes = new ArrayList();
        this.fComboBoxes = new ArrayList();
        this.fTextBoxes = new ArrayList(2);
        this.fLabels = new HashMap();
        this.fExpandedComposites = new ArrayList();
        this.fRebuildCount = this.getRebuildCount();
    }

    protected final IWorkbenchPreferenceContainer getPreferenceContainer() {
        return this.fContainer;
    }

    protected static Key getKey(String plugin, String key) {
        return new Key(plugin, key);
    }

    protected static final Key getJSFCoreKey(String key) {
        return OptionsConfigurationBlock.getKey("org.eclipse.jst.jsf.core", key);
    }

    private void testIfOptionsComplete(Key[] allKeys) {
        int i = 0;
        while (i < allKeys.length) {
            if (allKeys[i].getCurValue(this._prefs, this.fLookupOrder, false, this.fManager) == null) {
                JSFUiPlugin.log(4, "preference option missing: " + allKeys[i] + " (" + this.getClass().getName() + ')');
            }
            ++i;
        }
    }

    private int getRebuildCount() {
        return this.fManager.getWorkingCopy(new DefaultScope().getNode("org.eclipse.jdt.ui")).getInt(REBUILD_COUNT_KEY, 0);
    }

    private void incrementRebuildCount() {
        ++this.fRebuildCount;
        this.fManager.getWorkingCopy(new DefaultScope().getNode("org.eclipse.jdt.ui")).putInt(REBUILD_COUNT_KEY, this.fRebuildCount);
    }

    public final boolean hasProjectSpecificOptions(IProject project) {
        if (project != null) {
            ProjectScope projectContext = new ProjectScope(project);
            Key[] allKeys = this.fAllKeys;
            int i = 0;
            while (i < allKeys.length) {
                if (allKeys[i].getCurValue(this._prefs, (IScopeContext)projectContext, this.fManager) != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected Shell getShell() {
        return this.fShell;
    }

    protected void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected abstract Control createContents(Composite var1);

    protected Button addCheckBoxWithLink(Composite parent, String label, Key key, String[] values, int indent, int widthHint, SelectionListener listener) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gd);
        Button checkBox = new Button(composite, 32);
        checkBox.setFont(JFaceResources.getDialogFont());
        checkBox.setData((Object)data);
        checkBox.setLayoutData((Object)new GridData(4, 1, false, false));
        checkBox.addSelectionListener(this.getSelectionListener());
        gd = new GridData(4, 2, true, false);
        gd.widthHint = widthHint;
        Link link = new Link(composite, 0);
        link.setText(label);
        link.setLayoutData((Object)gd);
        if (listener != null) {
            link.addSelectionListener(listener);
        }
        this.makeScrollableCompositeAware((Control)link);
        this.makeScrollableCompositeAware((Control)checkBox);
        String currValue = this.getValue(key);
        checkBox.setSelection(data.getSelection(currValue) == 0);
        this.fCheckBoxes.add(checkBox);
        return checkBox;
    }

    protected Combo addComboBox(Composite parent, String label, Key key, String[] values, String[] valueLabels, int indent) {
        GridData gd = new GridData(4, 2, true, false, 2, 1);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16384);
        labelControl.setFont(JFaceResources.getDialogFont());
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = this.newComboControl(parent, key, values, valueLabels);
        comboBox.setLayoutData((Object)new GridData(256));
        this.fLabels.put(comboBox, labelControl);
        return comboBox;
    }

    Combo addInversedComboBox(Composite parent, String label, Key key, String[] values, String[] valueLabels, int indent) {
        GridData gd = new GridData(32);
        gd.horizontalIndent = indent;
        gd.horizontalSpan = 3;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gd);
        Combo comboBox = this.newComboControl(composite, key, values, valueLabels);
        comboBox.setFont(JFaceResources.getDialogFont());
        comboBox.setLayoutData((Object)new GridData(256));
        Label labelControl = new Label(composite, 16448);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)new GridData());
        this.fLabels.put(comboBox, labelControl);
        return comboBox;
    }

    Combo newComboControl(Composite composite, Key key, String[] values, String[] valueLabels) {
        ControlData data = new ControlData(key, values);
        Combo comboBox = new Combo(composite, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        comboBox.addSelectionListener(this.getSelectionListener());
        comboBox.setFont(JFaceResources.getDialogFont());
        this.makeScrollableCompositeAware((Control)comboBox);
        String currValue = this.getValue(key);
        comboBox.select(data.getSelection(currValue));
        this.fComboBoxes.add(comboBox);
        return comboBox;
    }

    Text addTextField(Composite parent, String label, Key key, int indent, int widthHint) {
        Label labelControl = new Label(parent, 64);
        labelControl.setText(label);
        labelControl.setFont(JFaceResources.getDialogFont());
        labelControl.setLayoutData((Object)new GridData());
        Text textBox = new Text(parent, 2052);
        textBox.setData((Object)key);
        textBox.setLayoutData((Object)new GridData());
        this.makeScrollableCompositeAware((Control)textBox);
        this.fLabels.put(textBox, labelControl);
        String currValue = this.getValue(key);
        if (currValue != null) {
            textBox.setText(currValue);
        }
        textBox.addModifyListener(this.getTextModifyListener());
        GridData data = new GridData(256);
        if (widthHint != 0) {
            data.widthHint = widthHint;
        }
        data.horizontalIndent = indent;
        data.horizontalSpan = 2;
        textBox.setLayoutData((Object)data);
        this.fTextBoxes.add(textBox);
        return textBox;
    }

    ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    ExpandableComposite getParentExpandableComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ExpandableComposite) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ExpandableComposite) {
            return (ExpandableComposite)parent;
        }
        return null;
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    ExpandableComposite createStyleSection(Composite parent, String label, int nColumns) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(label);
        excomposite.setExpanded(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, nColumns, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                OptionsConfigurationBlock.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.fExpandedComposites.add(excomposite);
        this.makeScrollableCompositeAware((Control)excomposite);
        return excomposite;
    }

    final void expandedStateChanged(ExpandableComposite expandable) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }

    void restoreSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.fExpandedComposites.size()) {
            ExpandableComposite excomposite = (ExpandableComposite)this.fExpandedComposites.get(i);
            if (settings == null) {
                excomposite.setExpanded(i == 0);
            } else {
                excomposite.setExpanded(settings.getBoolean(SETTINGS_EXPANDED + String.valueOf(i)));
            }
            ++i;
        }
    }

    void storeSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.fExpandedComposites.size()) {
            ExpandableComposite curr = (ExpandableComposite)this.fExpandedComposites.get(i);
            settings.put(SETTINGS_EXPANDED + String.valueOf(i), curr.isExpanded());
            ++i;
        }
    }

    SelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    OptionsConfigurationBlock.this.controlChanged(e.widget);
                }
            };
        }
        return this.fSelectionListener;
    }

    ModifyListener getTextModifyListener() {
        if (this.fTextModifyListener == null) {
            this.fTextModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OptionsConfigurationBlock.this.textChanged((Text)e.widget);
                }
            };
        }
        return this.fTextModifyListener;
    }

    void controlChanged(Widget widget) {
        ControlData data = (ControlData)widget.getData();
        String newValue = null;
        if (widget instanceof Button) {
            newValue = data.getValue(((Button)widget).getSelection());
        } else if (widget instanceof Combo) {
            newValue = data.getValue(((Combo)widget).getSelectionIndex());
        } else {
            return;
        }
        String oldValue = this.setValue(data.getKey(), newValue);
        this.validateSettings(data.getKey(), oldValue, newValue);
    }

    void textChanged(Text textControl) {
        Key key = (Key)textControl.getData();
        String number = textControl.getText();
        String oldValue = this.setValue(key, number);
        this.validateSettings(key, oldValue, number);
    }

    boolean checkValue(Key key, String value) {
        return value.equals(this.getValue(key));
    }

    String getValue(Key key) {
        if (this.fDisabledProjectSettings != null) {
            return (String)this.fDisabledProjectSettings.get(key);
        }
        return key.getCurValue(this._prefs, this.fLookupOrder, false, this.fManager).toString();
    }

    boolean getBooleanValue(Key key) {
        return Boolean.valueOf(this.getValue(key));
    }

    String setValue(Key key, String value) {
        if (this.fDisabledProjectSettings != null) {
            return this.fDisabledProjectSettings.put(key, value);
        }
        Object newValue = key.setCurValue(this._prefs, this.fLookupOrder[0], Severity.valueOfString((String)value), this.fManager);
        return newValue != null ? newValue.toString() : "";
    }

    String setValue(Key key, boolean value) {
        return this.setValue(key, String.valueOf(value));
    }

    Object getStoredValue(Key key) {
        return key.getCurValue(this._prefs, this.fLookupOrder, false, this.fManager);
    }

    protected abstract void validateSettings(Key var1, String var2, String var3);

    String[] getTokens(String text, String separator) {
        StringTokenizer tok = new StringTokenizer(text, separator);
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < res.length) {
            res[i] = tok.nextToken().trim();
            ++i;
        }
        return res;
    }

    private boolean getChanges(IScopeContext currContext, List changedSettings) {
        boolean needsBuild = false;
        int i = 0;
        while (i < this.fAllKeys.length) {
            Key key = this.fAllKeys[i];
            Object oldVal = key.getStoredValue(this._prefs, currContext, null);
            Object val = key.getCurValue(this._prefs, currContext, this.fManager);
            if (val == null) {
                if (oldVal != null) {
                    changedSettings.add(key);
                    needsBuild |= !oldVal.equals(key.getCurValue(this._prefs, this.fLookupOrder, true, this.fManager));
                }
            } else if (!val.equals(oldVal)) {
                changedSettings.add(key);
                needsBuild |= oldVal != null || !val.equals(key.getCurValue(this._prefs, this.fLookupOrder, true, this.fManager));
            }
            ++i;
        }
        return needsBuild;
    }

    void useProjectSpecificSettings(boolean enable) {
        boolean hasProjectSpecificOption;
        boolean bl = hasProjectSpecificOption = this.fDisabledProjectSettings == null;
        if (enable != hasProjectSpecificOption && this.fProject != null) {
            if (enable) {
                int i = 0;
                while (i < this.fAllKeys.length) {
                    Key curr = this.fAllKeys[i];
                    String val = (String)this.fDisabledProjectSettings.get(curr);
                    curr.setCurValue(this._prefs, this.fLookupOrder[0], Severity.valueOfString((String)val), this.fManager);
                    ++i;
                }
                this.fDisabledProjectSettings = null;
                this.updateControls();
                this.validateSettings(null, null, null);
            } else {
                this.fDisabledProjectSettings = new IdentityHashMap();
                int i = 0;
                while (i < this.fAllKeys.length) {
                    Key curr = this.fAllKeys[i];
                    Object oldSetting = curr.getCurValue(this._prefs, this.fLookupOrder, false, this.fManager);
                    this.fDisabledProjectSettings.put(curr, oldSetting);
                    curr.setCurValue(this._prefs, this.fLookupOrder[0], null, this.fManager);
                    ++i;
                }
            }
        }
    }

    boolean areSettingsEnabled() {
        return this.fDisabledProjectSettings == null || this.fProject == null;
    }

    boolean performOk() {
        return this.processChanges(this.fContainer);
    }

    boolean processChanges(IWorkbenchPreferenceContainer container) {
        String[] strings;
        boolean showDialog;
        int count;
        IScopeContext currContext = this.fLookupOrder[0];
        ArrayList changedOptions = new ArrayList();
        boolean needsBuild = this.getChanges(currContext, changedOptions);
        if (changedOptions.isEmpty()) {
            return true;
        }
        if (needsBuild && (count = this.getRebuildCount()) > this.fRebuildCount) {
            needsBuild = false;
            this.fRebuildCount = count;
        }
        boolean doBuild = false;
        IPreferenceStore prefStore = JSFCorePlugin.getDefault().getPreferenceStore();
        boolean bl = showDialog = !"always".equals(prefStore.getString("org.eclipse.jst.jsf.core.buildwarning_dont_show_again"));
        if (needsBuild && showDialog && (strings = this.getFullBuildDialogStrings(this.fProject == null)) != null) {
            MessageDialogWithToggle.openInformation((Shell)this.getShell(), (String)strings[0], (String)strings[1], (String)PreferencesMessages.ProblemSeveritiesConfigurationBlock_buildwarning_dont_show_again, (boolean)false, (IPreferenceStore)prefStore, (String)"org.eclipse.jst.jsf.core.buildwarning_dont_show_again");
        }
        if (container != null) {
            if (doBuild) {
                this.incrementRebuildCount();
            }
        } else {
            try {
                this.fManager.applyChanges();
            }
            catch (BackingStoreException e) {
                JSFUiPlugin.log(4, "Error applying changes", e);
                return false;
            }
        }
        return true;
    }

    abstract String[] getFullBuildDialogStrings(boolean var1);

    void performRevert() {
        int i = 0;
        while (i < this.fAllKeys.length) {
            Key curr = this.fAllKeys[i];
            String origValue = curr.getCurValue(this._prefs, this.fLookupOrder, false, null).toString();
            this.setValue(curr, origValue);
            ++i;
        }
        this.updateControls();
        this.validateSettings(null, null, null);
    }

    void dispose() {
    }

    void updateControls() {
        int i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            this.updateCheckBox((Button)this.fCheckBoxes.get(i));
            --i;
        }
        i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            this.updateCombo((Combo)this.fComboBoxes.get(i));
            --i;
        }
        i = this.fTextBoxes.size() - 1;
        while (i >= 0) {
            this.updateText((Text)this.fTextBoxes.get(i));
            --i;
        }
    }

    void updateCombo(Combo curr) {
        ControlData data = (ControlData)curr.getData();
        String currValue = this.getValue(data.getKey());
        curr.select(data.getSelection(currValue));
    }

    void updateCheckBox(Button curr) {
        String currValue;
        ControlData data = (ControlData)curr.getData();
        curr.setSelection(data.getSelection(currValue = this.getValue(data.getKey())) == 0);
    }

    void updateText(Text curr) {
        Key key = (Key)curr.getData();
        String currValue = this.getValue(key);
        if (currValue != null) {
            curr.setText(currValue);
        }
    }

    Button getCheckBox(Key key) {
        int i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            Button curr = (Button)this.fCheckBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    Combo getComboBox(Key key) {
        int i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            Combo curr = (Combo)this.fComboBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    Text getTextControl(Key key) {
        int i = this.fTextBoxes.size() - 1;
        while (i >= 0) {
            Text curr = (Text)this.fTextBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    Control findControl(Key key) {
        Combo comboBox = this.getComboBox(key);
        if (comboBox != null) {
            return comboBox;
        }
        Button checkBox = this.getCheckBox(key);
        if (checkBox != null) {
            return checkBox;
        }
        Text text = this.getTextControl(key);
        if (text != null) {
            return text;
        }
        return null;
    }

    void setComboEnabled(Key key, boolean enabled) {
        Combo combo = this.getComboBox(key);
        Label label = (Label)this.fLabels.get(combo);
        combo.setEnabled(enabled);
        label.setEnabled(enabled);
    }

    static class ControlData {
        private Key fKey;
        private String[] fValues;

        ControlData(Key key, String[] values) {
            this.fKey = key;
            this.fValues = values;
        }

        Key getKey() {
            return this.fKey;
        }

        String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.fValues[index];
        }

        String getValue(int index) {
            return this.fValues[index];
        }

        int getSelection(String value) {
            if (value != null) {
                int i = 0;
                while (i < this.fValues.length) {
                    if (value.equals(this.fValues[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.fValues.length - 1;
        }
    }

    static final class Key {
        private String fQualifier;
        private String fKey;

        Key(String qualifier, String key) {
            this.fQualifier = qualifier;
            this.fKey = key;
        }

        public String getName() {
            return this.fKey;
        }

        public Object getStoredValue(IJSFPreferenceModel prefModel, IScopeContext context, IWorkingCopyManager manager) {
            return prefModel.getStoredValueByKey(context, this.fKey);
        }

        public Object getCurValue(IJSFPreferenceModel prefModel, IScopeContext context, IWorkingCopyManager manager) {
            return prefModel.getValueByKey(context, this.fKey);
        }

        public Object getCurValue(IJSFPreferenceModel prefModel, IScopeContext[] lookupOrder, boolean ignoreTopScope, IWorkingCopyManager manager) {
            int i = ignoreTopScope ? 1 : 0;
            while (i < lookupOrder.length) {
                Object value = this.getCurValue(prefModel, lookupOrder[i], manager);
                if (value != null) {
                    return value;
                }
                ++i;
            }
            return null;
        }

        public Object setCurValue(IJSFPreferenceModel prefModel, IScopeContext context, Object value, IWorkingCopyManager manager) {
            return prefModel.setValueByKey(context, this.fKey, value);
        }

        public String toString() {
            return String.valueOf(this.fQualifier) + '/' + this.fKey;
        }

        public String getQualifier() {
            return this.fQualifier;
        }
    }
}

