/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.createrepo;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.rpm.createrepo.Activator;

public class CreaterepoCommandCreator {
    private static final String[] BOOLEAN_COMMANDS = new String[]{"md-filenames", "database", "skip-symlinks", "pretty", "checkts"};
    private static final String[] STRING_COMMANDS = new String[]{"checksum", "compress-type"};
    private static final String[] STRING_META_COMMANDS = new String[]{"revision", "distro", "content", "repo"};
    private static final String[] STRING_DELTA_COMMANDS = new String[]{"oldpackagedirs"};
    private static final String[] INT_COMMANDS = new String[]{"workers", "changelog-limit"};
    private static final String[] INT_DELTA_COMMANDS = new String[]{"max-delta-rpm-size", "num-deltas"};
    private IEclipsePreferences projectPreferences;
    private IPreferenceStore preferenceStore;
    private boolean project = Activator.isProjectPrefEnabled();
    private boolean delta = Activator.isDeltaPrefEnabled();

    public CreaterepoCommandCreator(IEclipsePreferences projectPreferences) {
        this.projectPreferences = projectPreferences;
        this.preferenceStore = Activator.getDefault().getPreferenceStore();
    }

    public List<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.addAll(this.prepareBooleanCommands());
        commands.addAll(this.prepareStringCommands());
        commands.addAll(this.prepareIntCommands());
        return commands;
    }

    public List<String> prepareBooleanCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        if (this.delta) {
            commands.add("--".concat("deltas"));
        }
        String[] stringArray = BOOLEAN_COMMANDS;
        int n = BOOLEAN_COMMANDS.length;
        int n2 = 0;
        while (n2 < n) {
            boolean value;
            String arg = stringArray[n2];
            boolean bl = value = this.project ? this.projectPreferences.getBoolean(arg, this.preferenceStore.getDefaultBoolean(arg)) : this.preferenceStore.getBoolean(arg);
            if (value) {
                arg = arg.equals("md-filenames") ? "--".concat("unique-").concat(arg) : "--".concat(arg);
                commands.add(arg);
            } else if (arg.equals("md-filenames")) {
                arg = "--".concat("simple-").concat(arg);
                commands.add(arg);
            } else if (arg.equals("database")) {
                arg = "--".concat("no-").concat(arg);
                commands.add(arg);
            }
            ++n2;
        }
        return commands;
    }

    public List<String> prepareStringCommands() {
        int n;
        int n2;
        String[] stringArray;
        String value;
        String arg;
        ArrayList<String> commands = new ArrayList<String>();
        String[] stringArray2 = STRING_COMMANDS;
        int n3 = STRING_COMMANDS.length;
        int n4 = 0;
        while (n4 < n3) {
            arg = stringArray2[n4];
            value = this.project ? this.projectPreferences.get(arg, this.preferenceStore.getDefaultString(arg)) : this.preferenceStore.getString(arg);
            arg = "--".concat(arg);
            if (!value.isEmpty()) {
                commands.add(arg);
                commands.add(value);
            }
            ++n4;
        }
        stringArray2 = STRING_META_COMMANDS;
        n3 = STRING_META_COMMANDS.length;
        n4 = 0;
        while (n4 < n3) {
            arg = stringArray2[n4];
            value = this.projectPreferences.get(arg, this.preferenceStore.getDefaultString(arg));
            arg = "--".concat(arg);
            stringArray = value.split(";");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String tag = stringArray[n];
                if (!tag.isEmpty()) {
                    commands.add(arg);
                    commands.add(tag);
                }
                ++n;
            }
            ++n4;
        }
        if (this.delta) {
            stringArray2 = STRING_DELTA_COMMANDS;
            n3 = STRING_DELTA_COMMANDS.length;
            n4 = 0;
            while (n4 < n3) {
                arg = stringArray2[n4];
                value = this.projectPreferences.get(arg, this.preferenceStore.getDefaultString(arg));
                arg = "--".concat(arg);
                stringArray = value.split(";");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    String dirs = stringArray[n];
                    if (!dirs.isEmpty()) {
                        commands.add(arg);
                        commands.add(dirs);
                    }
                    ++n;
                }
                ++n4;
            }
        }
        return commands;
    }

    public List<String> prepareIntCommands() {
        String arg;
        int n;
        int n2;
        String[] stringArray;
        ArrayList<String> commands = new ArrayList<String>();
        if (this.delta) {
            stringArray = INT_DELTA_COMMANDS;
            n2 = INT_DELTA_COMMANDS.length;
            n = 0;
            while (n < n2) {
                arg = stringArray[n];
                long value = this.projectPreferences.getInt(arg, this.preferenceStore.getDefaultInt(arg));
                if (arg.equals("max-delta-rpm-size")) {
                    value *= 0x100000L;
                }
                arg = "--".concat(arg);
                commands.add(arg);
                commands.add(Long.toString(value));
                ++n;
            }
        }
        stringArray = INT_COMMANDS;
        n2 = INT_COMMANDS.length;
        n = 0;
        while (n < n2) {
            arg = stringArray[n];
            int value = this.project ? this.projectPreferences.getInt(arg, this.preferenceStore.getDefaultInt(arg)) : this.preferenceStore.getInt(arg);
            arg = "--".concat(arg);
            commands.add(arg);
            commands.add(Integer.toString(value));
            ++n;
        }
        return commands;
    }
}

