/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MavenPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private String originalChecksumPolicy;

    public MavenPreferencePage() {
        super(1);
        this.setPreferenceStore(M2EUIPluginActivator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("eclipse.m2.offline", Messages.preferencesOffline, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("eclipse.m2.globalUpdatePolicy", Messages.preferencesGlobalUpdateNever, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("eclipse.m2.debugOutput", Messages.preferencesDebugOutput, this.getFieldEditorParent()));
        BooleanFieldEditor downloadSourcesField = new BooleanFieldEditor("eclipse.m2.downloadSources", Messages.preferencesDownloadSources, this.getFieldEditorParent());
        downloadSourcesField.getDescriptionControl(this.getFieldEditorParent()).setToolTipText(Messages.preferencesDownloadSourcesTooltip);
        this.addField((FieldEditor)downloadSourcesField);
        this.addField((FieldEditor)new BooleanFieldEditor("eclipse.m2.downloadJavadoc", Messages.preferencesDownloadJavadoc, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("eclipse.m2.updateIndexes", Messages.MavenPreferencePage_download, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("eclipse.m2.updateProjects", Messages.MavenPreferencePage_update, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("eclipse.m2.autoUpdateProjects", Messages.MavenPreferencePage_autoUpdateProjectConfiguration, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("eclipse.m2.hideFoldersOfNestedProjects", Messages.MavenPreferencePage_hide, this.getFieldEditorParent()));
        String[][] stringArray = new String[4][];
        String[] stringArray2 = new String[2];
        stringArray2[0] = Messages.preferencesGlobalChecksumPolicy_default;
        stringArray[0] = stringArray2;
        stringArray[1] = new String[]{Messages.preferencesGlobalChecksumPolicy_ignore, "ignore"};
        stringArray[2] = new String[]{Messages.preferencesGlobalChecksumPolicy_warn, "warn"};
        stringArray[3] = new String[]{Messages.preferencesGlobalChecksumPolicy_fail, "fail"};
        String[][] checksumPolicies = stringArray;
        this.originalChecksumPolicy = this.getPreferenceStore().getString("eclipse.m2.globalChecksumPolicy");
        ComboFieldEditor checksumPolicy = new ComboFieldEditor("eclipse.m2.globalChecksumPolicy", Messages.preferencesGlobalChecksumPolicy, checksumPolicies, this.getFieldEditorParent());
        checksumPolicy.getLabelControl(this.getFieldEditorParent()).setToolTipText(Messages.preferencesGlobalChecksumPolicy_tooltip);
        this.addField((FieldEditor)checksumPolicy);
        if (M2EUIPluginActivator.showExperimentalFeatures()) {
            BooleanFieldEditor nullSchedulingRule = new BooleanFieldEditor("builderUsesNullSchedulingRule", Messages.preferencesNullSchedulingRule, this.getFieldEditorParent());
            this.addField((FieldEditor)nullSchedulingRule);
        }
    }

    protected void performApply() {
        super.performApply();
        this.updateProjects();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result) {
            this.updateProjects();
        }
        return result;
    }

    private void updateProjects() {
        boolean proceed;
        List facades;
        boolean updateRequired;
        String newChecksumPolicy = this.getPreferenceStore().getString("eclipse.m2.globalChecksumPolicy");
        boolean bl = updateRequired = !this.originalChecksumPolicy.equals(newChecksumPolicy);
        if (updateRequired && (facades = MavenPlugin.getMavenProjectRegistry().getProjects()) != null && !facades.isEmpty() && (proceed = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.MavenPreferencePage_updateProjectRequired_title, (String)Messages.MavenPreferencePage_changingPreferencesRequiresProjectUpdate))) {
            ArrayList<IProject> allProjects = new ArrayList<IProject>(facades.size());
            for (IMavenProjectFacade facade : facades) {
                allProjects.add(facade.getProject());
            }
            new UpdateMavenProjectJob(allProjects, MavenPlugin.getMavenConfiguration().isOffline(), true, false, true, true).schedule();
        }
        this.originalChecksumPolicy = newChecksumPolicy;
    }
}

