/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.maven.plugin.ExtensionRealmCache;
import org.apache.maven.plugin.PluginArtifactsCache;
import org.apache.maven.plugin.PluginRealmCache;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectRealmCache;
import org.apache.maven.project.artifact.MavenMetadataCache;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.embedder.MavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.PlexusContainerManager;
import org.eclipse.m2e.core.internal.project.IManagedCache;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IProjectConfiguration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MavenProjectCache.class})
public class MavenProjectCache {
    private static final int MAX_CACHE_SIZE = Integer.getInteger("m2e.project.cache.size", 50);
    private static final String CTX_MAVENPROJECTS = String.valueOf(MavenProjectCache.class.getName()) + "/mavenProjects";
    @Reference
    PlexusContainerManager containerManager;
    private LoadingCache<CacheKey, CacheLine> loadingCache = CacheBuilder.newBuilder().maximumSize((long)MAX_CACHE_SIZE).removalListener(removed -> {
        Map<IMavenProjectFacade, MavenProject> contextProjects = MavenProjectCache.getContextProjectMap();
        ((CacheLine)removed.getValue()).projects.values().forEach(mavenProject -> {
            if (!contextProjects.containsValue(mavenProject)) {
                this.flushMavenCaches(mavenProject.getFile(), ((CacheKey)removed.getKey()).artifactKey(), false);
            }
        });
    }).build(CacheLoader.from(() -> new CacheLine()));

    public void invalidateProjectFacade(IMavenProjectFacade facade) {
        CacheLine cacheLine = (CacheLine)this.loadingCache.getIfPresent((Object)new CacheKey(facade.getArtifactKey(), facade.getConfiguration()));
        if (cacheLine != null) {
            cacheLine.remove(facade.getPomFile());
        }
    }

    public MavenProject getMavenProject(IMavenProjectFacade facade, Function<IMavenProjectFacade, MavenProject> projectLoader) {
        ArtifactKey artifactKey = facade.getArtifactKey();
        CacheLine cacheLine = (CacheLine)this.loadingCache.getUnchecked((Object)new CacheKey(artifactKey, facade.getConfiguration()));
        return cacheLine.getProject(facade, projectLoader);
    }

    public void updateMavenProject(IMavenProjectFacade facade, MavenProject mavenProject) {
        if (mavenProject == null) {
            this.invalidateProjectFacade(facade);
            return;
        }
        ArtifactKey artifactKey = facade.getArtifactKey();
        CacheLine cacheLine = (CacheLine)this.loadingCache.getUnchecked((Object)new CacheKey(artifactKey, facade.getConfiguration()));
        cacheLine.updateProject(facade, mavenProject);
    }

    Set<File> flushMavenCaches(File pom, ArtifactKey key, boolean force) {
        HashSet<File> affected = new HashSet<File>();
        affected.addAll(this.flushMavenCache(ProjectRealmCache.class, pom, key, force));
        affected.addAll(this.flushMavenCache(ExtensionRealmCache.class, pom, key, force));
        affected.addAll(this.flushMavenCache(PluginRealmCache.class, pom, key, force));
        affected.addAll(this.flushMavenCache(MavenMetadataCache.class, pom, key, force));
        affected.addAll(this.flushMavenCache(PluginArtifactsCache.class, pom, key, force));
        return affected;
    }

    /*
     * WARNING - void declaration
     */
    private Set<File> flushMavenCache(Class<?> clazz, File pom, ArtifactKey key, boolean force) {
        try {
            Object lookup;
            Object obj = lookup = this.containerManager.getComponentLookup(pom).lookup(clazz);
            if (obj instanceof IManagedCache var6_8) {
                void cache;
                return cache.removeProject(pom, key, force);
            }
        }
        catch (CoreException ex) {
            throw new AssertionError((Object)ex);
        }
        return Collections.emptySet();
    }

    static Map<IMavenProjectFacade, MavenProject> getContextProjectMap() {
        MavenExecutionContext context = MavenExecutionContext.getThreadContext(false);
        if (context != null) {
            IdentityHashMap projects = (IdentityHashMap)context.getValue(CTX_MAVENPROJECTS);
            if (projects == null) {
                projects = new IdentityHashMap();
                context.setValue(CTX_MAVENPROJECTS, projects);
            }
            return projects;
        }
        return new IdentityHashMap<IMavenProjectFacade, MavenProject>(1);
    }

    private void distributeProjectToCache(MavenProject mavenProject, IProjectConfiguration configuration) {
        File file;
        if (mavenProject == null) {
            return;
        }
        MavenProject parent = mavenProject.getParent();
        if (parent != null && (file = parent.getFile()) != null) {
            ArtifactKey projectKey = new ArtifactKey(parent.getArtifact());
            MavenProject cacheItem = ((CacheLine)this.loadingCache.getUnchecked((Object)new CacheKey((ArtifactKey)projectKey, (IProjectConfiguration)configuration))).projects.computeIfAbsent(file, x -> parent);
            if (cacheItem == parent) {
                this.distributeProjectToCache(parent, configuration);
            } else {
                mavenProject.setParent(cacheItem);
            }
        }
    }

    private record CacheKey(ArtifactKey artifactKey, IProjectConfiguration configuration) {
    }

    private final class CacheLine {
        private ConcurrentMap<File, MavenProject> projects = new ConcurrentHashMap<File, MavenProject>(1);

        private CacheLine() {
        }

        void remove(File pomFile) {
            this.projects.remove(pomFile);
        }

        void updateProject(IMavenProjectFacade facade, MavenProject mavenProject) {
            File pomFile = facade.getPomFile();
            this.projects.compute(pomFile, (key, current) -> {
                MavenProjectCache.this.distributeProjectToCache(mavenProject, facade.getConfiguration());
                return mavenProject;
            });
        }

        MavenProject getProject(IMavenProjectFacade facade, Function<IMavenProjectFacade, MavenProject> loader) {
            File pomFile = facade.getPomFile();
            if (loader == null) {
                return (MavenProject)this.projects.get(pomFile);
            }
            return this.projects.computeIfAbsent(pomFile, f -> {
                MavenProject mavenProject = (MavenProject)loader.apply(facade);
                MavenProjectCache.this.distributeProjectToCache(mavenProject, facade.getConfiguration());
                return mavenProject;
            });
        }
    }
}

