/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.jdt.IClasspathManager;
import org.eclipse.m2e.jdt.IClasspathManagerDelegate;
import org.eclipse.m2e.jdt.internal.ClasspathDescriptor;
import org.eclipse.m2e.jdt.internal.DefaultClasspathManagerDelegate;
import org.eclipse.m2e.jdt.internal.DownloadSourcesJob;
import org.eclipse.m2e.jdt.internal.InternalModuleInfo;
import org.eclipse.m2e.jdt.internal.MavenClasspathContainer;
import org.eclipse.m2e.jdt.internal.MavenClasspathContainerSaveHelper;
import org.eclipse.m2e.jdt.internal.MavenClasspathHelpers;
import org.eclipse.m2e.jdt.internal.Messages;
import org.eclipse.m2e.jdt.internal.ModuleSupport;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildPathManager
implements IMavenProjectChangedListener,
IResourceChangeListener,
IClasspathManager {
    private static final Logger log = LoggerFactory.getLogger(BuildPathManager.class);
    public static final int SOURCE_DOWNLOAD_PRIORITY = 50;
    public static final String M2_REPO = "M2_REPO";
    private static final String PROPERTY_SRC_ROOT = ".srcRoot";
    private static final String PROPERTY_SRC_ENCODING = ".srcEncoding";
    private static final String PROPERTY_SRC_PATH = ".srcPath";
    private static final String PROPERTY_JAVADOC_URL = ".javadoc";
    public static final String CLASSIFIER_SOURCES = "sources";
    public static final String CLASSIFIER_JAVADOC = "javadoc";
    public static final String CLASSIFIER_TESTS = "tests";
    public static final String CLASSIFIER_TESTSOURCES = "test-sources";
    public static final ArtifactFilter SCOPE_FILTER_RUNTIME = new ScopeArtifactFilter("runtime");
    public static final ArtifactFilter SCOPE_FILTER_TEST = new ScopeArtifactFilter("test");
    final IMavenProjectRegistry projectManager;
    final IMavenConfiguration mavenConfiguration;
    final BundleContext bundleContext;
    final IMaven maven;
    final File stateLocationDir;
    final Map<URI, InternalModuleInfo> moduleInfosMap = new ConcurrentHashMap<URI, InternalModuleInfo>();
    private final DownloadSourcesJob downloadSourcesJob;
    private final DefaultClasspathManagerDelegate defaultDelegate;
    private static final String ARTIFACT_TYPE_JAR = "jar";

    public BuildPathManager(IMavenProjectRegistry projectManager, BundleContext bundleContext, File stateLocationDir) {
        this.projectManager = projectManager;
        this.mavenConfiguration = MavenPlugin.getMavenConfiguration();
        this.bundleContext = bundleContext;
        this.stateLocationDir = stateLocationDir;
        this.maven = MavenPlugin.getMaven();
        this.downloadSourcesJob = new DownloadSourcesJob(this);
        this.downloadSourcesJob.setPriority(50);
        this.defaultDelegate = new DefaultClasspathManagerDelegate();
    }

    public static IClasspathEntry getMavenContainerEntry(IJavaProject javaProject) {
        if (javaProject != null) {
            try {
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (MavenClasspathHelpers.isMaven2ClasspathContainer(entry.getPath())) {
                        return entry;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException ex) {
                return null;
            }
        }
        return null;
    }

    public static IClasspathContainer getMaven2ClasspathContainer(IJavaProject project) throws JavaModelException {
        IClasspathEntry[] entries;
        IClasspathEntry[] iClasspathEntryArray = entries = project.getRawClasspath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 5 && MavenClasspathHelpers.isMaven2ClasspathContainer(entry.getPath())) {
                return JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
            }
            ++n2;
        }
        return null;
    }

    public void mavenProjectChanged(List<MavenProjectChangedEvent> events, IProgressMonitor monitor) {
        HashSet<IProject> projects = new HashSet<IProject>();
        monitor.setTaskName(Messages.BuildPathManager_monitor_setting_cp);
        for (MavenProjectChangedEvent event : events) {
            IFile pom = event.getSource();
            IProject project = pom.getProject();
            if (!project.isAccessible() || !projects.add(project)) continue;
            this.updateClasspath(project, monitor);
        }
    }

    @Override
    public void updateClasspath(IProject project, IProgressMonitor monitor) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            try {
                IClasspathEntry containerEntry = BuildPathManager.getMavenContainerEntry(javaProject);
                IPath path = containerEntry != null ? containerEntry.getPath() : new Path("org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER");
                IClasspathEntry[] classpath = this.getClasspath(project, monitor);
                MavenClasspathContainer container = new MavenClasspathContainer(path, classpath);
                JavaCore.setClasspathContainer((IPath)container.getPath(), (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{container}, (IProgressMonitor)monitor);
                this.saveContainerState(project, container);
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void saveContainerState(IProject project, IClasspathContainer container) {
        File containerStateFile = this.getContainerStateFile(project);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream is = new FileOutputStream(containerStateFile);){
                new MavenClasspathContainerSaveHelper().writeContainer(container, is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            log.error("Can't save classpath container state for " + project.getName(), (Throwable)ex);
        }
    }

    public IClasspathContainer getSavedContainer(IProject project) throws CoreException {
        File containerStateFile = this.getContainerStateFile(project);
        if (!containerStateFile.exists()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream is = new FileInputStream(containerStateFile);){
                return new MavenClasspathContainerSaveHelper().readContainer(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new CoreException(Status.error((String)("Can't read classpath container state for " + project.getName()), (Throwable)ex));
        }
    }

    private IClasspathEntry[] getClasspath(IMavenProjectFacade projectFacade, int kind, Properties sourceAttachment, boolean uniquePaths, IProgressMonitor monitor) throws CoreException {
        ClasspathDescriptor classpath = new ClasspathDescriptor(uniquePaths);
        this.getDelegate(projectFacade, monitor).populateClasspath(classpath, projectFacade, kind, monitor);
        this.configureAttachedSourcesAndJavadoc(projectFacade, sourceAttachment, classpath, monitor);
        IClasspathEntry[] entries = classpath.getEntries();
        if (uniquePaths) {
            LinkedHashMap<IPath, IClasspathEntry> paths = new LinkedHashMap<IPath, IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (!paths.containsKey(entry.getPath())) {
                    paths.put(entry.getPath(), entry);
                }
                ++n2;
            }
            return paths.values().toArray(new IClasspathEntry[paths.size()]);
        }
        return entries;
    }

    /*
     * WARNING - void declaration
     */
    private IClasspathManagerDelegate getDelegate(IMavenProjectFacade projectFacade, IProgressMonitor monitor) {
        void classpathManager;
        IClasspathManagerDelegate iClasspathManagerDelegate;
        ILifecycleMapping lifecycleMapping = LifecycleMappingFactory.getLifecycleMapping((IMavenProjectFacade)projectFacade);
        ILifecycleMapping iLifecycleMapping = lifecycleMapping;
        return iLifecycleMapping instanceof IClasspathManagerDelegate && (iClasspathManagerDelegate = (IClasspathManagerDelegate)iLifecycleMapping) == (IClasspathManagerDelegate)iLifecycleMapping ? classpathManager : this.defaultDelegate;
    }

    private void configureAttachedSourcesAndJavadoc(IMavenProjectFacade facade, Properties sourceAttachment, ClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
        for (IClasspathEntryDescriptor desc : classpath.getEntryDescriptors()) {
            String javaDocUrl;
            String srcEncoding;
            if (1 != desc.getEntryKind() || desc.getSourceAttachmentPath() != null) continue;
            ArtifactKey a = desc.getArtifactKey();
            String key = desc.getPath().toPortableString();
            IPath srcPath = desc.getSourceAttachmentPath();
            IPath srcRoot = desc.getSourceAttachmentRootPath();
            if (srcPath == null && sourceAttachment != null && sourceAttachment.containsKey(String.valueOf(key) + PROPERTY_SRC_PATH)) {
                srcPath = Path.fromPortableString((String)((String)sourceAttachment.get(String.valueOf(key) + PROPERTY_SRC_PATH)));
                if (sourceAttachment.containsKey(String.valueOf(key) + PROPERTY_SRC_ROOT)) {
                    srcRoot = Path.fromPortableString((String)((String)sourceAttachment.get(String.valueOf(key) + PROPERTY_SRC_ROOT)));
                }
            }
            if (srcPath == null && a != null) {
                srcPath = this.getSourcePath(a);
            }
            if (sourceAttachment != null && (srcEncoding = sourceAttachment.getProperty(String.valueOf(key) + PROPERTY_SRC_ENCODING)) != null) {
                desc.getClasspathAttributes().put("source_encoding", srcEncoding);
            }
            if ((javaDocUrl = desc.getJavadocUrl()) == null && sourceAttachment != null && sourceAttachment.containsKey(String.valueOf(key) + PROPERTY_JAVADOC_URL)) {
                javaDocUrl = (String)sourceAttachment.get(String.valueOf(key) + PROPERTY_JAVADOC_URL);
            }
            if (javaDocUrl == null && a != null) {
                javaDocUrl = this.getJavaDocUrl(a);
            }
            desc.setSourceAttachment(srcPath, srcRoot);
            desc.setJavadocUrl(javaDocUrl);
            ArtifactKey aKey = desc.getArtifactKey();
            if (aKey == null) continue;
            boolean isSnapshot = aKey.version().endsWith("-SNAPSHOT");
            File mainFile = desc.getPath() != null ? desc.getPath().toFile() : null;
            File srcFile = srcPath != null ? srcPath.toFile() : null;
            boolean downloadSources = srcPath == null && this.mavenConfiguration.isDownloadSources() || isSnapshot && BuildPathManager.isLastModifiedBefore(srcFile, mainFile);
            File javaDocFile = javaDocUrl != null ? this.getAttachedArtifactFile(aKey, CLASSIFIER_JAVADOC) : null;
            boolean downloadJavaDoc = javaDocUrl == null && this.mavenConfiguration.isDownloadJavaDoc() || isSnapshot && BuildPathManager.isLastModifiedBefore(javaDocFile, mainFile);
            this.scheduleDownload(facade.getProject(), facade.getMavenProject(monitor), aKey, downloadSources, downloadJavaDoc);
        }
    }

    private static boolean isLastModifiedBefore(File file, File ref) {
        return ref != null && ref.canRead() && file != null && file.canRead() && file.lastModified() < ref.lastModified();
    }

    private boolean isUnavailable(ArtifactKey a, List<ArtifactRepository> repositories) throws CoreException {
        return this.maven.isUnavailable(a.groupId(), a.artifactId(), a.version(), ARTIFACT_TYPE_JAR, a.classifier(), repositories);
    }

    public IClasspathEntry[] getClasspath(IProject project, int scope, IProgressMonitor monitor) throws CoreException {
        return this.getClasspath(project, scope, true, monitor);
    }

    @Override
    public IClasspathEntry[] getClasspath(IProject project, int scope, boolean uniquePaths, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = this.projectManager.create(project, monitor);
        if (facade == null) {
            return new IClasspathEntry[0];
        }
        try {
            Properties props = new Properties();
            File file = this.getSourceAttachmentPropertiesFile(project);
            if (file.canRead()) {
                Throwable throwable = null;
                Object var9_11 = null;
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                    props.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return this.getClasspath(facade, scope, props, uniquePaths, monitor);
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)"Can't save classpath container changes", (Throwable)e));
        }
    }

    public IClasspathEntry[] getClasspath(IProject project, IProgressMonitor monitor) throws CoreException {
        return this.getClasspath(project, 0, monitor);
    }

    private Set<ArtifactKey> findArtifacts(IProject project, IPath path) throws CoreException {
        ArrayList<IClasspathEntry> entries = this.findClasspathEntries(project, path);
        LinkedHashSet<ArtifactKey> artifacts = new LinkedHashSet<ArtifactKey>();
        for (IClasspathEntry entry : entries) {
            ArtifactKey artifact = this.findArtifactByArtifactKey(entry);
            if (artifact == null) continue;
            artifacts.add(artifact);
        }
        return artifacts;
    }

    public ArtifactKey findArtifact(IProject project, IPath path) throws CoreException {
        Set<ArtifactKey> artifacts;
        if (path != null && !(artifacts = this.findArtifacts(project, path)).isEmpty()) {
            return artifacts.iterator().next();
        }
        return null;
    }

    private ArtifactKey findArtifactByArtifactKey(IClasspathEntry entry) {
        IClasspathAttribute[] attributes = entry.getExtraAttributes();
        String groupId = null;
        String artifactId = null;
        String version = null;
        String classifier = null;
        IClasspathAttribute[] iClasspathAttributeArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            if ("maven.groupId".equals(attribute.getName())) {
                groupId = attribute.getValue();
            } else if ("maven.artifactId".equals(attribute.getName())) {
                artifactId = attribute.getValue();
            } else if ("maven.version".equals(attribute.getName())) {
                version = attribute.getValue();
            } else if ("maven.classifier".equals(attribute.getName())) {
                classifier = attribute.getValue();
            }
            ++n2;
        }
        if (groupId != null && artifactId != null && version != null) {
            return new ArtifactKey(groupId, artifactId, version, classifier);
        }
        return null;
    }

    private ArrayList<IClasspathEntry> findClasspathEntries(IProject project, IPath path) throws JavaModelException {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        this.addEntries(entries, javaProject.getRawClasspath(), path);
        IClasspathContainer container = BuildPathManager.getMaven2ClasspathContainer(javaProject);
        if (container != null) {
            this.addEntries(entries, container.getClasspathEntries(), path);
        }
        return entries;
    }

    private void addEntries(Collection<IClasspathEntry> collection, IClasspathEntry[] entries, IPath path) {
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 1 && (path == null || path.equals((Object)entry.getPath()))) {
                collection.add(entry);
            }
            ++n2;
        }
    }

    public void persistAttachedSourcesAndJavadoc(IJavaProject project, IClasspathContainer containerSuggestion, IProgressMonitor monitor) throws CoreException {
        String path;
        IClasspathEntry entry;
        IClasspathEntry[] entries;
        IFile pom = project.getProject().getFile("pom.xml");
        IMavenProjectFacade facade = this.projectManager.create(pom, false, null);
        if (facade == null) {
            return;
        }
        Properties props = new Properties();
        IClasspathEntry[] iClasspathEntryArray = entries = containerSuggestion.getClasspathEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            entry = iClasspathEntryArray[n2];
            if (1 == entry.getEntryKind()) {
                String javadocUrl;
                String sourceAttachmentEncoding;
                path = entry.getPath().toPortableString();
                if (entry.getSourceAttachmentPath() != null) {
                    props.put(String.valueOf(path) + PROPERTY_SRC_PATH, entry.getSourceAttachmentPath().toPortableString());
                }
                if (entry.getSourceAttachmentRootPath() != null) {
                    props.put(String.valueOf(path) + PROPERTY_SRC_ROOT, entry.getSourceAttachmentRootPath().toPortableString());
                }
                if ((sourceAttachmentEncoding = this.getSourceAttachmentEncoding(entry)) != null) {
                    props.put(String.valueOf(path) + PROPERTY_SRC_ENCODING, sourceAttachmentEncoding);
                }
                if ((javadocUrl = this.getJavadocLocation(entry)) != null) {
                    props.put(String.valueOf(path) + PROPERTY_JAVADOC_URL, javadocUrl);
                }
            }
            ++n2;
        }
        iClasspathEntryArray = entries = this.getClasspath(facade, 0, null, true, monitor);
        n = entries.length;
        n2 = 0;
        while (n2 < n) {
            entry = iClasspathEntryArray[n2];
            if (1 == entry.getEntryKind()) {
                path = entry.getPath().toPortableString();
                String value = (String)props.get(String.valueOf(path) + PROPERTY_SRC_PATH);
                if (value != null && entry.getSourceAttachmentPath() != null && value.equals(entry.getSourceAttachmentPath().toPortableString())) {
                    props.remove(String.valueOf(path) + PROPERTY_SRC_PATH);
                }
                if ((value = (String)props.get(String.valueOf(path) + PROPERTY_SRC_ROOT)) != null && entry.getSourceAttachmentRootPath() != null && value.equals(entry.getSourceAttachmentRootPath().toPortableString())) {
                    props.remove(String.valueOf(path) + PROPERTY_SRC_ROOT);
                }
            }
            ++n2;
        }
        File file = this.getSourceAttachmentPropertiesFile(project.getProject());
        try {
            Throwable throwable = null;
            Object var10_10 = null;
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
                props.store(os, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)"Can't save classpath container changes", (Throwable)e));
        }
        this.updateClasspath(project.getProject(), monitor);
    }

    public String getJavadocLocation(IClasspathEntry entry) {
        return MavenClasspathHelpers.getAttribute(entry, "javadoc_location");
    }

    public String getSourceAttachmentEncoding(IClasspathEntry entry) {
        return MavenClasspathHelpers.getAttribute(entry, "source_encoding");
    }

    public File getSourceAttachmentPropertiesFile(IProject project) {
        return new File(this.stateLocationDir, String.valueOf(project.getName()) + ".sources");
    }

    public File getContainerStateFile(IProject project) {
        return new File(this.stateLocationDir, String.valueOf(project.getName()) + ".container");
    }

    public void resourceChanged(IResourceChangeEvent event) {
        int type = event.getType();
        if (4 == type) {
            File containerState;
            IProject project = (IProject)event.getResource();
            File attachmentProperties = this.getSourceAttachmentPropertiesFile(project);
            if (attachmentProperties.exists() && !attachmentProperties.delete()) {
                log.error("Can't delete " + attachmentProperties.getAbsolutePath());
            }
            if ((containerState = this.getContainerStateFile(project)).exists() && !containerState.delete()) {
                log.error("Can't delete " + containerState.getAbsolutePath());
            }
            this.moduleInfosMap.remove(project.getLocationURI());
        } else if (1 == type) {
            IResourceDelta delta = event.getDelta();
            IResourceDelta[] resourceDeltas = delta.getAffectedChildren();
            final LinkedHashSet<IProject> affectedProjects = new LinkedHashSet<IProject>(resourceDeltas.length);
            ModuleInfoDetector visitor = new ModuleInfoDetector(affectedProjects);
            IResourceDelta[] iResourceDeltaArray = resourceDeltas;
            int n = resourceDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta d = iResourceDeltaArray[n2];
                IProject project = (IProject)d.getResource();
                if (ModuleSupport.isMavenJavaProject(project)) {
                    try {
                        d.accept((IResourceDeltaVisitor)visitor, false);
                    }
                    catch (CoreException ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                ++n2;
            }
            if (affectedProjects.isEmpty()) {
                return;
            }
            WorkspaceJob job = new WorkspaceJob(Messages.BuildPathManager_update_module_path_job_name){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)affectedProjects.size());
                    for (IProject p : affectedProjects) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (!this.requiresUpdate(p, (IProgressMonitor)subMonitor)) continue;
                        monitor.setTaskName(p.getName());
                        BuildPathManager.this.updateClasspath(p, (IProgressMonitor)subMonitor.newChild(1));
                    }
                    return Status.OK_STATUS;
                }

                private boolean requiresUpdate(IProject p, IProgressMonitor monitor) {
                    InternalModuleInfo newModuleInfo;
                    URI location;
                    block8: {
                        block7: {
                            IJavaProject jp;
                            block6: {
                                if (!ModuleSupport.isMavenJavaProject(p)) {
                                    return false;
                                }
                                jp = JavaCore.create((IProject)p);
                                try {
                                    IModuleDescription moduleDescription = jp.getModuleDescription();
                                    if (moduleDescription != null) break block6;
                                    return false;
                                }
                                catch (JavaModelException ex) {
                                    log.error(ex.getMessage(), (Throwable)ex);
                                    return false;
                                }
                            }
                            location = p.getLocationURI();
                            newModuleInfo = ModuleSupport.getModuleInfo(jp, monitor);
                            if (!monitor.isCanceled()) break block7;
                            return false;
                        }
                        InternalModuleInfo oldModuleInfo = BuildPathManager.this.moduleInfosMap.get(location);
                        if (!Objects.equals(newModuleInfo, oldModuleInfo)) break block8;
                        return false;
                    }
                    BuildPathManager.this.moduleInfosMap.put(location, newModuleInfo);
                    return true;
                }
            };
            job.setRule(MavenPlugin.getProjectConfigurationManager().getRule());
            job.schedule();
        }
    }

    public boolean setupVariables() {
        boolean changed = false;
        try {
            File localRepositoryDir = new File(this.maven.getLocalRepository().getBasedir());
            IPath oldPath = JavaCore.getClasspathVariable((String)M2_REPO);
            Path newPath = new Path(localRepositoryDir.getAbsolutePath());
            JavaCore.setClasspathVariable((String)M2_REPO, (IPath)newPath, (IProgressMonitor)new NullProgressMonitor());
            changed = !newPath.equals((Object)oldPath);
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            changed = false;
        }
        return changed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean variablesAreInUse() {
        try {
            IJavaProject[] projects;
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IJavaProject[] iJavaProjectArray = projects = model.getJavaProjects();
            int n = projects.length;
            int n2 = 0;
            block2: while (true) {
                IClasspathEntry[] entries;
                if (n2 >= n) {
                    return false;
                }
                IJavaProject project = iJavaProjectArray[n2];
                IClasspathEntry[] iClasspathEntryArray = entries = project.getRawClasspath();
                int n3 = entries.length;
                int n4 = 0;
                while (true) {
                    String var;
                    if (n4 >= n3) {
                        ++n2;
                        continue block2;
                    }
                    IClasspathEntry curr = iClasspathEntryArray[n4];
                    if (curr.getEntryKind() == 4 && M2_REPO.equals(var = curr.getPath().segment(0))) {
                        return true;
                    }
                    ++n4;
                }
                break;
            }
        }
        catch (JavaModelException e) {
            return true;
        }
    }

    static String getSourcesClassifier(String baseClassifier) {
        return CLASSIFIER_TESTS.equals(baseClassifier) ? CLASSIFIER_TESTSOURCES : CLASSIFIER_SOURCES;
    }

    private IPath getSourcePath(ArtifactKey a) {
        File file = this.getAttachedArtifactFile(a, BuildPathManager.getSourcesClassifier(a.classifier()));
        if (file != null) {
            return Path.fromOSString((String)file.getAbsolutePath());
        }
        return null;
    }

    private File getAttachedArtifactFile(ArtifactKey a, String classifier) {
        try {
            ArtifactRepository localRepository = this.maven.getLocalRepository();
            String relPath = this.maven.getArtifactPath(localRepository, a.groupId(), a.artifactId(), a.version(), ARTIFACT_TYPE_JAR, classifier);
            File file = new File(localRepository.getBasedir(), relPath).getCanonicalFile();
            if (file.canRead()) {
                return file;
            }
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String getJavaDocUrl(ArtifactKey base) {
        File file = this.getAttachedArtifactFile(base, CLASSIFIER_JAVADOC);
        return BuildPathManager.getJavaDocUrl(file);
    }

    static String getJavaDocUrl(File file) {
        try {
            if (file != null) {
                URL fileUrl = file.toURI().toURL();
                return "jar:" + fileUrl.toExternalForm() + "!/" + BuildPathManager.getJavaDocPathInArchive(file);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private static String getJavaDocPathInArchive(File file) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ZipFile jarFile = new ZipFile(file);){
                String marker = "package-list";
                Enumeration<? extends ZipEntry> en = jarFile.entries();
                while (en.hasMoreElements()) {
                    ZipEntry entry = en.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.endsWith(marker)) continue;
                    return entry.getName().substring(0, entryName.length() - marker.length());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    public Job getDownloadSourcesJob() {
        return this.downloadSourcesJob;
    }

    @Override
    public void scheduleDownload(IPackageFragmentRoot fragment, boolean downloadSources, boolean downloadJavadoc) {
        if (fragment == null) {
            return;
        }
        ArtifactKey artifact = (ArtifactKey)fragment.getAdapter(ArtifactKey.class);
        if (artifact == null) {
            return;
        }
        this.scheduleDownload(fragment, artifact, downloadSources, downloadJavadoc);
    }

    public void scheduleDownload(IPackageFragmentRoot fragment, ArtifactKey artifact, boolean downloadSources, boolean downloadJavadoc) {
        if (fragment == null || artifact == null) {
            return;
        }
        IProject project = fragment.getJavaProject().getProject();
        try {
            if (project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                MavenProject mavenProject;
                IMavenProjectFacade facade = this.projectManager.getProject(project);
                MavenProject mavenProject2 = mavenProject = facade != null ? facade.getMavenProject() : null;
                if (mavenProject != null) {
                    this.scheduleDownload(project, mavenProject, artifact, downloadSources, downloadJavadoc);
                } else {
                    this.downloadSourcesJob.scheduleDownload(project, artifact, downloadSources, downloadJavadoc);
                }
            } else {
                List repositories = this.maven.getArtifactRepositories();
                ArtifactKey[] attached = this.getAttachedSourcesAndJavadoc(artifact, repositories, downloadSources, downloadJavadoc);
                if (attached[0] != null || attached[1] != null) {
                    this.downloadSourcesJob.scheduleDownload(fragment, artifact, downloadSources, downloadJavadoc);
                }
            }
        }
        catch (CoreException e) {
            log.error("Could not schedule sources/javadoc download", (Throwable)e);
        }
    }

    @Override
    public void scheduleDownload(IProject project, boolean downloadSources, boolean downloadJavadoc) {
        try {
            if (project != null && project.isAccessible() && project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                MavenProject mavenProject;
                IMavenProjectFacade facade = this.projectManager.getProject(project);
                MavenProject mavenProject2 = mavenProject = facade != null ? facade.getMavenProject() : null;
                if (mavenProject != null) {
                    for (Artifact artifact : mavenProject.getArtifacts()) {
                        ArtifactKey artifactKey = new ArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getClassifier());
                        this.scheduleDownload(project, mavenProject, artifactKey, downloadSources, downloadJavadoc);
                    }
                } else {
                    this.downloadSourcesJob.scheduleDownload(project, null, downloadSources, downloadJavadoc);
                }
            }
        }
        catch (CoreException e) {
            log.error("Could not schedule sources/javadoc download", (Throwable)e);
        }
    }

    private void scheduleDownload(IProject project, MavenProject mavenProject, ArtifactKey artifact, boolean downloadSources, boolean downloadJavadoc) throws CoreException {
        ArtifactKey[] attached = this.getAttachedSourcesAndJavadoc(artifact, mavenProject.getRemoteArtifactRepositories(), downloadSources, downloadJavadoc);
        if (attached[0] != null || attached[1] != null) {
            this.downloadSourcesJob.scheduleDownload(project, artifact, downloadSources, downloadJavadoc);
        }
    }

    ArtifactKey[] getAttachedSourcesAndJavadoc(ArtifactKey a, List<ArtifactRepository> repositories, boolean downloadSources, boolean downloadJavaDoc) throws CoreException {
        ArtifactKey[] result = new ArtifactKey[2];
        if (repositories != null) {
            ArtifactKey sourcesArtifact = new ArtifactKey(a.groupId(), a.artifactId(), a.version(), BuildPathManager.getSourcesClassifier(a.classifier()));
            ArtifactKey javadocArtifact = new ArtifactKey(a.groupId(), a.artifactId(), a.version(), CLASSIFIER_JAVADOC);
            if (downloadSources) {
                if (this.isUnavailable(sourcesArtifact, repositories)) {
                    if (this.getAttachedArtifactFile(a, CLASSIFIER_JAVADOC) == null) {
                        downloadJavaDoc = true;
                    }
                } else {
                    result[0] = sourcesArtifact;
                }
            }
            if (downloadJavaDoc && !this.isUnavailable(javadocArtifact, repositories)) {
                result[1] = javadocArtifact;
            }
        }
        return result;
    }

    void attachSourcesAndJavadoc(IPackageFragmentRoot fragment, File sources, File javadoc, IProgressMonitor monitor) {
        IJavaProject javaProject = fragment.getJavaProject();
        IPath srcPath = sources != null ? Path.fromOSString((String)sources.getAbsolutePath()) : null;
        String javaDocUrl = BuildPathManager.getJavaDocUrl(javadoc);
        try {
            IClasspathEntry[] cp = javaProject.getRawClasspath();
            int i = 0;
            while (i < cp.length) {
                IClasspathEntry entry = cp[i];
                if (1 == entry.getEntryKind() && entry.equals(fragment.getRawClasspathEntry())) {
                    ArrayList<IClasspathAttribute> attributes = new ArrayList<IClasspathAttribute>(Arrays.asList(entry.getExtraAttributes()));
                    if (srcPath == null && javaDocUrl != null) {
                        attributes.add(JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javaDocUrl));
                    }
                    cp[i] = JavaCore.newLibraryEntry((IPath)entry.getPath(), (IPath)srcPath, null, (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])attributes.toArray(new IClasspathAttribute[attributes.size()]), (boolean)entry.isExported());
                    break;
                }
                ++i;
            }
            javaProject.setRawClasspath(cp, monitor);
        }
        catch (CoreException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    static class ModuleInfoDetector
    implements IResourceDeltaVisitor {
        private final Collection<IProject> affectedProjects;

        public ModuleInfoDetector(Collection<IProject> affectedProjects) {
            this.affectedProjects = affectedProjects;
        }

        /*
         * WARNING - void declaration
         */
        public boolean visit(IResourceDelta delta) {
            void var3_2;
            IFile iFile;
            IResource iResource = delta.getResource();
            if (iResource instanceof IFile && (iFile = (IFile)iResource) == (IFile)var3_2) {
                void file;
                if ("module-info.java".equals(file.getName())) {
                    this.affectedProjects.add(file.getProject());
                }
                return false;
            }
            return true;
        }
    }
}

