/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.sourcelookup.ui.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.launching.sourcelookup.advanced.AdvancedSourceLookup;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2e.core.ui.internal.actions.OpenPomAction;
import org.eclipse.m2e.core.ui.internal.actions.StaticMavenStorageEditorInput;
import org.eclipse.m2e.sourcelookup.internal.MetaInfMavenScanner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenPomCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        File location;
        block5: {
            ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
                return null;
            }
            location = AdvancedSourceLookup.getClassesLocation((Object)((IStructuredSelection)selection).getFirstElement());
            if (location != null) break block5;
            return null;
        }
        try {
            final String name = location.getName();
            List inputs = new MetaInfMavenScanner<IEditorInput>(){

                protected IEditorInput visitFile(Path file) throws IOException {
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
                        return OpenPomCommandHandler.toEditorInput(name, stream);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }

                protected IEditorInput visitJarEntry(JarFile jar, JarEntry entry) throws IOException {
                    return OpenPomCommandHandler.toEditorInput(name, jar.getInputStream(entry));
                }
            }.scan(location.toPath(), "pom.xml");
            if (!inputs.isEmpty()) {
                OpenPomAction.openEditor((IEditorInput)((IEditorInput)inputs.get(0)), (String)"pom.xml");
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    static StaticMavenStorageEditorInput toEditorInput(String name, InputStream is) throws IOException {
        return new StaticMavenStorageEditorInput(name, name, null, is.readAllBytes());
    }
}

