/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.papyrus.emf.facet.efacet.core.IDerivedTypedElementManager;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetManager;
import org.eclipse.papyrus.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.EmfUtils;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.exception.UnmatchingExpectedTypeException;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.EFacetFactory;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.ParameterValue;

public final class DerivedTypedElementUtils {
    private DerivedTypedElementUtils() {
    }

    private static <T> List<ParameterValue> createAndCheckOperationParameterValues(EOperation operation, Object ... arguments) throws UnmatchingExpectedTypeException {
        EList operationParameters = operation.getEParameters();
        if (arguments.length > 0 && operationParameters.size() != arguments.length) {
            throw new IllegalArgumentException("Facet operation '" + operation.getName() + "' expects " + operationParameters.size() + " parameters. Got " + arguments.length);
        }
        ArrayList<ParameterValue> parameterValues = new ArrayList<ParameterValue>();
        int i = 0;
        while (i < arguments.length) {
            Object argument = arguments[i];
            EParameter eParameter = (EParameter)operationParameters.get(i);
            EmfUtils.checkAssignment(argument, (ETypedElement)eParameter);
            ParameterValue parameterValue = EFacetFactory.eINSTANCE.createParameterValue();
            parameterValue.setParameter(eParameter);
            parameterValue.setValue(argument);
            parameterValues.add(parameterValue);
            ++i;
        }
        return parameterValues;
    }

    public static Object evaluate(EObject eObject, EOperation operation, IFacetManager facetManager, Object ... arguments) throws UnmatchingExpectedTypeException, DerivedTypedElementException {
        List<ParameterValue> parameterValues = DerivedTypedElementUtils.createAndCheckOperationParameterValues(operation, arguments);
        Object result = IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)((FacetOperation)operation), eObject, parameterValues, facetManager);
        return result;
    }
}

