/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.engine;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngineImpl;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsFactory;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class ViewpointCSSEngine
extends ExtendedCSSEngineImpl {
    private CSSDiagram diagram;

    public ViewpointCSSEngine(ExtendedCSSEngine parent, CSSDiagram diagram) {
        super(parent);
        this.diagram = diagram;
    }

    @Override
    protected void reloadStyleSheets() {
        this.styleSheets.clear();
        StyleSheet css = this.getViewpointDefinedStylesheet();
        if (css != null) {
            this.styleSheets.add(css);
        }
    }

    private StyleSheet getViewpointDefinedStylesheet() {
        ViewPrototype proto = ViewPrototype.get((EObject)this.diagram);
        if (proto == null) {
            return null;
        }
        PapyrusRepresentationKind conf = proto.getRepresentationKind();
        if (conf == null || !(conf instanceof PapyrusDiagram)) {
            return null;
        }
        String path = ((PapyrusDiagram)conf).getCustomStyle();
        if (path == null || path.isEmpty()) {
            return null;
        }
        StyleSheetReference ref = StylesheetsFactory.eINSTANCE.createStyleSheetReference();
        ref.setPath(path);
        return ref;
    }

    @Override
    public ExtendedCSSEngine.CascadeScope getCascadeScope() {
        return ExtendedCSSEngine.CascadeScope.VIEWPOINT;
    }
}

