/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.export.streamprovider;

import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.export.FileOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeCollapseAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandAllCommand;
import org.eclipse.papyrus.infra.nattable.dialog.ExportTableDialog;
import org.eclipse.papyrus.infra.nattable.enums.TreeTableAction;
import org.eclipse.papyrus.infra.nattable.export.image.ImageFormat;
import org.eclipse.swt.widgets.Shell;

public class PapyrusFileOutputStreamProvider
extends FileOutputStreamProvider {
    protected NatTable natTable = null;
    protected IResource defaultOutputDir = null;
    protected boolean isTreeTable = false;

    public PapyrusFileOutputStreamProvider(String defaultFileName, String[] defaultFilterNames, String[] defaultFilterExtensions) {
        super(defaultFileName, defaultFilterNames, defaultFilterExtensions);
    }

    public OutputStream getOutputStream(Shell shell) {
        ExportTableDialog dialog = new ExportTableDialog(shell, this.defaultOutputDir, this.defaultFileName, ImageFormat.IMAGE_EXTENSION_LIST, this.isTreeTable);
        this.currentFileName = null;
        this.extFilterIndex = -1;
        if (dialog.open() == 0) {
            this.currentFileName = dialog.getExportedFileName();
            this.extFilterIndex = dialog.getFilterIndex();
        }
        if (this.currentFileName == null) {
            return null;
        }
        if (this.isTreeTable && this.natTable != null) {
            TreeTableAction tableAction = TreeTableAction.getAction(dialog.getSelectedTreeAction());
            if (TreeTableAction.EXPAND.equals((Object)tableAction)) {
                this.natTable.doCommand((ILayerCommand)new TreeExpandAllCommand());
            } else if (TreeTableAction.COLLAPSE.equals((Object)tableAction)) {
                this.natTable.doCommand((ILayerCommand)new TreeCollapseAllCommand());
            }
        }
        try {
            return new PrintStream(this.currentFileName);
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.getString((String)"FileOutputStreamProvider.errorMessage", (Object[])new Object[]{this.currentFileName}), e);
        }
    }

    public void setParameters(NatTable natTable, String defaultFileName, IResource defaultOutputDir, boolean isTreeTable) {
        this.natTable = natTable;
        this.defaultFileName = defaultFileName;
        this.defaultOutputDir = defaultOutputDir;
        this.isTreeTable = isTreeTable;
    }
}

