/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.resource;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelResourceSet;
import org.eclipse.papyrus.uml.decoratormodel.profileExternalization.ApplyProfiles;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.UMLPackage;

public class DecoratorModelCopier {
    private final ResourceSet resourceSet;
    private final FilteredCopier copier;

    public DecoratorModelCopier(String modelName) {
        this(modelName, null);
    }

    public DecoratorModelCopier(String modelName, Set<URI> profileURIs) {
        Preconditions.checkArgument((profileURIs == null || !profileURIs.isEmpty() ? 1 : 0) != 0, (Object)"empty profileURIs set");
        this.resourceSet = new DecoratorModelResourceSet(profileURIs);
        this.copier = new FilteredCopier(modelName, profileURIs);
    }

    public void dispose() {
        this.copier.clear();
        EMFHelper.unload((ResourceSet)this.resourceSet);
    }

    public Resource copy(URI sourceModel, URI destinationModel) {
        Resource result = this.resourceSet.createResource(destinationModel, "org.eclipse.uml2.uml");
        Resource source = this.resourceSet.getResource(sourceModel, true);
        EList output = result.getContents();
        for (EObject next : source.getContents()) {
            if (!this.copier.shouldCopy(next)) continue;
            output.add(this.copier.copy(next));
        }
        this.copier.copyReferences();
        return result;
    }

    private static class FilteredCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 1L;
        private final String modelName;
        private final Set<URI> profileURIs;

        FilteredCopier(String modelName, Set<URI> profileURIs) {
            super(false);
            this.modelName = modelName;
            this.profileURIs = profileURIs;
        }

        protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
            if (eAttribute == UMLPackage.Literals.NAMED_ELEMENT__NAME && eObject.eContainer() == null) {
                copyEObject.eSet((EStructuralFeature)eAttribute, (Object)this.modelName);
            } else {
                super.copyAttribute(eAttribute, eObject, copyEObject);
            }
        }

        protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eObject instanceof Package) {
                Package package_ = (Package)eObject;
                if (package_.eContainer() == null) {
                    if (eReference == UMLPackage.Literals.PACKAGE__PACKAGED_ELEMENT) {
                        EList source = package_.getPackagedElements();
                        EList target = ((Package)copyEObject).getPackagedElements();
                        for (PackageableElement next : source) {
                            if (!this.shouldCopy((EObject)next)) continue;
                            target.add((PackageableElement)this.copy((EObject)next));
                        }
                    } else {
                        super.copyContainment(eReference, eObject, copyEObject);
                    }
                } else if (eReference == UMLPackage.Literals.PACKAGE__PROFILE_APPLICATION) {
                    EList source = package_.getProfileApplications();
                    EList target = ((Package)copyEObject).getProfileApplications();
                    for (ProfileApplication next : source) {
                        if (!this.shouldCopy((EObject)next)) continue;
                        target.add((ProfileApplication)this.copy((EObject)next));
                    }
                } else {
                    super.copyContainment(eReference, eObject, copyEObject);
                }
            } else {
                super.copyContainment(eReference, eObject, copyEObject);
            }
        }

        boolean shouldCopy(EObject object) {
            boolean result;
            boolean bl = result = this.profileURIs == null;
            if (!result) {
                if (object instanceof Package) {
                    boolean bl2 = result = object.eContainer() == null;
                    if (!result) {
                        for (ProfileApplication next : ((Package)object).getProfileApplications()) {
                            if (!this.shouldCopy((EObject)next)) continue;
                            result = true;
                            break;
                        }
                    }
                } else if (object instanceof ProfileApplication) {
                    ProfileApplication profileApplication = (ProfileApplication)object;
                    boolean bl3 = result = profileApplication.getApplyingPackage().eContainer() == null;
                    if (!result) {
                        Profile profile = ((ProfileApplication)object).getAppliedProfile();
                        result = this.profileURIs.contains(EcoreUtil.getURI((EObject)profile).trimFragment());
                    }
                } else {
                    result = object instanceof ApplyProfiles ? this.get(((ApplyProfiles)object).getBase_Dependency()) != null : (object.eContainer() == null ? this.profileURIs.contains(EcoreUtil.getURI((EObject)object.eClass()).trimFragment()) : true);
                }
            }
            return result;
        }
    }
}

