/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.xtext.integration;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.uml.xtext.integration.ActiveEditorTracker;
import org.eclipse.papyrus.uml.xtext.integration.core.IXtextFakeContextResourcesProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class XtextFakeResourceContext {
    @Inject
    private IResourceSetProvider resourceSetProvider;
    private ResourceSet fakeResourceSet;
    @Inject
    private XtextResource fakeResource;
    @Inject
    @Named(value="file.extensions")
    private String fakeResourceFileExtension;

    public XtextFakeResourceContext(Injector injector) {
        injector.injectMembers((Object)this);
        this.createXtextFakeResourceSet();
        this.initXtextFakeResource();
        this.initXtextFakeResourceSet();
    }

    protected void initXtextFakeResourceSet() {
        this.fakeResourceSet.getResources().add((Object)this.fakeResource);
    }

    protected ResourceSet getFakeResourceSet() {
        return this.fakeResourceSet;
    }

    protected void createXtextFakeResourceSet() {
        this.fakeResourceSet = this.resourceSetProvider.get(this.getActiveProject());
    }

    protected void initXtextFakeResource() {
        IProject activeProject = this.getActiveProject();
        String activeProjectName = activeProject != null ? activeProject.getName() : "fakeResource";
        this.fakeResource.setURI(this.createFakeResourceUri(activeProjectName));
    }

    public XtextResource getFakeResource() {
        return this.fakeResource;
    }

    private URI createFakeResourceBaseFragment(String activeProject) {
        return URI.createPlatformResourceURI((String)(String.valueOf(activeProject) + "/embedded"), (boolean)true);
    }

    private URI createFakeResourceUri(String activeProject) {
        return this.createFakeResourceBaseFragment(activeProject).appendFileExtension(this.fakeResourceFileExtension);
    }

    protected String getFileExtension() {
        return this.fakeResourceFileExtension;
    }

    protected IProject getActiveProject() {
        return ActiveEditorTracker.getLastActiveEditorProject();
    }

    public void updateFakeResourceContext(IXtextFakeContextResourcesProvider contextProvider) {
        ArrayList<Resource> staleResources = new ArrayList<Resource>();
        for (Resource r : this.fakeResourceSet.getResources()) {
            if (r == this.fakeResource) continue;
            staleResources.add(r);
            r.unload();
        }
        this.fakeResourceSet.getResources().removeAll(staleResources);
        this.fakeResourceSet.getResources().remove((Object)this.fakeResource);
        contextProvider.populateFakeResourceSet(this.fakeResourceSet, this.fakeResource);
        this.fakeResourceSet.getResources().add((Object)this.fakeResource);
    }
}

