/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.agreements.AgreementToAccept;
import org.eclipse.passage.lic.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.base.diagnostic.RequirementsCoverageExplained;
import org.eclipse.passage.lic.base.restrictions.CertificateIsRestrictive;
import org.eclipse.passage.lic.base.restrictions.CertificateWorthAttention;
import org.eclipse.passage.lic.equinox.EquinoxPassage;
import org.eclipse.passage.lic.equinox.EquinoxPassageLicenseCoverage;
import org.eclipse.passage.lic.equinox.access.CoverageCheckOptionDecision;
import org.eclipse.passage.lic.equinox.access.Interaction;
import org.eclipse.passage.lic.equinox.access.OptionAccept;
import org.eclipse.passage.lic.equinox.access.OptionDiagnostic;
import org.eclipse.passage.lic.equinox.access.OptionImport;
import org.eclipse.passage.lic.equinox.access.OptionProceed;
import org.eclipse.passage.lic.equinox.access.OptionQuit;
import org.eclipse.passage.lic.equinox.access.OptionRequest;
import org.eclipse.passage.lic.equinox.access.Options;

public final class LicenseCoverageCheck {
    private final Interaction.Smart interaction;

    public LicenseCoverageCheck(Interaction interaction) {
        this.interaction = new Interaction.Smart(interaction);
    }

    public Result run() {
        Optional<LicensedProduct> product = this.product();
        if (!product.isPresent()) {
            return Result.exit;
        }
        CoverageCheckOptionDecision intention = CoverageCheckOptionDecision.reassess;
        while (CoverageCheckOptionDecision.reassess.equals((Object)intention)) {
            ServiceInvocationResult<ExaminationCertificate> assessment = new EquinoxPassageLicenseCoverage().assess();
            this.reportAssessment(assessment.data());
            intention = this.options(assessment, product.get()).promptAndPick().run();
        }
        return CoverageCheckOptionDecision.proceed.equals((Object)intention) ? Result.proceed : Result.exit;
    }

    private Optional<LicensedProduct> product() {
        ServiceInvocationResult<LicensedProduct> product = new EquinoxPassage().product();
        if (!product.data().isPresent()) {
            this.interaction.prompt("Product configuration lacks product under licenseing definition. Contact the product vendor.");
        }
        return product.data();
    }

    private Options<CoverageCheckOptionDecision> options(ServiceInvocationResult<ExaminationCertificate> assessment, LicensedProduct product) {
        ArrayList options = new ArrayList();
        if (new CertificateIsRestrictive().test(assessment.data())) {
            options.add(new OptionImport(this.interaction, product));
            options.add(new OptionRequest(this.interaction));
            this.agreements(assessment).ifPresent(agreements -> {
                boolean bl = options.add(new OptionAccept(this.interaction, (Collection<AgreementToAccept>)agreements, product));
            });
            options.add(new OptionDiagnostic(this.interaction, assessment.diagnostic()));
            options.add(new OptionQuit(this.interaction));
            options.add(new OptionProceed(this.interaction));
        } else {
            options.add(new OptionImport(this.interaction, product));
            options.add(new OptionRequest(this.interaction));
            options.add(new OptionDiagnostic(this.interaction, assessment.diagnostic()));
            options.add(new OptionProceed(this.interaction));
        }
        return new Options<CoverageCheckOptionDecision>(this.interaction, options);
    }

    private Optional<Collection<AgreementToAccept>> agreements(ServiceInvocationResult<ExaminationCertificate> assessment) {
        if (!assessment.data().isPresent()) {
            return Optional.empty();
        }
        Collection agreements = ((ExaminationCertificate)assessment.data().get()).agreements();
        if (agreements.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(agreements);
    }

    private void reportAssessment(Optional<ExaminationCertificate> certificate) {
        this.interaction.head("License coverage assessment");
        if (certificate.isPresent()) {
            if (new CertificateIsRestrictive().test(certificate)) {
                this.interaction.prompt("License coverage for the product or its features is not sufficient");
            } else if (new CertificateWorthAttention().test(certificate)) {
                this.interaction.prompt("License coverage for the product or its features worth your attention");
            } else {
                this.interaction.prompt("License coverage for the product and all its feature is sufficient");
            }
            this.interaction.prompt(String.format("\n%s", new RequirementsCoverageExplained(certificate.get()).get()));
        } else {
            this.interaction.prompt("License status assessment failed");
        }
    }

    public static enum Result {
        proceed,
        exit;

    }
}

