/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.evaluation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.runtime.evaluation.ModelsManager;
import org.eclipse.qvtd.runtime.evaluation.TypedModelInstance;

public abstract class AbstractModelsManager
implements ModelsManager {
    private @Nullable Map<@NonNull PropertyId, @NonNull Integer> propertyId2propertyIndex;
    private @NonNull EReference @Nullable [] propertyIndex2eReference;
    private @NonNull Map<@NonNull Object, @NonNull Object> @Nullable [] object2oppositeObject;
    private @Nullable Map<@NonNull EReference, @NonNull Integer> eReference2propertyIndex = null;

    public void analyzeInputResources() {
        for (TypedModelInstance typedModelInstance : this.getTypedModelInstances()) {
            typedModelInstance.analyzeInputResources();
        }
    }

    public void analyzeOutputResources() {
        for (TypedModelInstance typedModelInstance : this.getTypedModelInstances()) {
            typedModelInstance.analyzeOutputResources();
        }
    }

    @Override
    public @NonNull Map<@NonNull Object, @NonNull Object>[] getObject2oppositeObject() {
        return this.object2oppositeObject;
    }

    @Override
    public int getOppositePropertyIndex(@NonNull EReference eReference) {
        Integer propertyIndex;
        Map<PropertyId, Integer> propertyId2propertyIndex2 = this.propertyId2propertyIndex;
        if (propertyId2propertyIndex2 == null) {
            return -1;
        }
        Map<@NonNull EReference, @NonNull Integer> eReference2propertyIndex2 = this.eReference2propertyIndex;
        if (eReference2propertyIndex2 == null) {
            this.eReference2propertyIndex = eReference2propertyIndex2 = new HashMap<EReference, Integer>();
        }
        if ((propertyIndex = eReference2propertyIndex2.get(eReference)) == null) {
            if (!(eReference.getEOpposite() != null || eReference.isDerived() || eReference.isTransient() || eReference.isVolatile())) {
                PropertyId propertyId = IdManager.getPropertyId((EStructuralFeature)eReference);
                propertyIndex = propertyId2propertyIndex2.get(propertyId);
            }
            if (propertyIndex == null) {
                propertyIndex = -1;
            }
            eReference2propertyIndex2.put(eReference, propertyIndex);
        }
        return propertyIndex;
    }

    @Override
    public @NonNull EReference @NonNull [] getPropertyIndex2eReference() {
        return (EReference[])ClassUtil.nonNullState((Object)this.propertyIndex2eReference);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void initOpposites(@NonNull PropertyId @NonNull [] propertyIndex2propertyId) {
        int propertyIds = propertyIndex2propertyId.length;
        HashMap<@NonNull PropertyId, @NonNull Integer> propertyId2propertyIndex2 = new HashMap<PropertyId, Integer>(propertyIds);
        this.propertyId2propertyIndex = propertyId2propertyIndex2;
        this.propertyIndex2eReference = new EReference[propertyIds];
        int propertyIndex = 0;
        while (propertyIndex < propertyIds) {
            PropertyId propertyId = propertyIndex2propertyId[propertyIndex];
            propertyId2propertyIndex2.put(propertyId, propertyIndex);
            ++propertyIndex;
        }
        @NonNull @NonNull @NonNull Map @Nullable [] object2oppositeObject = new HashMap[propertyIds];
        this.object2oppositeObject = object2oppositeObject;
        int i = 0;
        while (i < propertyIds) {
            object2oppositeObject[i] = new HashMap();
            ++i;
        }
    }

    @Override
    @Deprecated
    public void removeResources() {
        for (TypedModelInstance typedModelInstance : this.getTypedModelInstances()) {
            typedModelInstance.removeInputResources();
            typedModelInstance.removeOutputResources();
        }
    }

    @Override
    public void saveModels(@Nullable Map<?, ?> saveOptions) throws IOException {
        this.analyzeOutputResources();
        for (TypedModelInstance typedModelInstance : this.getTypedModelInstances()) {
            typedModelInstance.saveResources(saveOptions);
        }
    }
}

