/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.stream;

import com.google.common.math.DoubleMath;
import org.eclipse.tracecompass.internal.pcap.core.endpoint.ProtocolEndpointPair;
import org.eclipse.tracecompass.internal.pcap.core.packet.Packet;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapPacket;
import org.eclipse.tracecompass.internal.pcap.core.util.PcapTimestampScale;

public class PacketStream {
    private static final double SECOND_TO_NANOSECOND = 1.0E9;
    private static final double DELTA = 1.0E-9;
    private final PcapProtocol fProtocol;
    private final int fId;
    private final ProtocolEndpointPair fEndpointPair;
    private long fNbPacketsAtoB;
    private long fNbPacketsBtoA;
    private long fNbBytesAtoB;
    private long fNbBytesBtoA;
    private long fStartTime;
    private long fEndTime;

    PacketStream(PcapProtocol protocol, int id, ProtocolEndpointPair endpointPair) {
        this.fProtocol = protocol;
        this.fId = id;
        this.fEndpointPair = endpointPair;
        this.fNbPacketsAtoB = 0L;
        this.fNbPacketsBtoA = 0L;
        this.fNbBytesAtoB = 0L;
        this.fNbBytesBtoA = 0L;
        this.fStartTime = Long.MAX_VALUE;
        this.fEndTime = Long.MIN_VALUE;
    }

    synchronized void add(PcapPacket packet) {
        Packet newPacket = packet.getPacket(this.fProtocol);
        if (newPacket == null) {
            return;
        }
        if (this.fEndpointPair.getFirstEndpoint().equals(newPacket.getSourceEndpoint()) && this.fEndpointPair.getSecondEndpoint().equals(newPacket.getDestinationEndpoint())) {
            ++this.fNbPacketsAtoB;
            this.fNbBytesAtoB += packet.getOriginalLength();
        } else if (this.fEndpointPair.getFirstEndpoint().equals(newPacket.getDestinationEndpoint()) && this.fEndpointPair.getSecondEndpoint().equals(newPacket.getSourceEndpoint())) {
            ++this.fNbPacketsBtoA;
            this.fNbBytesBtoA += packet.getOriginalLength();
        } else {
            throw new IllegalStateException();
        }
        long timestamp = switch (packet.getTimestampScale()) {
            case PcapTimestampScale.MICROSECOND -> packet.getTimestamp() * 1000L;
            case PcapTimestampScale.NANOSECOND -> packet.getTimestamp();
            default -> throw new IllegalArgumentException("The timestamp precision is not valid!");
        };
        this.fStartTime = Math.min(this.fStartTime, timestamp);
        this.fEndTime = Math.max(this.fEndTime, timestamp);
    }

    public PcapProtocol getProtocol() {
        return this.fProtocol;
    }

    public int getID() {
        return this.fId;
    }

    public String getUniqueID() {
        return String.valueOf(this.fProtocol.getShortName()) + '.' + this.fId;
    }

    public ProtocolEndpointPair getEndpointPair() {
        return this.fEndpointPair;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Stream " + this.getUniqueID() + ", Number of Packets: " + this.getNbPackets() + "\n");
        return sb.toString();
    }

    public synchronized long getNbPacketsAtoB() {
        return this.fNbPacketsAtoB;
    }

    public synchronized long getNbPacketsBtoA() {
        return this.fNbPacketsBtoA;
    }

    public synchronized long getNbPackets() {
        return this.fNbPacketsAtoB + this.fNbPacketsBtoA;
    }

    public synchronized long getNbBytesAtoB() {
        return this.fNbBytesAtoB;
    }

    public synchronized long getNbBytesBtoA() {
        return this.fNbBytesBtoA;
    }

    public synchronized long getNbBytes() {
        return this.fNbBytesAtoB + this.fNbBytesBtoA;
    }

    public synchronized long getStartTime() {
        return this.fStartTime;
    }

    public synchronized long getStopTime() {
        return this.fEndTime;
    }

    public synchronized double getDuration() {
        return (double)(this.fEndTime - this.fStartTime) / 1.0E9;
    }

    public synchronized double getBPSAtoB() {
        if (DoubleMath.fuzzyEquals((double)this.getDuration(), (double)0.0, (double)1.0E-9)) {
            return 0.0;
        }
        return (double)this.fNbBytesAtoB / this.getDuration();
    }

    public synchronized double getBPSBtoA() {
        if (DoubleMath.fuzzyEquals((double)this.getDuration(), (double)0.0, (double)1.0E-9)) {
            return 0.0;
        }
        return (double)this.fNbBytesBtoA / this.getDuration();
    }
}

