/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.dialogfields;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;

public class SpinnerDialogField
extends DialogField {
    private int m_selection = 0;
    private Spinner m_spinner;
    private ModifyListener m_modifyListener;
    private int m_minimum;
    private int m_maximum = 100;

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)SpinnerDialogField.gridDataForLabel(1));
        Control spinner = this.getSpinnerControl(parent);
        spinner.setLayoutData((Object)SpinnerDialogField.gridDataForSpinner(nColumns - 1));
        return new Control[]{label, spinner};
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    protected static GridData gridDataForSpinner(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this.m_spinner)) {
            this.m_spinner.setFocus();
        }
        return true;
    }

    public Control getSpinnerControl(Composite parent) {
        if (this.m_spinner == null) {
            this.assertCompositeNotNull(parent);
            this.m_modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SpinnerDialogField.this.doModifyText(e);
                }
            };
            this.m_spinner = new Spinner(parent, 2052);
            this.m_spinner.setMinimum(this.m_minimum);
            this.m_spinner.setMaximum(this.m_maximum);
            this.m_spinner.setSelection(this.m_selection);
            this.m_spinner.addModifyListener(this.m_modifyListener);
            this.m_spinner.setFont(parent.getFont());
            this.m_spinner.setEnabled(this.isEnabled());
        }
        return this.m_spinner;
    }

    private void doModifyText(ModifyEvent e) {
        if (this.isOkToUse((Control)this.m_spinner)) {
            this.m_selection = this.m_spinner.getSelection();
        }
        this.dialogFieldChanged();
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.m_spinner)) {
            this.m_spinner.setEnabled(this.isEnabled());
        }
    }

    public void setMinimum(int minimum) {
        this.m_minimum = minimum;
        if (this.isOkToUse((Control)this.m_spinner)) {
            this.m_spinner.setMinimum(this.m_minimum);
        }
    }

    public void setMaximum(int maximum) {
        this.m_maximum = maximum;
        if (this.isOkToUse((Control)this.m_spinner)) {
            this.m_spinner.setMaximum(this.m_maximum);
        }
    }

    public int getSelection() {
        return this.m_selection;
    }

    public void setSelection(int selection) {
        this.m_selection = selection;
        if (this.isOkToUse((Control)this.m_spinner)) {
            this.m_spinner.setSelection(selection);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setSelectionWithoutUpdate(int selection) {
        this.m_selection = selection;
        if (this.isOkToUse((Control)this.m_spinner)) {
            this.m_spinner.removeModifyListener(this.m_modifyListener);
            this.m_spinner.setSelection(selection);
            this.m_spinner.addModifyListener(this.m_modifyListener);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.m_spinner)) {
            this.setSelectionWithoutUpdate(this.m_selection);
        }
    }
}

