/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.internal.sourcemap;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.extension.ISourceMapLanguageSupport;

public class SourceMapLanguageSupportType {
    private final String id;
    private final ISourceMapLanguageSupport support;
    private final Set<String> fileExtensions;

    public SourceMapLanguageSupportType(IConfigurationElement ce) throws CoreException {
        this.id = ce.getAttribute("id");
        this.support = (ISourceMapLanguageSupport)ce.createExecutableExtension("class");
        this.fileExtensions = this.createFileExtensions(ce);
    }

    private Set<String> createFileExtensions(IConfigurationElement ce) {
        String[] fileExtensions = ce.getAttribute("fileExtensions").split(",");
        HashSet<String> set = new HashSet<String>();
        String[] stringArray = fileExtensions;
        int n = fileExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String fileExtension = stringArray[n2];
            set.add(fileExtension.trim());
            ++n2;
        }
        return set;
    }

    public ISourceMapLanguageSupport getSupport() {
        return this.support;
    }

    public String getId() {
        return this.id;
    }

    public boolean canSupportSourceMap(String fileExtension) {
        return this.fileExtensions.contains(fileExtension);
    }
}

