/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2e.actions.MavenLaunchConstants;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.internal.launch.LaunchingUtils;
import org.eclipse.m2e.internal.launch.MavenLaunchExtensionsSupport;
import org.eclipse.m2e.internal.launch.MavenLaunchUtils;
import org.eclipse.m2e.internal.launch.MavenRuntimeLaunchSupport;
import org.eclipse.m2e.internal.launch.Messages;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenLaunchDelegate
extends JavaLaunchDelegate
implements MavenLaunchConstants {
    private static final Logger log;
    private static final ILog ECLIPSE_LOG;
    private static final String LAUNCHER_TYPE = "org.codehaus.classworlds.Launcher";
    private static final String LAUNCHER_TYPE3 = "org.codehaus.plexus.classworlds.launcher.Launcher";
    private static final String ANSI_SUPPORT_QUALIFIER = "org.eclipse.ui.console";
    private static final String ANSI_SUPPORT_KEY = "ANSI_support_enabled";
    private static final VersionRange MAVEN_33PLUS_RUNTIMES;
    private ILaunch launch;
    private IProgressMonitor monitor;
    private String programArguments;
    private MavenRuntimeLaunchSupport launchSupport;
    private MavenLaunchExtensionsSupport extensionsSupport;
    private IPreferencesService preferencesService;
    private static final String GOAL_ENFORCE = "enforce";
    private static final String ENFORCER_PLUGIN_ARTIFACT_ID = "maven-enforcer-plugin";
    private static final String ENFORCER_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    private static final ArtifactVersion DEFAULT_JAVA_VERSION;

    static {
        VersionRange mvn33PlusRange;
        log = LoggerFactory.getLogger(MavenLaunchDelegate.class);
        ECLIPSE_LOG = Platform.getLog(MavenLaunchDelegate.class);
        try {
            mvn33PlusRange = VersionRange.createFromVersionSpec((String)"[3.3,)");
        }
        catch (InvalidVersionSpecificationException O_o) {
            mvn33PlusRange = null;
        }
        MAVEN_33PLUS_RUNTIMES = mvn33PlusRange;
        DEFAULT_JAVA_VERSION = new DefaultArtifactVersion("0.0.0");
    }

    public MavenLaunchDelegate() {
        this.allowAdvancedSourcelookup();
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.launch = launch;
        this.monitor = monitor;
        this.programArguments = null;
        try {
            this.launchSupport = MavenRuntimeLaunchSupport.create(configuration, monitor);
            this.extensionsSupport = MavenLaunchExtensionsSupport.create(configuration, launch);
            this.preferencesService = Platform.getPreferencesService();
            log.info("Run build in \"{}\":", (Object)this.getWorkingDirectory(configuration));
            log.info(" mvn {}", (Object)this.getProgramArguments(configuration));
            this.extensionsSupport.configureSourceLookup(configuration, launch, monitor);
            super.launch(configuration, mode, launch, monitor);
        }
        finally {
            this.launch = null;
            this.monitor = null;
            this.launchSupport = null;
            this.extensionsSupport = null;
            this.preferencesService = null;
        }
    }

    protected boolean saveBeforeLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (configuration.getAttribute("M2_SAVE_BEFORE_LAUNCH", true)) {
            return super.saveBeforeLaunch(configuration, mode, monitor);
        }
        return true;
    }

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.launchSupport.decorateVMRunner(super.getVMRunner(configuration, mode));
    }

    public String getMainTypeName(ILaunchConfiguration configuration) {
        return this.launchSupport.getVersion().startsWith("3.") ? LAUNCHER_TYPE3 : LAUNCHER_TYPE;
    }

    public String[] getClasspath(ILaunchConfiguration configuration) {
        List<String> cp = this.launchSupport.getBootClasspath();
        return (String[])cp.toArray(String[]::new);
    }

    public String[][] getClasspathAndModulepath(ILaunchConfiguration configuration) {
        String[][] paths = new String[2][];
        paths[0] = this.getClasspath(configuration);
        return paths;
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        if (this.programArguments == null) {
            String goals = this.getGoals(configuration);
            StringBuilder sb = new StringBuilder();
            this.getProperties(sb, configuration);
            this.getPreferences(sb, configuration, goals);
            sb.append(" ").append(goals);
            this.extensionsSupport.appendProgramArguments(sb, configuration, this.launch, this.monitor);
            this.programArguments = sb.toString();
        }
        return this.programArguments;
    }

    public static File getPomDirectory(ILaunchConfiguration configuration) {
        String pomDir;
        if (configuration == null) {
            return null;
        }
        try {
            pomDir = configuration.getAttribute(MavenLaunchConstants.ATTR_POM_DIR, "");
        }
        catch (CoreException ex) {
            log.warn("Failed to retrieve attribute '{}' from launch configuration {}", (Object)MavenLaunchConstants.ATTR_POM_DIR, (Object)configuration.getName());
            return null;
        }
        try {
            return new File(LaunchingUtils.substituteVar(pomDir));
        }
        catch (CoreException e) {
            log.debug("Cannot substitute vars in {}", (Object)pomDir, (Object)e);
            return null;
        }
    }

    public static Optional<IContainer> getContainer(File file) {
        return Optional.ofNullable(file).map(f -> Path.fromOSString((String)f.toString())).map(arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getContainerForLocation(arg_0));
    }

    public IVMInstall getVMInstall(ILaunchConfiguration configuration) throws CoreException {
        IVMInstall jre;
        String requiredJavaVersion;
        File pomDirectory = MavenLaunchDelegate.getPomDirectory(configuration);
        if (!configuration.hasAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH) && (requiredJavaVersion = MavenLaunchDelegate.readEnforcedJavaVersion(pomDirectory, this.monitor)) != null && (jre = MavenLaunchDelegate.getBestMatchingVM(requiredJavaVersion)) != null) {
            return jre;
        }
        Optional<IProject> project = MavenLaunchDelegate.getContainer(pomDirectory).map(IResource::getProject).filter(p -> JavaCore.create((IProject)p).exists());
        if (project.isPresent()) {
            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.get().getName());
            configuration = workingCopy;
        }
        return super.getVMInstall(configuration);
    }

    public static String readEnforcedJavaVersion(File pomDirectory, IProgressMonitor monitor) {
        try {
            IFile pomFile;
            IMavenProjectRegistry projectManager;
            IMavenProjectFacade mavenProject;
            Optional<IContainer> container = MavenLaunchDelegate.getContainer(pomDirectory);
            if (container.isPresent() && (mavenProject = (projectManager = MavenPlugin.getMavenProjectRegistry()).create(pomFile = container.get().getFile(Path.fromOSString((String)"pom.xml")), true, (IProgressMonitor)new NullProgressMonitor())) != null) {
                return MavenLaunchDelegate.readEnforcedVersion(mavenProject, monitor);
            }
        }
        catch (CoreException ex) {
            MavenLaunchDelegate.logEnforcedJavaVersionCalculationError(ex);
        }
        return null;
    }

    private static String readEnforcedVersion(IMavenProjectFacade project, IProgressMonitor monitor) throws CoreException {
        List mojoExecutions = project.getMojoExecutions(ENFORCER_PLUGIN_GROUP_ID, ENFORCER_PLUGIN_ARTIFACT_ID, monitor, new String[]{GOAL_ENFORCE});
        for (MojoExecution mojoExecution : mojoExecutions) {
            String version = MavenLaunchDelegate.getRequiredJavaVersionFromEnforcerRule(project.getMavenProject(monitor), mojoExecution, monitor);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    private static String getRequiredJavaVersionFromEnforcerRule(MavenProject mavenProject, MojoExecution mojoExecution, IProgressMonitor monitor) throws CoreException {
        List<String> parameter = List.of("rules", "requireJavaVersion", "version");
        String version = (String)((MavenImpl)MavenPlugin.getMaven()).getMojoParameterValue(mavenProject, mojoExecution, parameter, String.class, monitor);
        if (version == null) {
            return null;
        }
        if ("8".equals(version)) {
            version = "1.8";
        }
        return version;
    }

    private static void logEnforcedJavaVersionCalculationError(Throwable e) {
        ECLIPSE_LOG.error("Failed to determine required Java version from maven-enforcer-plugin configuration, assuming default", e);
    }

    public static IVMInstall getBestMatchingVM(String requiredVersion) {
        try {
            VersionRange versionRange = VersionRange.createFromVersionSpec((String)requiredVersion);
            List<IVMInstall> matchingJREs = MavenLaunchDelegate.getAllMatchingJREs(versionRange);
            Object mainVersion = versionRange.getRecommendedVersion() != null ? versionRange.getRecommendedVersion() : (versionRange.getRestrictions().size() == 1 && ((Restriction)versionRange.getRestrictions().get(0)).getUpperBound() == null ? ((Restriction)versionRange.getRestrictions().get(0)).getLowerBound() : null);
            if (mainVersion != null) {
                return matchingJREs.stream().filter(arg_0 -> MavenLaunchDelegate.lambda$5((ArtifactVersion)mainVersion, arg_0)).findFirst().orElse(null);
            }
            return !matchingJREs.isEmpty() ? matchingJREs.get(0) : null;
        }
        catch (InvalidVersionSpecificationException ex) {
            log.warn("Invalid version range", (Throwable)ex);
            return null;
        }
    }

    private static List<IVMInstall> getAllMatchingJREs(VersionRange versionRange) {
        TreeMap installedJREsByVersion = new TreeMap(Comparator.reverseOrder());
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = iVMInstallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstallType vmType = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = vmType.getVMInstalls();
            int n3 = iVMInstallArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall vm = iVMInstallArray[n4];
                if (MavenLaunchDelegate.satisfiesVersionRange(vm, versionRange)) {
                    if (vm instanceof IVMInstall2 var10_10) {
                        installedJREsByVersion.put(new DefaultArtifactVersion(vm2.getJavaVersion()), vm);
                    } else {
                        log.debug("Skipping IVMInstall '{}' from type {} as not implementing IVMInstall2", (Object)vm.getName(), (Object)vmType.getName());
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return List.copyOf(installedJREsByVersion.values());
    }

    private static boolean satisfiesVersionRange(IVMInstall jre, VersionRange versionRange) {
        ArtifactVersion jreVersion = MavenLaunchDelegate.getArtifactVersion(jre);
        if (versionRange.getRecommendedVersion() != null) {
            return jreVersion.compareTo((Object)versionRange.getRecommendedVersion()) >= 0;
        }
        return versionRange.containsVersion(jreVersion);
    }

    /*
     * WARNING - void declaration
     */
    private static ArtifactVersion getArtifactVersion(IVMInstall jre) {
        void jre2;
        IVMInstall2 iVMInstall2;
        IVMInstall iVMInstall = jre;
        return iVMInstall instanceof IVMInstall2 && (iVMInstall2 = (IVMInstall2)iVMInstall) == (IVMInstall2)iVMInstall ? new DefaultArtifactVersion(jre2.getJavaVersion()) : DEFAULT_JAVA_VERSION;
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        MavenRuntimeLaunchSupport.VMArguments arguments = this.launchSupport.getVMArguments();
        AbstractMavenRuntime runtime = MavenLaunchUtils.getMavenRuntime(configuration);
        this.appendRuntimeSpecificArguments(runtime.getVersion(), arguments, configuration);
        this.extensionsSupport.appendVMArguments(arguments, configuration, this.launch, this.monitor);
        arguments.append(super.getVMArguments(configuration));
        return arguments.toString();
    }

    protected String getGoals(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("M2_GOALS", "");
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) {
        return false;
    }

    private void getProperties(StringBuilder sb, ILaunchConfiguration configuration) throws CoreException {
        List properties;
        try {
            properties = configuration.getAttribute("M2_PROPERTIES", Collections.emptyList());
        }
        catch (CoreException e) {
            log.error("Exception while getting configuration attribute M2_PROPERTIES", (Throwable)e);
            throw e;
        }
        for (String property : properties) {
            int n = property.indexOf(61);
            String name = property;
            String value = null;
            if (n > -1) {
                name = property.substring(0, n);
                if (n > 1) {
                    String substring = property.substring(n + 1);
                    try {
                        value = LaunchingUtils.substituteVar(substring);
                    }
                    catch (CoreException e) {
                        log.debug("Exception while substitute variables in substring " + substring + " using raw value.", (Throwable)e);
                        value = substring;
                    }
                }
            }
            sb.append(" -D").append(name);
            if (value == null) continue;
            sb.append('=').append(MavenLaunchUtils.quote(value));
        }
        try {
            String profiles = configuration.getAttribute("M2_PROFILES", null);
            if (profiles != null && profiles.trim().length() > 0) {
                sb.append(" -P").append(profiles.replaceAll("\\s+", ","));
            }
        }
        catch (CoreException ex) {
            log.error("Exception while getting configuration attribute M2_PROFILES", (Throwable)ex);
            throw ex;
        }
    }

    private void getPreferences(StringBuilder sb, ILaunchConfiguration configuration, String goals) throws CoreException {
        int colors;
        int threads;
        IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
        if (configuration.getAttribute("M2_BATCH", true)) {
            sb.append(" -B");
        }
        if (configuration.getAttribute("M2_DEBUG_OUTPUT", mavenConfiguration.isDebugOutput())) {
            sb.append(" -X").append(" -e");
        }
        if (configuration.getAttribute("M2_OFFLINE", mavenConfiguration.isOffline())) {
            sb.append(" -o");
        }
        if (configuration.getAttribute("M2_UPDATE_SNAPSHOTS", false)) {
            sb.append(" -U");
        }
        if (configuration.getAttribute("M2_NON_RECURSIVE", false)) {
            sb.append(" -N");
        }
        if (configuration.getAttribute("M2_SKIP_TESTS", false)) {
            sb.append(" -Dmaven.test.skip=true -DskipTests");
        }
        if ((threads = configuration.getAttribute("M2_THREADS", 1)) > 1) {
            sb.append(" --threads ").append(threads);
        }
        if ((colors = configuration.getAttribute("M2_COLORS", 0)) == 0) {
            colors = this.isAnsiProcessingEnabled() ? 1 : 2;
        }
        String enableColor = switch (colors) {
            case 1 -> "always";
            case 2 -> "never";
            default -> throw new IllegalArgumentException("Unexpected value forM2_COLORS: " + colors);
        };
        sb.append(" -Dstyle.color=" + enableColor);
        if (!goals.contains("-gs ")) {
            String globalSettings = this.launchSupport.getSettings();
            if (globalSettings != null && !globalSettings.trim().isEmpty() && !new File(globalSettings.trim()).exists()) {
                globalSettings = null;
            }
            if (globalSettings != null && !globalSettings.trim().isEmpty()) {
                sb.append(" -gs ").append(MavenLaunchUtils.quote(globalSettings));
            }
        }
        String settings = configuration.getAttribute("M2_USER_SETTINGS", null);
        if (!((settings = LaunchingUtils.substituteVar(settings)) != null && !settings.trim().isEmpty() || (settings = mavenConfiguration.getUserSettingsFile()) == null || settings.trim().isEmpty() || new File(settings.trim()).exists())) {
            settings = null;
        }
        if (settings != null && !settings.trim().isEmpty()) {
            sb.append(" -s ").append(MavenLaunchUtils.quote(settings));
        }
    }

    private boolean isAnsiProcessingEnabled() {
        return this.preferencesService.getBoolean(ANSI_SUPPORT_QUALIFIER, ANSI_SUPPORT_KEY, true, null);
    }

    public void appendRuntimeSpecificArguments(String runtimeVersion, MavenRuntimeLaunchSupport.VMArguments arguments, ILaunchConfiguration configuration) throws CoreException {
        if (this.applies(runtimeVersion)) {
            this.getArgsFromMvnDir(arguments, configuration);
        }
    }

    private void getArgsFromMvnDir(MavenRuntimeLaunchSupport.VMArguments arguments, ILaunchConfiguration configuration) throws CoreException {
        String pomDir = LaunchingUtils.substituteVar(configuration.getAttribute(MavenLaunchConstants.ATTR_POM_DIR, ""));
        if (pomDir.isEmpty()) {
            return;
        }
        File baseDir = this.findMavenProjectBasedir(new File(pomDir));
        File mvnDir = new File(baseDir, ".mvn");
        File jvmConfig = new File(mvnDir, "jvm.config");
        if (jvmConfig.isFile()) {
            try {
                for (String line : Files.readAllLines(jvmConfig.toPath(), StandardCharsets.UTF_8)) {
                    arguments.append(line);
                }
            }
            catch (IOException ex) {
                String msg = NLS.bind((String)Messages.MavenLaunchDelegate_error_cannot_read_jvmConfig, (Object)jvmConfig.getAbsolutePath());
                throw new CoreException(Status.error((String)msg, (Throwable)ex));
            }
        }
        arguments.appendProperty("maven.multiModuleProjectDirectory", MavenLaunchUtils.quote(baseDir.getAbsolutePath()));
    }

    private File findMavenProjectBasedir(File dir) {
        File folder = dir;
        while (folder != null && folder.getParentFile() != null) {
            if (new File(folder, ".mvn").isDirectory()) {
                return folder;
            }
            folder = folder.getParentFile();
        }
        return dir;
    }

    private boolean applies(String runtimeVersion) {
        return MAVEN_33PLUS_RUNTIMES.containsVersion((ArtifactVersion)new DefaultArtifactVersion(runtimeVersion));
    }

    private static /* synthetic */ boolean lambda$5(ArtifactVersion artifactVersion, IVMInstall jre) {
        return MavenLaunchDelegate.getArtifactVersion(jre).getMajorVersion() == artifactVersion.getMajorVersion();
    }
}

