/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.core.runnable;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.core.jobs.IJobControl;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.jobs.JobManager;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStatus;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStatusMap;
import org.eclipse.ptp.internal.rm.jaxb.control.core.JAXBControlCorePlugin;

public class JobStatusMap
extends Thread
implements ICommandJobStatusMap {
    private final IJobControl fControl;
    private final Map<String, ICommandJobStatus> fJobStatusMap = new HashMap<String, ICommandJobStatus>();
    private boolean running = false;
    private static final Map<IJobControl, ICommandJobStatusMap> fMaps = Collections.synchronizedMap(new HashMap());

    public static ICommandJobStatusMap getInstance(IJobControl control) {
        ICommandJobStatusMap map = fMaps.get(control);
        if (map == null) {
            map = new JobStatusMap(control);
            fMaps.put(control, map);
        }
        return map;
    }

    private JobStatusMap(IJobControl control) {
        this.fControl = control;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addJobStatus(String jobId, ICommandJobStatus status) {
        boolean notifyAdd = false;
        boolean exists = false;
        Map<String, ICommandJobStatus> map = this.fJobStatusMap;
        synchronized (map) {
            exists = this.fJobStatusMap.containsKey(jobId);
            notifyAdd = !exists && !"UNDETERMINED".equals(status.getState());
            this.fJobStatusMap.put(jobId, status);
        }
        if (notifyAdd) {
            try {
                status.initialize(jobId);
            }
            catch (CoreException e) {
                JAXBControlCorePlugin.log(e);
            }
            JobManager.getInstance().fireJobAdded((IJobStatus)status);
        }
        return !exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommandJobStatus cancel(String jobId) {
        ICommandJobStatus status = null;
        Map<String, ICommandJobStatus> map = this.fJobStatusMap;
        synchronized (map) {
            status = this.fJobStatusMap.get(jobId);
            if (status != null) {
                status.cancel();
                status.setState("CANCELED");
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<String, ICommandJobStatus> map = this.fJobStatusMap;
        synchronized (map) {
            this.running = false;
            this.fJobStatusMap.notifyAll();
        }
        fMaps.remove(this.fControl);
    }

    private ICommandJobStatus doTerminated(String jobId, boolean block, IProgressMonitor monitor) {
        ICommandJobStatus status = this.fJobStatusMap.get(jobId);
        if (status != null) {
            String d = status.getStateDetail();
            if (!"JOB_OUTERR_READY".equals(d)) {
                boolean bl = block = block && !"CANCELED".equals(d) && !"FAILED".equals(d);
                if (!status.isInteractive()) {
                    if (block) {
                        status.maybeWaitForHandlerFiles(5, monitor);
                    } else {
                        status.maybeWaitForHandlerFiles(0, monitor);
                    }
                }
            }
            status.cancel();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommandJobStatus getStatus(String jobId) {
        ICommandJobStatus status = null;
        Map<String, ICommandJobStatus> map = this.fJobStatusMap;
        synchronized (map) {
            status = this.fJobStatusMap.get(jobId);
        }
        return status;
    }

    @Override
    public void initialize() {
        if (!this.isRunning()) {
            this.start();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.fJobStatusMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunning() {
        boolean b = false;
        Map<String, ICommandJobStatus> map = this.fJobStatusMap;
        synchronized (map) {
            b = this.running;
        }
        return b;
    }

    private ICommandJobStatus remove(String jobId, boolean block, IProgressMonitor monitor) {
        ICommandJobStatus status = this.doTerminated(jobId, block, monitor);
        this.fJobStatusMap.remove(jobId);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        toPrune = new HashMap<String, String>();
        var2_2 = this.fJobStatusMap;
        synchronized (var2_2) {
            this.running = true;
            // MONITOREXIT @DISABLED, blocks:[0, 5] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
            if (true) ** GOTO lbl38
        }
        do {
            var2_2 = this.fJobStatusMap;
            synchronized (var2_2) {
                try {
                    this.fJobStatusMap.wait(0x6DDD00L);
                }
                catch (InterruptedException var3_4) {
                    // empty catch block
                }
                for (String jobId : this.fJobStatusMap.keySet()) {
                    status = null;
                    try {
                        status = this.fControl.getJobStatus(jobId, true, null);
                    }
                    catch (CoreException var6_7) {
                        // empty catch block
                    }
                    if (status != null && !"COMPLETED".equals(status.getState())) continue;
                    toPrune.put(jobId, jobId);
                }
                for (String jobId : toPrune.keySet()) {
                    this.remove(jobId, true, null);
                }
                toPrune.clear();
            }
lbl38:
            // 2 sources

        } while (this.isRunning());
        var2_2 = this.fJobStatusMap;
        synchronized (var2_2) {
            for (String jobId : this.fJobStatusMap.keySet()) {
                this.doTerminated(jobId, false, null);
            }
            this.fJobStatusMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommandJobStatus terminated(String jobId, IProgressMonitor monitor) {
        ICommandJobStatus status = null;
        Map<String, ICommandJobStatus> map = this.fJobStatusMap;
        synchronized (map) {
            status = this.doTerminated(jobId, true, monitor);
        }
        return status;
    }
}

