/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.callsite;

import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.event.CTFCallsite;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;

public final class CallSiteParser
implements ICommonTreeParser {
    public static final CallSiteParser INSTANCE = new CallSiteParser();
    private static final @NonNull String LINE = "line";
    private static final @NonNull String FILE = "file";
    private static final @NonNull String IP = "ip";
    private static final @NonNull String FUNC = "func";
    private static final @NonNull String NAME = "name";

    private CallSiteParser() {
    }

    @Override
    public @NonNull CTFCallsite parse(CommonTree tree, ICommonTreeParser.ICommonTreeParserParameter param) {
        String emptyString = "";
        String regex = "^\"|\"$";
        String fileName = null;
        String funcName = null;
        String name = null;
        long lineNumber = -1L;
        long ip = -1L;
        List children = tree.getChildren();
        for (CommonTree child : children) {
            String left = child.getChild(0).getChild(0).getChild(0).getText();
            if (left.equals(NAME)) {
                name = child.getChild(1).getChild(0).getChild(0).getText().replaceAll("^\"|\"$", "");
                continue;
            }
            if (left.equals(FUNC)) {
                funcName = child.getChild(1).getChild(0).getChild(0).getText().replaceAll("^\"|\"$", "");
                continue;
            }
            if (left.equals(IP)) {
                ip = Long.decode(child.getChild(1).getChild(0).getChild(0).getText());
                continue;
            }
            if (left.equals(FILE)) {
                fileName = child.getChild(1).getChild(0).getChild(0).getText().replaceAll("^\"|\"$", "");
                continue;
            }
            if (!left.equals(LINE)) continue;
            lineNumber = Long.parseLong(child.getChild(1).getChild(0).getChild(0).getText());
        }
        if (name == null || funcName == null || fileName == null) {
            throw new NullPointerException("CTFCallsite parameters shouldn't be null!");
        }
        return new CTFCallsite(name, funcName, ip, fileName, lineNumber);
    }
}

