/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.ui.internal.preferences.BaseConfigurationBlock;
import org.eclipse.jdt.apt.ui.internal.preferences.Messages;
import org.eclipse.jdt.apt.ui.internal.preferences.ProcessorOptionInputDialog;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.osgi.service.prefs.BackingStoreException;

public class AptConfigurationBlock
extends BaseConfigurationBlock {
    private static final BaseConfigurationBlock.Key KEY_APTENABLED = AptConfigurationBlock.getKey("org.eclipse.jdt.apt.core", "org.eclipse.jdt.apt.aptEnabled");
    private static final BaseConfigurationBlock.Key KEY_RECONCILEENABLED = AptConfigurationBlock.getKey("org.eclipse.jdt.apt.core", "org.eclipse.jdt.apt.reconcileEnabled");
    private static final BaseConfigurationBlock.Key KEY_GENSRCDIR = AptConfigurationBlock.getKey("org.eclipse.jdt.apt.core", "org.eclipse.jdt.apt.genSrcDir");
    private static final BaseConfigurationBlock.Key KEY_GENTESTSRCDIR = AptConfigurationBlock.getKey("org.eclipse.jdt.apt.core", "org.eclipse.jdt.apt.genTestSrcDir");
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private final IJavaProject fJProj;
    private SelectionButtonDialogField fAptEnabledField;
    private SelectionButtonDialogField fReconcileEnabledField;
    private StringDialogField fGenSrcDirField;
    private StringDialogField fGenTestSrcDirField;
    private ListDialogField<ProcessorOption> fProcessorOptionsField;
    private PixelConverter fPixelConverter;
    private Composite fBlockControl;
    private Map<String, String> fOriginalProcOptions;
    private String fOriginalGenSrcDir;
    private String fOriginalGenTestSrcDir;
    private boolean fOriginalAptEnabled;
    private boolean fOriginalReconcileEnabled;
    private boolean fPerProjSettingsEnabled;

    private static BaseConfigurationBlock.Key[] getAllKeys() {
        return new BaseConfigurationBlock.Key[]{KEY_APTENABLED, KEY_RECONCILEENABLED, KEY_GENSRCDIR};
    }

    public AptConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, AptConfigurationBlock.getAllKeys(), container);
        this.fJProj = JavaCore.create((IProject)project);
        BaseConfigurationBlock.UpdateAdapter adapter = new BaseConfigurationBlock.UpdateAdapter();
        if (this.fJProj != null) {
            this.fAptEnabledField = new SelectionButtonDialogField(32);
            this.fAptEnabledField.setDialogFieldListener((IDialogFieldListener)adapter);
            this.fAptEnabledField.setLabelText(Messages.AptConfigurationBlock_enable);
        } else {
            this.fAptEnabledField = null;
        }
        this.fReconcileEnabledField = new SelectionButtonDialogField(32);
        this.fReconcileEnabledField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fReconcileEnabledField.setLabelText(Messages.AptConfigurationBlock_enableReconcileProcessing);
        this.fGenSrcDirField = new StringDialogField();
        this.fGenSrcDirField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fGenSrcDirField.setLabelText(Messages.AptConfigurationBlock_generatedSrcDir);
        this.fGenTestSrcDirField = new StringDialogField();
        this.fGenTestSrcDirField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fGenTestSrcDirField.setLabelText(Messages.AptConfigurationBlock_generatedTestSrcDir);
        String[] buttons = new String[]{Messages.AptConfigurationBlock_add, Messages.AptConfigurationBlock_edit, Messages.AptConfigurationBlock_remove};
        ProcessorOptionsAdapter optionsAdapter = new ProcessorOptionsAdapter();
        this.fProcessorOptionsField = new ListDialogField((IListAdapter)optionsAdapter, buttons, (ILabelProvider)new ProcessorOptionsLabelProvider());
        this.fProcessorOptionsField.setDialogFieldListener((IDialogFieldListener)optionsAdapter);
        this.fProcessorOptionsField.setRemoveButtonIndex(2);
        String[] columnHeaders = new String[]{Messages.AptConfigurationBlock_key, Messages.AptConfigurationBlock_value};
        this.fProcessorOptionsField.setTableColumns(new ListDialogField.ColumnsDescription(columnHeaders, true));
        this.fProcessorOptionsField.setViewerComparator((ViewerComparator)new ProcessorOptionSorter());
        this.fProcessorOptionsField.setLabelText(Messages.AptConfigurationBlock_options);
        this.updateControls();
        if (this.fProcessorOptionsField.getSize() > 0) {
            this.fProcessorOptionsField.selectFirstElement();
        } else {
            this.fProcessorOptionsField.enableButton(1, false);
        }
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        if (workspaceSettings) {
            return null;
        }
        if (this.fOriginalGenSrcDir.equals(this.fGenSrcDirField.getText()) && this.fOriginalGenTestSrcDir.equals(this.fGenTestSrcDirField.getText()) && this.fOriginalAptEnabled == this.fAptEnabledField.isSelected() && !this.procOptionsChanged()) {
            return null;
        }
        return super.getFullBuildDialogStrings(workspaceSettings);
    }

    private List<ProcessorOption> getListElements() {
        return this.fProcessorOptionsField.getElements();
    }

    private List<ProcessorOption> getListSelection() {
        return this.fProcessorOptionsField.getSelectedElements();
    }

    private void editOrAddProcessorOption(ProcessorOption original) {
        ProcessorOptionInputDialog dialog = new ProcessorOptionInputDialog(this.getShell(), original, this.getListElements());
        if (dialog.open() == 0) {
            if (original != null) {
                this.fProcessorOptionsField.replaceElement((Object)original, (Object)dialog.getResult());
            } else {
                this.fProcessorOptionsField.addElement((Object)dialog.getResult());
            }
        }
    }

    @Override
    protected Control createContents(Composite parent) {
        DialogField[] dialogFieldArray;
        this.setShell(parent.getShell());
        this.fPixelConverter = new PixelConverter((Control)parent);
        int indent = this.fPixelConverter.convertWidthInCharsToPixels(4);
        this.fBlockControl = new Composite(parent, 0);
        this.fBlockControl.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fBlockControl.setLayout((Layout)layout);
        if (this.fAptEnabledField != null) {
            DialogField[] dialogFieldArray2 = new DialogField[5];
            dialogFieldArray2[0] = this.fAptEnabledField;
            dialogFieldArray2[1] = this.fReconcileEnabledField;
            dialogFieldArray2[2] = this.fGenSrcDirField;
            dialogFieldArray2[3] = this.fGenTestSrcDirField;
            dialogFieldArray = dialogFieldArray2;
            dialogFieldArray2[4] = this.fProcessorOptionsField;
        } else {
            DialogField[] dialogFieldArray3 = new DialogField[4];
            dialogFieldArray3[0] = this.fReconcileEnabledField;
            dialogFieldArray3[1] = this.fGenSrcDirField;
            dialogFieldArray3[2] = this.fGenTestSrcDirField;
            dialogFieldArray = dialogFieldArray3;
            dialogFieldArray3[3] = this.fProcessorOptionsField;
        }
        DialogField[] fields = dialogFieldArray;
        LayoutUtil.doDefaultLayout((Composite)this.fBlockControl, (DialogField[])fields, (boolean)true, (int)-1, (int)-1);
        LayoutUtil.setHorizontalGrabbing((Control)this.fProcessorOptionsField.getListControl(null));
        GridData reconcileGD = (GridData)this.fReconcileEnabledField.getSelectionButton(parent).getLayoutData();
        reconcileGD.horizontalIndent = indent;
        this.fReconcileEnabledField.getSelectionButton(parent).setLayoutData((Object)reconcileGD);
        Dialog.applyDialogFont((Control)this.fBlockControl);
        this.validateSettings(null, null, null);
        return this.fBlockControl;
    }

    @Override
    protected void cacheOriginalValues() {
        super.cacheOriginalValues();
        this.fOriginalProcOptions = AptConfig.getRawProcessorOptions((IJavaProject)this.fJProj);
        this.fOriginalGenSrcDir = AptConfig.getGenSrcDir((IJavaProject)this.fJProj);
        this.fOriginalGenTestSrcDir = AptConfig.getGenTestSrcDir((IJavaProject)this.fJProj);
        this.fOriginalAptEnabled = AptConfig.isEnabled((IJavaProject)this.fJProj);
        this.fOriginalReconcileEnabled = AptConfig.shouldProcessDuringReconcile((IJavaProject)this.fJProj);
        this.fPerProjSettingsEnabled = this.hasProjectSpecificOptionsNoCache(this.fProject);
    }

    @Override
    protected void initContents() {
        this.loadProcessorOptions(this.fJProj);
    }

    @Override
    protected void saveSettings() {
        boolean isProjSpecificDisabled = this.fJProj != null && !this.fBlockControl.isEnabled();
        List<Object> elements = isProjSpecificDisabled ? Collections.emptyList() : this.getListElements();
        this.saveProcessorOptions(elements);
        super.saveSettings();
        if (this.fAptProject != null) {
            if (isProjSpecificDisabled) {
                if (!this.fOriginalGenSrcDir.equals(AptConfig.getGenSrcDir(null))) {
                    this.fAptProject.preferenceChanged("org.eclipse.jdt.apt.genSrcDir");
                }
                if (!this.fOriginalGenTestSrcDir.equals(AptConfig.getGenTestSrcDir(null))) {
                    this.fAptProject.preferenceChanged("org.eclipse.jdt.apt.genTestSrcDir");
                }
                if (this.fOriginalAptEnabled != AptConfig.isEnabled(null)) {
                    this.setJDTProcessAnnotationsSetting(this.fAptEnabledField.isSelected());
                    this.fAptProject.preferenceChanged("org.eclipse.jdt.apt.aptEnabled");
                }
                if (this.fOriginalReconcileEnabled != AptConfig.shouldProcessDuringReconcile(null)) {
                    this.fAptProject.preferenceChanged("org.eclipse.jdt.apt.reconcileEnabled");
                }
            } else {
                boolean isAptEnabled;
                if (!this.fOriginalGenSrcDir.equals(this.fGenSrcDirField.getText())) {
                    this.fAptProject.preferenceChanged("org.eclipse.jdt.apt.genSrcDir");
                }
                if (!this.fOriginalGenTestSrcDir.equals(this.fGenTestSrcDirField.getText())) {
                    this.fAptProject.preferenceChanged("org.eclipse.jdt.apt.genTestSrcDir");
                }
                if (this.fOriginalAptEnabled != (isAptEnabled = this.fAptEnabledField.isSelected())) {
                    this.setJDTProcessAnnotationsSetting(isAptEnabled);
                    this.fAptProject.preferenceChanged("org.eclipse.jdt.apt.aptEnabled");
                }
                if (this.fOriginalReconcileEnabled != this.fReconcileEnabledField.isSelected()) {
                    this.fAptProject.preferenceChanged("org.eclipse.jdt.apt.reconcileEnabled");
                }
            }
        }
    }

    private void setJDTProcessAnnotationsSetting(boolean enable) {
        IScopeContext context = this.fJProj != null ? new ProjectScope(this.fJProj.getProject()) : InstanceScope.INSTANCE;
        IEclipsePreferences node = context.getNode("org.eclipse.jdt.core");
        String value = enable ? "enabled" : "disabled";
        node.put("org.eclipse.jdt.core.compiler.processAnnotations", value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            AptPlugin.log((Throwable)e, (String)"Failed to save preference: org.eclipse.jdt.core.compiler.processAnnotations");
        }
    }

    private boolean procOptionsChanged() {
        HashMap<String, String> savedProcOptions = new HashMap<String, String>(this.fOriginalProcOptions);
        for (ProcessorOption o : this.getListElements()) {
            String savedVal = (String)savedProcOptions.get(o.key);
            if (savedVal != null && savedVal.equals(o.value)) {
                savedProcOptions.remove(o.key);
                continue;
            }
            return true;
        }
        return !savedProcOptions.isEmpty();
    }

    @Override
    protected boolean settingsChanged(IScopeContext currContext) {
        if (this.procOptionsChanged()) {
            return true;
        }
        return super.settingsChanged(currContext);
    }

    @Override
    protected void validateSettings(BaseConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        IStatus status = null;
        status = this.validateGenSrcDir();
        if (status.getSeverity() == 0) {
            status = this.validateGenTestSrcDir();
        }
        if (status.getSeverity() == 0) {
            status = this.validateProcessorOptions();
        }
        this.fContext.statusChanged(status);
    }

    private IStatus validateGenSrcDir() {
        IFolder folder;
        String dirName = this.fGenSrcDirField.getText();
        if (!AptConfig.validateGenSrcDir((IJavaProject)this.fJProj, (String)dirName)) {
            return new StatusInfo(4, Messages.AptConfigurationBlock_genSrcDirMustBeValidRelativePath);
        }
        if (this.fJProj != null && !dirName.equals(this.fOriginalGenSrcDir) && (folder = this.fJProj.getProject().getFolder(dirName)) != null && folder.exists() && !folder.isDerived()) {
            return new StatusInfo(2, Messages.AptConfigurationBlock_warningContentsMayBeDeleted);
        }
        return new StatusInfo();
    }

    private IStatus validateGenTestSrcDir() {
        IFolder folder;
        String dirName = this.fGenSrcDirField.getText();
        String testDirName = this.fGenTestSrcDirField.getText();
        if (!AptConfig.validateGenSrcDir((IJavaProject)this.fJProj, (String)testDirName)) {
            return new StatusInfo(4, Messages.AptConfigurationBlock_genTestSrcDirMustBeValidRelativePath);
        }
        if (testDirName.equals(dirName)) {
            return new StatusInfo(4, Messages.AptConfigurationBlock_genTestSrcDirMustBeDifferent);
        }
        if (this.fJProj != null && !testDirName.equals(this.fOriginalGenTestSrcDir) && (folder = this.fJProj.getProject().getFolder(testDirName)) != null && folder.exists() && !folder.isDerived()) {
            return new StatusInfo(2, Messages.AptConfigurationBlock_warningContentsMayBeDeleted);
        }
        return new StatusInfo();
    }

    private IStatus validateProcessorOptions() {
        List<ProcessorOption> elements = this.getListElements();
        for (ProcessorOption o : elements) {
            if (!AptConfig.isAutomaticProcessorOption((String)o.key)) continue;
            return new StatusInfo(2, String.valueOf(Messages.AptConfigurationBlock_warningIgnoredOptions) + ": " + o.key);
        }
        return new StatusInfo();
    }

    @Override
    protected void updateControls() {
        if (this.fAptEnabledField != null) {
            boolean aptEnabled = Boolean.parseBoolean(this.getValue(KEY_APTENABLED));
            this.fAptEnabledField.setSelection(aptEnabled);
        }
        boolean reconcileEnabled = Boolean.parseBoolean(this.getValue(KEY_RECONCILEENABLED));
        this.fReconcileEnabledField.setSelection(reconcileEnabled);
        String str = this.getValue(KEY_GENSRCDIR);
        this.fGenSrcDirField.setText(str == null ? "" : str);
        String teststr = this.getValue(KEY_GENTESTSRCDIR);
        this.fGenTestSrcDirField.setText(teststr == null ? "" : teststr);
    }

    @Override
    protected final void updateModel(DialogField field) {
        if (this.fAptEnabledField != null && field == this.fAptEnabledField) {
            String newVal = String.valueOf(this.fAptEnabledField.isSelected());
            this.setValue(KEY_APTENABLED, newVal);
        } else if (field == this.fGenSrcDirField) {
            String newVal = this.fGenSrcDirField.getText();
            this.setValue(KEY_GENSRCDIR, newVal);
        } else if (field == this.fGenTestSrcDirField) {
            String newVal = this.fGenTestSrcDirField.getText();
            this.setValue(KEY_GENTESTSRCDIR, newVal);
        } else if (field == this.fReconcileEnabledField) {
            String newVal = String.valueOf(this.fReconcileEnabledField.isSelected());
            this.setValue(KEY_RECONCILEENABLED, newVal);
        }
        this.validateSettings(null, null, null);
    }

    @Override
    public void useProjectSpecificSettings(boolean enable) {
        super.useProjectSpecificSettings(enable);
        if (enable ^ this.fPerProjSettingsEnabled) {
            this.fAptEnabledField.setSelection(enable);
            this.fPerProjSettingsEnabled = enable;
        }
    }

    private void saveProcessorOptions(List<ProcessorOption> elements) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(elements.size());
        for (ProcessorOption o : elements) {
            map.put(o.key, o.value.length() > 0 ? o.value : null);
        }
        AptConfig.setProcessorOptions(map, (IJavaProject)this.fJProj);
    }

    private void loadProcessorOptions(IJavaProject jproj) {
        ArrayList<ProcessorOption> options = new ArrayList<ProcessorOption>();
        Map parsedOptions = AptConfig.getRawProcessorOptions((IJavaProject)jproj);
        for (Map.Entry entry : parsedOptions.entrySet()) {
            ProcessorOption o = new ProcessorOption();
            o.key = (String)entry.getKey();
            if (o.key == null || o.key.length() < 1) continue;
            o.value = entry.getValue() == null ? "" : (String)entry.getValue();
            options.add(o);
        }
        this.fProcessorOptionsField.setElements(options);
    }

    @Override
    public void performDefaults() {
        this.fPerProjSettingsEnabled = false;
        if (this.fJProj != null) {
            this.loadProcessorOptions(null);
        } else {
            this.fProcessorOptionsField.removeAllElements();
        }
        super.performDefaults();
    }

    public static class ProcessorOption {
        public String key;
        public String value;
    }

    private static class ProcessorOptionSorter
    extends ViewerComparator {
        private ProcessorOptionSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.getComparator().compare(((ProcessorOption)e1).key, ((ProcessorOption)e2).key);
        }
    }

    private class ProcessorOptionsAdapter
    implements IListAdapter<ProcessorOption>,
    IDialogFieldListener {
        private ProcessorOptionsAdapter() {
        }

        public void customButtonPressed(ListDialogField<ProcessorOption> field, int index) {
            switch (index) {
                case 0: {
                    AptConfigurationBlock.this.editOrAddProcessorOption(null);
                    break;
                }
                case 1: {
                    this.tryToEdit(field);
                }
            }
        }

        public void selectionChanged(ListDialogField<ProcessorOption> field) {
            List selectedElements = field.getSelectedElements();
            field.enableButton(1, this.canEdit((DialogField)field, selectedElements));
        }

        public void doubleClicked(ListDialogField<ProcessorOption> field) {
            this.tryToEdit(field);
        }

        public void dialogFieldChanged(DialogField field) {
            AptConfigurationBlock.this.updateModel(field);
        }

        private boolean canEdit(DialogField field, List<ProcessorOption> selectedElements) {
            if (!field.isEnabled()) {
                return false;
            }
            return selectedElements.size() == 1;
        }

        private void tryToEdit(ListDialogField<ProcessorOption> field) {
            List<ProcessorOption> selection = AptConfigurationBlock.this.getListSelection();
            if (this.canEdit((DialogField)field, selection)) {
                AptConfigurationBlock.this.editOrAddProcessorOption(selection.get(0));
            }
        }
    }

    private static class ProcessorOptionsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ProcessorOptionsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ProcessorOption o = (ProcessorOption)element;
            if (columnIndex == 0) {
                return o.key;
            }
            if (columnIndex == 1) {
                return o.value;
            }
            return "";
        }
    }
}

