/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.EntityGroup;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelMergeAssistant;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataTranslator;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModel;
import org.eclipse.jst.jsf.common.metadata.internal.StandardMetaDataFileRegistry;
import org.eclipse.jst.jsf.common.metadata.internal.StandardModelFactory;

public class StandardMetaDataFilesTranslator
implements IMetaDataTranslator {
    @Override
    public boolean canTranslate(IMetaDataSourceModelProvider modelProvider) {
        return modelProvider instanceof StandardMetaDataFileRegistry.StandardMetaDataFilesProvider;
    }

    @Override
    public void translate(IMetaDataModelMergeAssistant assistant) {
        MetaDataModel mm = assistant.getMergedModel();
        Model mk = (Model)assistant.getSourceModelProvider().getSourceModel();
        if (mm.getRoot() == null) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            Model newModel = (Model)copier.copy((EObject)mk.getModel());
            copier.copyReferences();
            mm.setRoot(newModel);
        } else if (mk != null) {
            this.traverseAndAdd(assistant, mk);
        } else if (StandardModelFactory.DEBUG_MD_LOAD) {
            JSFCommonPlugin.log(4, "Unable to load source model: " + assistant.getSourceModelProvider());
        }
    }

    protected void traverseAndAdd(IMetaDataModelMergeAssistant assistant, Entity entity) {
        Entity mmEntity = assistant.addEntity(entity);
        if (entity instanceof Model) {
            Model model = (Model)entity;
            Iterator it = model.getEntityGroups().iterator();
            while (it.hasNext()) {
                assistant.addEntityGroup((EntityGroup)it.next());
            }
        }
        for (Trait trait : entity.getTraits()) {
            assistant.addTrait(mmEntity, trait);
        }
        for (Entity e : entity.getChildEntities()) {
            this.traverseAndAdd(assistant, e);
        }
    }
}

