/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.createrepo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.linuxtools.internal.rpm.createrepo.Createrepo;
import org.eclipse.linuxtools.internal.rpm.createrepo.CreaterepoCommandCreator;
import org.eclipse.linuxtools.internal.rpm.createrepo.Messages;

public class CreaterepoProject {
    private IEclipsePreferences projectPreferences;
    private IProject project;
    private IFolder content;
    private IFile repoFile;
    private IProgressMonitor monitor;

    public CreaterepoProject(IProject project) throws CoreException {
        this(project, null);
    }

    public CreaterepoProject(IProject project, IFile repoFile) throws CoreException {
        this.project = project;
        this.repoFile = repoFile;
        this.monitor = new NullProgressMonitor();
        this.projectPreferences = new ProjectScope(project.getProject()).getNode("org.eclipse.linuxtools.rpm.createrepo");
        this.intitialize();
        this.getProject().refreshLocal(1, this.monitor);
    }

    private void intitialize() throws CoreException {
        this.content = this.getProject().getFolder("content");
        if (this.repoFile == null) {
            IResource[] iResourceArray = this.getProject().members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                String extension = child.getFileExtension();
                if (extension != null && extension.equals("repo")) {
                    this.repoFile = (IFile)child;
                }
                ++n2;
            }
        }
    }

    private void createContentFolder() throws CoreException {
        this.content = this.getProject().getFolder("content");
        if (!this.content.exists()) {
            this.content.create(true, true, this.monitor);
        }
    }

    public void importRPM(File externalFile) throws CoreException {
        IFile file;
        if (!externalFile.exists()) {
            return;
        }
        if (!this.getContentFolder().exists()) {
            this.createContentFolder();
        }
        if (!(file = this.getContentFolder().getFile((IPath)new Path(externalFile.getName()))).getFileExtension().equals("rpm")) {
            return;
        }
        if (!file.exists()) {
            try {
                file.create((InputStream)new FileInputStream(externalFile), false, this.monitor);
            }
            catch (FileNotFoundException e) {
                IStatus status = Status.error((String)Messages.CreaterepoProject_errorGettingFile, (Throwable)e);
                throw new CoreException(status);
            }
            this.getProject().refreshLocal(2, this.monitor);
        }
    }

    public IStatus createrepo(OutputStream os) throws CoreException {
        if (!this.getContentFolder().exists()) {
            this.createContentFolder();
        }
        Createrepo createrepo = new Createrepo();
        IStatus result = createrepo.execute(os, this, this.getCommandArguments());
        this.getProject().refreshLocal(2, this.monitor);
        return result;
    }

    public IStatus update(OutputStream os) throws CoreException {
        if (!this.getContentFolder().exists()) {
            this.createContentFolder();
        }
        Createrepo createrepo = new Createrepo();
        List<String> commands = this.getCommandArguments();
        commands.add("--".concat("update"));
        IStatus result = createrepo.execute(os, this, commands);
        this.getProject().refreshLocal(2, this.monitor);
        return result;
    }

    public IProject getProject() {
        return this.project;
    }

    public IFolder getContentFolder() {
        return this.content;
    }

    public IFile getRepoFile() {
        return this.repoFile;
    }

    public List<IResource> getRPMs() throws CoreException {
        ArrayList<IResource> rpms = new ArrayList<IResource>();
        if (!this.getContentFolder().exists()) {
            return rpms;
        }
        if (this.getProject().members().length > 0) {
            IResource[] iResourceArray = this.getContentFolder().members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                String extension = child.getFileExtension();
                if (extension != null && extension.equals("rpm")) {
                    rpms.add(child);
                }
                ++n2;
            }
        }
        return rpms;
    }

    public IEclipsePreferences getEclipsePreferences() {
        return this.projectPreferences;
    }

    private List<String> getCommandArguments() {
        ArrayList<String> commands = new ArrayList<String>();
        CreaterepoCommandCreator creator = new CreaterepoCommandCreator(this.projectPreferences);
        commands.addAll(creator.getCommands());
        return commands;
    }
}

