/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.pages;

import com.google.inject.Injector;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ocl.examples.xtext.console.xtfo.EmbeddedXtextEditor;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.internal.context.EObjectContext;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.Value;
import org.eclipse.ocl.xtext.base.ui.model.BaseDocument;
import org.eclipse.ocl.xtext.essentialocl.ui.internal.EssentialOCLActivator;
import org.eclipse.ocl.xtext.essentialocl.utilities.EssentialOCLCSResource;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.uml.search.ui.Activator;
import org.eclipse.papyrus.uml.search.ui.CheckBoxFilteredTree;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.uml.search.ui.actions.ReplaceAction;
import org.eclipse.papyrus.uml.search.ui.listeners.ParticipantTypesTreeViewerCheckStateListener;
import org.eclipse.papyrus.uml.search.ui.pages.PapyrusSearchResultPage;
import org.eclipse.papyrus.uml.search.ui.providers.OCLContextContentProvider;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeAttribute;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeContentProvider;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeElement;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeLabelProvider;
import org.eclipse.papyrus.uml.search.ui.query.AbstractPapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.query.CompositePapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.query.CompositePapyrusQueryProvider;
import org.eclipse.papyrus.uml.search.ui.query.PapyrusOCLQuery;
import org.eclipse.papyrus.uml.search.ui.query.QueryInfo;
import org.eclipse.papyrus.uml.search.ui.query.WorkspaceQueryProvider;
import org.eclipse.papyrus.uml.stereotypecollector.StereotypeCollector;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.views.search.regex.PatternHelper;
import org.eclipse.papyrus.views.search.scope.IScopeEntry;
import org.eclipse.papyrus.views.search.scope.ScopeCollector;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.search.ui.IReplacePage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.outline.impl.EStructuralFeatureNode;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class PapyrusSearchPage
extends DialogPage
implements ISearchPage,
IReplacePage {
    private int currentScope = -1;
    private HashMap<ParticipantTypeElement, List<ParticipantTypeAttribute>> umlTypeParticipantsList = new HashMap();
    private HashMap<ParticipantTypeElement, List<ParticipantTypeAttribute>> stereotypeParticipantsList = new HashMap();
    private LinkedList<Object> profiles = new LinkedList();
    private String allProfiles = "*";
    private Collection<Stereotype> availableStereotypes;
    private Collection<Stereotype> appliedStereotypes;
    private boolean profilesComputed = false;
    private boolean availableStereotypesComputed = false;
    private boolean appliedStereotypesComputed = false;
    private static final String REGULAR_EXPRESSION_ILLFORMED = Messages.PapyrusSearchPage_0;
    private static final String OCL_QUERY_ILLFORMED = Messages.PapyrusSearchPage_0;
    private static final String SEARCH_ISSUE = Messages.PapyrusSearchPage_1;
    private Text searchQueryText;
    private Text oclContext;
    private ISearchPageContainer container;
    private CheckBoxFilteredTree participantUMLTypesTree;
    private CheckBoxFilteredTree participantStereotypesTree;
    private CheckboxTreeViewer participantUMLTypesTreeViewer;
    private CheckboxTreeViewer participantStereotypesTreeViewer;
    private ComboViewer participantProfilesComboViewer;
    private Label searchQueryExplanatoryLabel;
    private Button btnRegularExpression;
    private Button btnCaseSensitive;
    private Button btnSearchAllStringAttributes;
    private Button btnSearchInName;
    private Combo queryKind;
    private Combo searchKind;
    private EmbeddedXtextEditor oclEditor;
    private Composite queryComposite;
    private EObject contextObject;
    private static final int TEXT_QUERY_KIND = 0;
    private static final int OCL_QUERY_KIND = 1;
    private static final int SIMPLE_SEARCH = 0;
    private static final int ADVANCED_SEARCH = 1;
    private int currentSearchKind = 0;
    private int currentQueryKind = 0;
    private boolean onlyAppliedStereotypes = false;
    private boolean onlyAppliedStereotypesStateChanged = true;
    private Profile selectedProfile = null;
    private ParserContext parserContext;
    protected Composite textQueryComposite;
    private Composite advancedSearchComposite;
    private Composite textQueryFieldsComposite;
    private Button fBtnOnlyAppliedStereotypes;
    private Button fBtnSearchForAllSelected;
    private Button fBtnSearchForAnySelected;
    private Label umlTypesLabel;
    private Label stereotypesLabel;
    private Label profilesLabel;
    private Label emptyLabel;

    protected void createTextSearch() {
        this.textQueryComposite = new Composite(this.queryComposite, 0);
        this.textQueryComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.textQueryComposite.setLayout((Layout)new GridLayout(2, false));
        this.textQueryFieldsComposite = new Composite(this.textQueryComposite, 0);
        this.textQueryFieldsComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.textQueryFieldsComposite.setLayout((Layout)new GridLayout(1, false));
        this.searchQueryExplanatoryLabel = new Label(this.textQueryFieldsComposite, 0);
        this.searchQueryExplanatoryLabel.setText(Messages.PapyrusSearchPage_48);
        this.searchQueryExplanatoryLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.searchQueryText = new Text(this.textQueryFieldsComposite, 2048);
        this.searchQueryText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.searchQueryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PapyrusSearchPage.this.validateRegex();
            }
        });
        this.searchQueryText.setFocus();
        Composite compositeParameters = new Composite(this.textQueryComposite, 0);
        compositeParameters.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        compositeParameters.setLayout((Layout)new GridLayout(1, false));
        this.btnCaseSensitive = new Button(compositeParameters, 32);
        this.btnCaseSensitive.setText(Messages.PapyrusSearchPage_5);
        this.btnRegularExpression = new Button(compositeParameters, 32);
        this.btnRegularExpression.setText(Messages.PapyrusSearchPage_6);
        this.btnRegularExpression.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PapyrusSearchPage.this.btnCaseSensitive.setEnabled(!PapyrusSearchPage.this.btnRegularExpression.getSelection());
                PapyrusSearchPage.this.validateRegex();
                PapyrusSearchPage.this.searchQueryText.forceFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Group grpSearchFor = new Group(this.textQueryComposite, 0);
        grpSearchFor.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        grpSearchFor.setLayout((Layout)new GridLayout(1, false));
        grpSearchFor.setText(Messages.PapyrusSearchPage_8);
        Composite groupComposite = new Composite((Composite)grpSearchFor, 0);
        groupComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        groupComposite.setLayout((Layout)new GridLayout(2, false));
        Label lblSearchKind = new Label(groupComposite, 0);
        lblSearchKind.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        lblSearchKind.setText(Messages.PapyrusSearchPage_7);
        this.searchKind = new Combo(groupComposite, 2572);
        this.searchKind.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        this.searchKind.add(Messages.PapyrusSearchPage_11);
        this.searchKind.add(Messages.PapyrusSearchPage_12);
        this.searchKind.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PapyrusSearchPage.this.searchKind.getSelectionIndex() != PapyrusSearchPage.this.currentSearchKind) {
                    Control[] controlArray = PapyrusSearchPage.this.advancedSearchComposite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control childControl = controlArray[n2];
                        childControl.dispose();
                        ++n2;
                    }
                    PapyrusSearchPage.this.createSpecificTextSearch();
                    PapyrusSearchPage.this.advancedSearchComposite.layout();
                }
            }
        });
        this.advancedSearchComposite = new Composite(groupComposite, 0);
        this.advancedSearchComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.advancedSearchComposite.setLayout((Layout)new GridLayout(3, false));
        if (this.currentSearchKind == 1) {
            this.searchKind.select(1);
        } else {
            this.searchKind.select(0);
        }
        this.createSpecificTextSearch();
    }

    protected void createSpecificTextSearch() {
        if (this.searchKind.getSelectionIndex() == 1) {
            if (this.container.getSelectedScope() == this.currentScope || this.currentScope == -1) {
                if (this.umlTypeParticipantsList.isEmpty()) {
                    this.createUMLTypesList();
                }
                this.createProfilesList(false);
                this.createStereotypesList(false);
                this.createAdvancedSearch();
                this.participantProfilesComboViewer.refresh();
                this.participantUMLTypesTreeViewer.refresh();
                this.filterParticipantStereotypesByProfile();
                this.currentScope = this.container.getSelectedScope();
            } else {
                if (this.umlTypeParticipantsList.isEmpty()) {
                    this.createUMLTypesList();
                }
                this.selectedProfile = null;
                this.profilesComputed = false;
                this.createProfilesList(true);
                this.availableStereotypesComputed = false;
                this.appliedStereotypesComputed = false;
                this.createStereotypesList(true);
                this.createAdvancedSearch();
                this.participantProfilesComboViewer.refresh();
                this.participantUMLTypesTreeViewer.refresh();
                this.filterParticipantStereotypesByProfile();
                this.currentScope = this.container.getSelectedScope();
            }
        } else {
            this.createSimpleSearch();
        }
    }

    protected void createUMLTypesList() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress computeAvailableTypes = new IRunnableWithProgress(){

            public void run(IProgressMonitor thePM) throws InterruptedException {
                for (EClassifier eClassifier : UMLPackage.eINSTANCE.getEClassifiers()) {
                    ParticipantTypeElement parentElement;
                    if (!(eClassifier instanceof EClass) || !((parentElement = new ParticipantTypeElement((EObject)eClassifier)).getElement() instanceof EClass)) continue;
                    ArrayList<ParticipantTypeAttribute> attributeList = new ArrayList<ParticipantTypeAttribute>();
                    for (EObject eAttribute : ((EClass)parentElement.getElement()).getEAllAttributes()) {
                        ParticipantTypeAttribute attribute = new ParticipantTypeAttribute(eAttribute, parentElement);
                        attributeList.add(attribute);
                    }
                    PapyrusSearchPage.this.umlTypeParticipantsList.put(parentElement, attributeList);
                }
            }
        };
        try {
            dialog.run(true, true, computeAvailableTypes);
        }
        catch (InvocationTargetException e1) {
            Activator.log.error((Throwable)e1);
        }
        catch (InterruptedException e1) {
            Activator.log.error((Throwable)e1);
        }
    }

    protected void createProfilesList(boolean forceRefresh) {
        if (forceRefresh || !this.profilesComputed) {
            this.profiles.clear();
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            IRunnableWithProgress computeAvailableTypes = new IRunnableWithProgress(){

                public void run(IProgressMonitor thePM) throws InterruptedException {
                    Collection<Profile> appliedProfiles = StereotypeCollector.getInstance().computeAppliedProfiles(PapyrusSearchPage.this.container);
                    PapyrusSearchPage.this.profiles.add(PapyrusSearchPage.this.allProfiles);
                    PapyrusSearchPage.this.profiles.addAll(appliedProfiles);
                    PapyrusSearchPage.this.profilesComputed = true;
                }
            };
            try {
                dialog.run(true, true, computeAvailableTypes);
            }
            catch (InvocationTargetException e1) {
                Activator.log.error((Throwable)e1);
            }
            catch (InterruptedException e1) {
                Activator.log.error((Throwable)e1);
            }
        }
    }

    protected void createStereotypesList(final boolean forceRefresh) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress computeAvailableTypes = new IRunnableWithProgress(){

            public void run(IProgressMonitor thePM) throws InterruptedException {
                if (forceRefresh || PapyrusSearchPage.this.onlyAppliedStereotypesStateChanged) {
                    Collection<Stereotype> computedStereotypes;
                    PapyrusSearchPage.this.stereotypeParticipantsList.clear();
                    if (PapyrusSearchPage.this.onlyAppliedStereotypes) {
                        if (forceRefresh || !PapyrusSearchPage.this.appliedStereotypesComputed) {
                            if (PapyrusSearchPage.this.appliedStereotypes != null) {
                                PapyrusSearchPage.this.appliedStereotypes.clear();
                            }
                            PapyrusSearchPage.this.appliedStereotypes = StereotypeCollector.getInstance().computeAppliedStereotypes(PapyrusSearchPage.this.container);
                            PapyrusSearchPage.this.appliedStereotypesComputed = true;
                        }
                        computedStereotypes = PapyrusSearchPage.this.appliedStereotypes;
                    } else {
                        if (forceRefresh || !PapyrusSearchPage.this.availableStereotypesComputed) {
                            if (PapyrusSearchPage.this.availableStereotypes != null) {
                                PapyrusSearchPage.this.availableStereotypes.clear();
                            }
                            PapyrusSearchPage.this.availableStereotypes = StereotypeCollector.getInstance().computeAvailableStereotypes(PapyrusSearchPage.this.container);
                            PapyrusSearchPage.this.availableStereotypesComputed = true;
                        }
                        computedStereotypes = PapyrusSearchPage.this.availableStereotypes;
                    }
                    for (Stereotype stereotype : computedStereotypes) {
                        ParticipantTypeElement parentElement = new ParticipantTypeElement((EObject)stereotype);
                        ArrayList<ParticipantTypeAttribute> attributeList = new ArrayList<ParticipantTypeAttribute>();
                        for (Property property : ((Stereotype)parentElement.getElement()).getAllAttributes()) {
                            if (property.getName().startsWith("base_") || !(property.getType() instanceof Element)) continue;
                            ParticipantTypeAttribute attribute = new ParticipantTypeAttribute((EObject)property, parentElement);
                            attributeList.add(attribute);
                        }
                        PapyrusSearchPage.this.stereotypeParticipantsList.put(parentElement, attributeList);
                    }
                    PapyrusSearchPage.this.onlyAppliedStereotypesStateChanged = false;
                }
            }
        };
        try {
            dialog.run(true, true, computeAvailableTypes);
        }
        catch (InvocationTargetException e1) {
            Activator.log.error((Throwable)e1);
        }
        catch (InterruptedException e1) {
            Activator.log.error((Throwable)e1);
        }
    }

    protected void filterParticipantStereotypesByProfile() {
        if (this.selectedProfile == null) {
            this.participantStereotypesTreeViewer.setInput(this.stereotypeParticipantsList);
            this.participantStereotypesTreeViewer.refresh();
            return;
        }
        HashMap<ParticipantTypeElement, List<ParticipantTypeAttribute>> filteredStereotypeParticipantsList = new HashMap<ParticipantTypeElement, List<ParticipantTypeAttribute>>();
        for (Map.Entry<ParticipantTypeElement, List<ParticipantTypeAttribute>> pair : this.stereotypeParticipantsList.entrySet()) {
            Stereotype stereotype = (Stereotype)pair.getKey().getElement();
            if (!EcoreUtil.getURI((EObject)stereotype.getProfile()).equals(EcoreUtil.getURI((EObject)this.selectedProfile))) continue;
            filteredStereotypeParticipantsList.put(pair.getKey(), pair.getValue());
        }
        this.participantStereotypesTreeViewer.setInput(filteredStereotypeParticipantsList);
        this.participantStereotypesTreeViewer.refresh();
    }

    protected void createAdvancedSearch() {
        this.profilesLabel = new Label(this.advancedSearchComposite, 0);
        this.profilesLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.profilesLabel.setText(Messages.PapyrusSearchPage_51);
        this.emptyLabel = new Label(this.advancedSearchComposite, 0);
        this.emptyLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.emptyLabel.setText("");
        this.emptyLabel = new Label(this.advancedSearchComposite, 0);
        this.emptyLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.emptyLabel.setText("");
        this.participantProfilesComboViewer = new ComboViewer(this.advancedSearchComposite, 8);
        this.participantProfilesComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.participantProfilesComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Profile) {
                    return ((Profile)element).getName();
                }
                return super.getText(element);
            }
        });
        this.participantProfilesComboViewer.setSorter(new ViewerSorter());
        this.participantProfilesComboViewer.setInput(this.profiles);
        if (this.selectedProfile == null) {
            this.participantProfilesComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.allProfiles));
        } else {
            this.participantProfilesComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedProfile));
        }
        this.participantProfilesComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                PapyrusSearchPage.this.selectedProfile = PapyrusSearchPage.this.participantProfilesComboViewer.getStructuredSelection().getFirstElement() instanceof Profile ? (Profile)PapyrusSearchPage.this.participantProfilesComboViewer.getStructuredSelection().getFirstElement() : null;
                PapyrusSearchPage.this.filterParticipantStereotypesByProfile();
            }
        });
        this.fBtnOnlyAppliedStereotypes = new Button(this.advancedSearchComposite, 32);
        this.fBtnOnlyAppliedStereotypes.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fBtnOnlyAppliedStereotypes.setText(Messages.PapyrusSearchPage_50);
        this.fBtnOnlyAppliedStereotypes.setSelection(this.onlyAppliedStereotypes);
        this.fBtnOnlyAppliedStereotypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PapyrusSearchPage.this.onlyAppliedStereotypes = PapyrusSearchPage.this.fBtnOnlyAppliedStereotypes.getSelection();
                HashMap<ParticipantTypeElement, List<ParticipantTypeAttribute>> oldStereotypeParticipantsList = new HashMap<ParticipantTypeElement, List<ParticipantTypeAttribute>>();
                for (Map.Entry<ParticipantTypeElement, List<ParticipantTypeAttribute>> pair : PapyrusSearchPage.this.stereotypeParticipantsList.entrySet()) {
                    boolean toAdd = false;
                    if (pair.getKey().isChecked()) {
                        toAdd = true;
                    }
                    if (!toAdd) {
                        for (ParticipantTypeAttribute attribute : pair.getValue()) {
                            if (!attribute.isChecked()) continue;
                            toAdd = true;
                            break;
                        }
                    }
                    if (!toAdd) continue;
                    oldStereotypeParticipantsList.put(pair.getKey(), pair.getValue());
                }
                PapyrusSearchPage.this.onlyAppliedStereotypesStateChanged = true;
                PapyrusSearchPage.this.createStereotypesList(false);
                for (Map.Entry oldPair : oldStereotypeParticipantsList.entrySet()) {
                    Stereotype oldStereotype = (Stereotype)((ParticipantTypeElement)oldPair.getKey()).getElement();
                    for (Map.Entry<ParticipantTypeElement, List<ParticipantTypeAttribute>> newPair : PapyrusSearchPage.this.stereotypeParticipantsList.entrySet()) {
                        Stereotype newStereotype = (Stereotype)newPair.getKey().getElement();
                        if (!EcoreUtil.getURI((EObject)newStereotype).equals(EcoreUtil.getURI((EObject)oldStereotype)) || newPair.getValue().size() != ((List)oldPair.getValue()).size()) continue;
                        newPair.getKey().setChecked(((ParticipantTypeElement)oldPair.getKey()).isChecked());
                        int i = 0;
                        while (i < ((List)oldPair.getValue()).size()) {
                            newPair.getValue().get(i).setChecked(((ParticipantTypeAttribute)((List)oldPair.getValue()).get(i)).isChecked());
                            ++i;
                        }
                    }
                }
                PapyrusSearchPage.this.filterParticipantStereotypesByProfile();
            }
        });
        this.emptyLabel = new Label(this.advancedSearchComposite, 0);
        this.emptyLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.emptyLabel.setText("");
        this.umlTypesLabel = new Label(this.advancedSearchComposite, 0);
        this.umlTypesLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.umlTypesLabel.setText(Messages.PapyrusSearchPage_44);
        this.stereotypesLabel = new Label(this.advancedSearchComposite, 0);
        this.stereotypesLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.stereotypesLabel.setText(Messages.PapyrusSearchPage_45);
        this.emptyLabel = new Label(this.advancedSearchComposite, 0);
        this.emptyLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.emptyLabel.setText("");
        this.participantUMLTypesTree = new CheckBoxFilteredTree(this.advancedSearchComposite, 2820, new PatternFilter(), true);
        this.participantUMLTypesTree.setLayout((Layout)new GridLayout());
        GridData typesChechboxTreeViewerGridData = new GridData(4, 4, true, true, 1, 1);
        typesChechboxTreeViewerGridData.heightHint = 150;
        this.participantUMLTypesTree.setLayoutData(typesChechboxTreeViewerGridData);
        this.participantStereotypesTree = new CheckBoxFilteredTree(this.advancedSearchComposite, 2820, new PatternFilter(), true);
        this.participantStereotypesTree.setLayout((Layout)new GridLayout());
        GridData stereotypesChechboxTreeViewerGridData = new GridData(4, 4, true, true, 1, 1);
        stereotypesChechboxTreeViewerGridData.heightHint = 150;
        this.participantStereotypesTree.setLayoutData(stereotypesChechboxTreeViewerGridData);
        this.participantUMLTypesTreeViewer = (CheckboxTreeViewer)this.participantUMLTypesTree.getViewer();
        this.participantUMLTypesTreeViewer.setContentProvider((IContentProvider)new ParticipantTypeContentProvider());
        this.participantUMLTypesTreeViewer.setLabelProvider((IBaseLabelProvider)new ParticipantTypeLabelProvider());
        this.participantUMLTypesTreeViewer.setSorter(new ViewerSorter());
        this.participantUMLTypesTreeViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof ParticipantTypeElement) {
                    return ((ParticipantTypeElement)element).isChecked();
                }
                return false;
            }
        });
        this.participantStereotypesTreeViewer = (CheckboxTreeViewer)this.participantStereotypesTree.getViewer();
        this.participantStereotypesTreeViewer.setContentProvider((IContentProvider)new ParticipantTypeContentProvider());
        this.participantStereotypesTreeViewer.setLabelProvider((IBaseLabelProvider)new ParticipantTypeLabelProvider());
        this.participantStereotypesTreeViewer.setSorter(new ViewerSorter());
        this.participantStereotypesTreeViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof ParticipantTypeElement) {
                    return ((ParticipantTypeElement)element).isChecked();
                }
                return false;
            }
        });
        Composite participantManipualtionComposite = new Composite(this.advancedSearchComposite, 0);
        participantManipualtionComposite.setLayout((Layout)new GridLayout(1, false));
        participantManipualtionComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, true, 1, 1));
        Button btnSelectSub = new Button(participantManipualtionComposite, 8);
        btnSelectSub.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnSelectSub.setText(Messages.PapyrusSearchPage_14);
        btnSelectSub.setToolTipText(Messages.PapyrusSearchPageTooltip_1);
        btnSelectSub.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Object selectedElement;
                ISelection selection = PapyrusSearchPage.this.participantUMLTypesTreeViewer.getSelection();
                if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof ParticipantTypeElement) {
                    ArrayList<ParticipantTypeAttribute> attributeParentList = new ArrayList<ParticipantTypeAttribute>();
                    for (ParticipantTypeAttribute attribute : PapyrusSearchPage.this.umlTypeParticipantsList.get(selectedElement)) {
                        if (!(attribute instanceof ParticipantTypeAttribute) || !attribute.isChecked()) continue;
                        attributeParentList.add(attribute);
                    }
                    if (((ParticipantTypeElement)selectedElement).getElement() instanceof EClass) {
                        PapyrusSearchPage.this.selectAllSubUML((ParticipantTypeElement)selectedElement, attributeParentList);
                    } else if (((ParticipantTypeElement)selectedElement).getElement() instanceof Stereotype) {
                        PapyrusSearchPage.this.selectAllSubSter((ParticipantTypeElement)selectedElement, attributeParentList);
                    }
                }
                PapyrusSearchPage.this.participantUMLTypesTreeViewer.refresh();
            }
        });
        Button btnSelectAll = new Button(participantManipualtionComposite, 8);
        btnSelectAll.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnSelectAll.setText(Messages.PapyrusSearchPage_9);
        btnSelectAll.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                for (ParticipantTypeElement element : PapyrusSearchPage.this.umlTypeParticipantsList.keySet()) {
                    if (element.isChecked()) continue;
                    element.setChecked(true);
                    for (ParticipantTypeAttribute attribute : PapyrusSearchPage.this.umlTypeParticipantsList.get(element)) {
                        attribute.setChecked(true);
                    }
                }
                PapyrusSearchPage.this.participantUMLTypesTreeViewer.refresh();
            }
        });
        Button btnDeselectAll = new Button(participantManipualtionComposite, 8);
        btnDeselectAll.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnDeselectAll.setText(Messages.PapyrusSearchPage_10);
        btnDeselectAll.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                for (ParticipantTypeElement element : PapyrusSearchPage.this.umlTypeParticipantsList.keySet()) {
                    if (!element.isChecked()) continue;
                    element.setChecked(false);
                    for (ParticipantTypeAttribute attribute : PapyrusSearchPage.this.umlTypeParticipantsList.get(element)) {
                        attribute.setChecked(false);
                    }
                }
                PapyrusSearchPage.this.participantUMLTypesTreeViewer.refresh();
            }
        });
        Button btnSelectAllSt = new Button(participantManipualtionComposite, 8);
        btnSelectAllSt.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnSelectAllSt.setText(Messages.PapyrusSearchPage_46);
        btnSelectAllSt.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                for (ParticipantTypeElement element : PapyrusSearchPage.this.stereotypeParticipantsList.keySet()) {
                    if (element.isChecked()) continue;
                    element.setChecked(true);
                    for (ParticipantTypeAttribute attribute : PapyrusSearchPage.this.stereotypeParticipantsList.get(element)) {
                        attribute.setChecked(true);
                    }
                }
                PapyrusSearchPage.this.participantStereotypesTreeViewer.refresh();
            }
        });
        Button btnDeselectAllSt = new Button(participantManipualtionComposite, 8);
        btnDeselectAllSt.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnDeselectAllSt.setText(Messages.PapyrusSearchPage_47);
        btnDeselectAllSt.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                for (ParticipantTypeElement element : PapyrusSearchPage.this.stereotypeParticipantsList.keySet()) {
                    if (!element.isChecked()) continue;
                    element.setChecked(false);
                    for (ParticipantTypeAttribute attribute : PapyrusSearchPage.this.stereotypeParticipantsList.get(element)) {
                        attribute.setChecked(false);
                    }
                }
                PapyrusSearchPage.this.participantStereotypesTreeViewer.refresh();
            }
        });
        Button btnRefreshTypes = new Button(participantManipualtionComposite, 8);
        btnRefreshTypes.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnRefreshTypes.setText(Messages.PapyrusSearchPage_15);
        btnRefreshTypes.setToolTipText(Messages.PapyrusSearchPageTooltip_2);
        btnRefreshTypes.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PapyrusSearchPage.this.refreshByScope();
            }
        });
        this.participantUMLTypesTreeViewer.setInput(this.umlTypeParticipantsList);
        this.participantUMLTypesTreeViewer.addCheckStateListener((ICheckStateListener)new ParticipantTypesTreeViewerCheckStateListener(this.participantUMLTypesTreeViewer, this.umlTypeParticipantsList));
        this.participantStereotypesTreeViewer.setInput(this.stereotypeParticipantsList);
        this.participantStereotypesTreeViewer.addCheckStateListener((ICheckStateListener)new ParticipantTypesTreeViewerCheckStateListener(this.participantStereotypesTreeViewer, this.stereotypeParticipantsList));
        this.emptyLabel = new Label(this.advancedSearchComposite, 0);
        this.emptyLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.emptyLabel.setText("");
        this.fBtnSearchForAllSelected = new Button(this.advancedSearchComposite, 32);
        this.fBtnSearchForAllSelected.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fBtnSearchForAllSelected.setText(Messages.PapyrusSearchPage_13);
        this.emptyLabel = new Label(this.advancedSearchComposite, 0);
        this.emptyLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.emptyLabel.setText("");
        this.emptyLabel = new Label(this.advancedSearchComposite, 0);
        this.emptyLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.emptyLabel.setText("");
        this.fBtnSearchForAnySelected = new Button(this.advancedSearchComposite, 32);
        this.fBtnSearchForAnySelected.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fBtnSearchForAnySelected.setText(Messages.PapyrusSearchPage_49);
        this.currentSearchKind = 1;
        this.currentQueryKind = 0;
    }

    protected void refreshByScope() {
        if (this.umlTypeParticipantsList.isEmpty()) {
            this.createUMLTypesList();
        }
        this.selectedProfile = null;
        this.profilesComputed = false;
        this.createProfilesList(true);
        this.availableStereotypesComputed = false;
        this.appliedStereotypesComputed = false;
        this.createStereotypesList(true);
        this.participantProfilesComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.allProfiles));
        this.participantProfilesComboViewer.refresh();
        this.participantUMLTypesTreeViewer.refresh();
        this.filterParticipantStereotypesByProfile();
    }

    protected void selectAllSubSter(final ParticipantTypeElement elementParent, final List<ParticipantTypeAttribute> attributeParentList) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress computeAvailableTypes = new IRunnableWithProgress(){

            public void run(IProgressMonitor thePM) throws InterruptedException {
                for (ParticipantTypeElement element : PapyrusSearchPage.this.umlTypeParticipantsList.keySet()) {
                    if (!(element instanceof ParticipantTypeElement)) continue;
                    PapyrusSearchPage.this.checkAllSubSter(element, elementParent, attributeParentList);
                }
            }
        };
        try {
            dialog.run(true, true, computeAvailableTypes);
        }
        catch (InvocationTargetException e) {
            Activator.log.error((Throwable)e);
        }
        catch (InterruptedException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void checkAllSubSter(ParticipantTypeElement element, ParticipantTypeElement elementParent, List<ParticipantTypeAttribute> attributeParentList) {
        EList superTypes;
        if (element.getElement() instanceof Stereotype && (superTypes = ((Class)element.getElement()).getSuperClasses()).contains(elementParent.getElement())) {
            element.setChecked(true);
            for (ParticipantTypeAttribute attributeParent : attributeParentList) {
                for (ParticipantTypeAttribute attributeToEvaluate : this.umlTypeParticipantsList.get(element)) {
                    if (attributeParent.getElement() != attributeToEvaluate.getElement()) continue;
                    attributeToEvaluate.setChecked(true);
                }
            }
        }
    }

    protected void selectAllSubUML(final ParticipantTypeElement elementParent, final List<ParticipantTypeAttribute> attributeParentList) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress computeAvailableTypes = new IRunnableWithProgress(){

            public void run(IProgressMonitor thePM) throws InterruptedException {
                for (ParticipantTypeElement element : PapyrusSearchPage.this.umlTypeParticipantsList.keySet()) {
                    if (!(element instanceof ParticipantTypeElement)) continue;
                    PapyrusSearchPage.this.checkAllSubUML(element, elementParent, attributeParentList);
                }
            }
        };
        try {
            dialog.run(true, true, computeAvailableTypes);
        }
        catch (InvocationTargetException e1) {
            Activator.log.error((Throwable)e1);
        }
        catch (InterruptedException e1) {
            Activator.log.error((Throwable)e1);
        }
    }

    protected void checkAllSubUML(ParticipantTypeElement element, ParticipantTypeElement elementParent, List<ParticipantTypeAttribute> attributeParentList) {
        EList superTypes;
        if (element.getElement() instanceof EClass && (superTypes = ((EClass)element.getElement()).getEAllSuperTypes()).contains(elementParent.getElement())) {
            element.setChecked(true);
            for (ParticipantTypeAttribute attributeParent : attributeParentList) {
                for (ParticipantTypeAttribute attributeToEvaluate : this.umlTypeParticipantsList.get(element)) {
                    if (attributeParent.getElement() != attributeToEvaluate.getElement()) continue;
                    attributeToEvaluate.setChecked(true);
                }
            }
        }
    }

    protected void createSimpleSearch() {
        Composite participantManipualtionComposite = new Composite(this.advancedSearchComposite, 0);
        participantManipualtionComposite.setLayout((Layout)new GridLayout(1, false));
        participantManipualtionComposite.setLayoutData((Object)new GridData(4, 128, false, true, 1, 1));
        this.btnSearchInName = new Button(participantManipualtionComposite, 16);
        this.btnSearchInName.setText(Messages.PapyrusSearchPage_16);
        this.btnSearchInName.setLayoutData((Object)new GridData(16384, 128, false, false, 0, 1));
        this.btnSearchInName.setSelection(true);
        this.btnSearchAllStringAttributes = new Button(participantManipualtionComposite, 16);
        this.btnSearchAllStringAttributes.setText(Messages.PapyrusSearchPage_17);
        this.btnSearchAllStringAttributes.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.currentSearchKind = 0;
        this.currentQueryKind = 0;
    }

    public Object[] getMetaClassesList() {
        HashSet<EClassifier> umlMetaClasses = new HashSet<EClassifier>();
        for (EClassifier eClassifier : UMLPackage.eINSTANCE.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            umlMetaClasses.add(eClassifier);
        }
        return umlMetaClasses.toArray();
    }

    protected void createOCLSearch(EObject root) {
        Composite client = this.queryComposite;
        Composite oclContextComposite = new Composite(client, 0);
        oclContextComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        oclContextComposite.setLayout((Layout)new GridLayout(2, false));
        this.oclContext = new Text(oclContextComposite, 2048);
        this.oclContext.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.oclContext.setEnabled(false);
        this.oclContext.setFocus();
        Button btnSelectContext = new Button(oclContextComposite, 8);
        btnSelectContext.setText(Messages.PapyrusSearchPage_18);
        btnSelectContext.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
                ILabelProvider labelProvider = labelProviderService.getLabelProvider();
                IScopeEntry currentScope = PapyrusSearchPage.this.getCurrentScopeEntry();
                if (currentScope != null) {
                    try {
                        ((UmlModel)currentScope.getModelSet().getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel")).lookupRoot();
                        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getCurrent().getActiveShell(), labelProvider, (ITreeContentProvider)new OCLContextContentProvider());
                        dialog.setTitle(Messages.PapyrusSearchPage_19);
                        dialog.setMessage(Messages.PapyrusSearchPage_20);
                        dialog.setInput((Object)currentScope.getModelSet());
                        dialog.setAllowMultiple(false);
                        dialog.open();
                        Object selection = dialog.getFirstResult();
                        if (selection instanceof EObject) {
                            PapyrusSearchPage.this.refreshSelection(selection);
                            if (PapyrusSearchPage.this.contextObject instanceof NamedElement) {
                                PapyrusSearchPage.this.oclContext.setText(((NamedElement)PapyrusSearchPage.this.contextObject).getQualifiedName());
                            } else {
                                PapyrusSearchPage.this.oclContext.setText(labelProvider.getText((Object)PapyrusSearchPage.this.contextObject));
                            }
                        }
                    }
                    catch (NotFoundException notFoundException) {
                        Activator.log.error(String.valueOf(Messages.PapyrusQuery_0) + currentScope.getModelSet(), (Throwable)notFoundException);
                    }
                }
            }
        });
        btnSelectContext.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Injector injector = EssentialOCLActivator.getInstance().getInjector("org.eclipse.ocl.xtext.essentialocl.EssentialOCL");
        Composite editorComposite = client;
        this.oclEditor = new EmbeddedXtextEditor(editorComposite, injector, 770);
        this.oclEditor.getViewer().getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                if ((e.keyCode == 0x1000050 || e.keyCode == 13) && (e.stateMask & 0x60000) == 0) {
                    e.doit = false;
                }
            }
        });
        GridData data = new GridData(4, 4, true, true, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(3);
        editorComposite.setLayoutData((Object)data);
        this.refreshSelection(root);
        this.currentQueryKind = 1;
    }

    protected IScopeEntry getCurrentScopeEntry() {
        Collection scope;
        Collection<IScopeEntry> scopeEntries;
        if (this.container.getSelectedScope() == 1 && (scopeEntries = WorkspaceQueryProvider.createScopeEntries(scope = ScopeCollector.getInstance().computeSearchScope(this.container))).size() == 1) {
            Object[] entries = scopeEntries.toArray();
            IScopeEntry selectedResource = (IScopeEntry)entries[0];
            return selectedResource;
        }
        return null;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite searchComposite = new Composite(parent, 0);
        searchComposite.setFont(parent.getFont());
        searchComposite.setLayout((Layout)new GridLayout(2, false));
        searchComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblSearchString = new Label(searchComposite, 0);
        lblSearchString.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        lblSearchString.setText(Messages.PapyrusSearchPage_4);
        this.queryKind = new Combo(searchComposite, 2572);
        this.queryKind.setLayoutData((Object)new GridData(131072, 4, false, false, 1, 1));
        this.queryKind.add(Messages.PapyrusSearchPage_21);
        this.queryKind.add(Messages.PapyrusSearchPage_22);
        this.queryKind.select(0);
        this.queryKind.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PapyrusSearchPage.this.queryKind.getSelectionIndex() != PapyrusSearchPage.this.currentQueryKind) {
                    block13: {
                        Control[] controlArray = PapyrusSearchPage.this.queryComposite.getChildren();
                        int n = controlArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control childControl = controlArray[n2];
                            childControl.dispose();
                            ++n2;
                        }
                        if (PapyrusSearchPage.this.queryKind.getSelectionIndex() == 0) {
                            PapyrusSearchPage.this.createTextSearch();
                        } else if (PapyrusSearchPage.this.container.getSelectedScope() == 1) {
                            IScopeEntry currentScope = PapyrusSearchPage.this.getCurrentScopeEntry();
                            if (currentScope != null) {
                                if (currentScope.getModelSet() != null) {
                                    try {
                                        EObject root = ((UmlModel)currentScope.getModelSet().getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel")).lookupRoot();
                                        PapyrusSearchPage.this.createOCLSearch(root);
                                        if (PapyrusSearchPage.this.contextObject instanceof NamedElement) {
                                            PapyrusSearchPage.this.oclContext.setText(((NamedElement)PapyrusSearchPage.this.contextObject).getQualifiedName());
                                            break block13;
                                        }
                                        LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
                                        ILabelProvider labelProvider = labelProviderService.getLabelProvider();
                                        PapyrusSearchPage.this.oclContext.setText(labelProvider.getText((Object)PapyrusSearchPage.this.contextObject));
                                    }
                                    catch (NotFoundException notFoundException) {
                                        Activator.log.error(String.valueOf(Messages.PapyrusQuery_0) + currentScope.getModelSet(), (Throwable)notFoundException);
                                    }
                                } else {
                                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_23, (String)Messages.PapyrusSearchPage_24);
                                    PapyrusSearchPage.this.createTextSearch();
                                    PapyrusSearchPage.this.queryKind.select(0);
                                }
                            } else {
                                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_25, (String)Messages.PapyrusSearchPage_26);
                                PapyrusSearchPage.this.createTextSearch();
                                PapyrusSearchPage.this.queryKind.select(0);
                            }
                        } else {
                            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_27, (String)Messages.PapyrusSearchPage_28);
                            PapyrusSearchPage.this.createTextSearch();
                            PapyrusSearchPage.this.queryKind.select(0);
                        }
                    }
                    PapyrusSearchPage.this.queryComposite.layout();
                }
            }
        });
        this.queryComposite = new Composite(searchComposite, 0);
        this.queryComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.queryComposite.setLayout((Layout)new GridLayout(1, false));
        this.createTextSearch();
        this.setControl((Control)parent);
    }

    public boolean getSearchAllStringAttributes() {
        if (this.btnSearchAllStringAttributes != null) {
            return this.btnSearchAllStringAttributes.getSelection();
        }
        return false;
    }

    private boolean validateRegex() {
        try {
            PatternHelper.getInstance().createPattern(this.searchQueryText.getText(), this.btnCaseSensitive.getSelection(), this.btnRegularExpression.getSelection());
            this.searchQueryExplanatoryLabel.setForeground(this.getControl().getForeground());
            this.searchQueryExplanatoryLabel.setText("");
            return true;
        }
        catch (PatternSyntaxException e) {
            this.searchQueryExplanatoryLabel.setForeground(Display.getDefault().getSystemColor(3));
            this.searchQueryExplanatoryLabel.setText(e.getDescription());
            return false;
        }
    }

    protected void refreshSelection(final Object selected) {
        BaseDocument editorDocument = (BaseDocument)this.oclEditor.getDocument();
        editorDocument.modify((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

            public Value exec(XtextResource resource) throws Exception {
                Object selectedObject = selected;
                if (selectedObject instanceof IOutlineNode) {
                    if (selectedObject instanceof EObjectNode) {
                        EObjectNode selectedObjectNode = (EObjectNode)selectedObject;
                        selectedObjectNode.getEObjectURI();
                        PapyrusSearchPage.this.contextObject = null;
                    } else {
                        PapyrusSearchPage.this.contextObject = selectedObject instanceof EStructuralFeatureNode ? null : null;
                    }
                } else {
                    if (selectedObject instanceof IAdaptable) {
                        selectedObject = ((IAdaptable)selectedObject).getAdapter(EObject.class);
                    }
                    PapyrusSearchPage.this.contextObject = selectedObject instanceof EObject ? (EObject)selectedObject : null;
                }
                EnvironmentFactory environmentFactory = PapyrusSearchPage.this.getEnvironmentFactory();
                PapyrusSearchPage.this.parserContext = new EObjectContext(environmentFactory, null, PapyrusSearchPage.this.contextObject);
                EssentialOCLCSResource csResource = (EssentialOCLCSResource)resource;
                if (csResource != null) {
                    ResourceSet resourceSet;
                    if (PapyrusSearchPage.this.contextObject != null) {
                        csResource.getCS2AS();
                    }
                    if ((resourceSet = PapyrusSearchPage.this.oclEditor.getResourceSet()) != null) {
                        environmentFactory.adapt((Notifier)resourceSet);
                    }
                    csResource.setParserContext(PapyrusSearchPage.this.parserContext);
                }
                return null;
            }
        });
    }

    private Collection<IScopeEntry> createScopeEntries(Collection<URI> scope) {
        HashSet<IScopeEntry> results = new HashSet<IScopeEntry>();
        for (URI resource : scope) {
            ScopeEntry scopeEntry = new ScopeEntry(resource);
            results.add((IScopeEntry)scopeEntry);
        }
        return results;
    }

    private List<ParticipantTypeElement> getParticipantsToEvaluate(HashMap<ParticipantTypeElement, List<ParticipantTypeAttribute>> participantsList) {
        ArrayList<ParticipantTypeElement> participantsToEvaluate = new ArrayList<ParticipantTypeElement>();
        for (ParticipantTypeElement element : participantsList.keySet()) {
            if (!element.isChecked()) continue;
            participantsToEvaluate.add(element);
            for (ParticipantTypeAttribute attributesToEvaluate : participantsList.get(element)) {
                if (!attributesToEvaluate.isChecked()) continue;
                participantsToEvaluate.add(attributesToEvaluate);
            }
        }
        return participantsToEvaluate;
    }

    public boolean performAction() {
        if (this.queryKind.getSelectionIndex() == 0) {
            if (this.validateRegex()) {
                AbstractPapyrusQuery compositeQuery;
                Collection scope = ScopeCollector.getInstance().computeSearchScope(this.container);
                if (this.searchKind.getSelectionIndex() == 0) {
                    if (this.searchQueryText.getText().length() == 0) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_29, (String)Messages.PapyrusSearchPage_30);
                        return false;
                    }
                    ArrayList<AbstractPapyrusQuery> queries = new ArrayList<AbstractPapyrusQuery>(scope.size());
                    for (URI uri : scope) {
                        HashSet<URI> singleScope = new HashSet<URI>();
                        singleScope.add(uri);
                        QueryInfo info = new QueryInfo(this.searchQueryText.getText(), this.btnCaseSensitive.getSelection(), this.btnRegularExpression.getSelection(), this.btnSearchAllStringAttributes.getSelection(), singleScope);
                        AbstractPapyrusQuery query = CompositePapyrusQueryProvider.getInstance().createSimpleSearchQuery(info);
                        queries.add(query);
                    }
                    compositeQuery = CompositePapyrusQuery.compose(queries);
                } else {
                    ArrayList<ParticipantTypeElement> participantsToEvaluate = new ArrayList<ParticipantTypeElement>();
                    for (ParticipantTypeElement element : this.umlTypeParticipantsList.keySet()) {
                        if (!element.isChecked()) continue;
                        participantsToEvaluate.add(element);
                        if (this.searchQueryText.getText().length() <= 0) continue;
                        for (ParticipantTypeAttribute attributesToEvaluate : this.umlTypeParticipantsList.get(element)) {
                            if (!attributesToEvaluate.isChecked()) continue;
                            participantsToEvaluate.add(attributesToEvaluate);
                        }
                    }
                    for (ParticipantTypeElement element : this.stereotypeParticipantsList.keySet()) {
                        if (!element.isChecked()) continue;
                        participantsToEvaluate.add(element);
                        if (this.searchQueryText.getText().length() <= 0) continue;
                        for (ParticipantTypeAttribute attributesToEvaluate : this.stereotypeParticipantsList.get(element)) {
                            if (!attributesToEvaluate.isChecked()) continue;
                            participantsToEvaluate.add(attributesToEvaluate);
                        }
                    }
                    if (participantsToEvaluate.size() == 0) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_31, (String)Messages.PapyrusSearchPage_32);
                        return false;
                    }
                    ArrayList<AbstractPapyrusQuery> queries = new ArrayList<AbstractPapyrusQuery>(scope.size());
                    for (URI uri : scope) {
                        HashSet<URI> singleScope = new HashSet<URI>();
                        singleScope.add(uri);
                        QueryInfo info = new QueryInfo(this.searchQueryText.getText(), this.btnCaseSensitive.getSelection(), this.btnRegularExpression.getSelection(), participantsToEvaluate, singleScope, this.fBtnSearchForAllSelected.getSelection(), this.fBtnSearchForAnySelected.getSelection());
                        AbstractPapyrusQuery query = CompositePapyrusQueryProvider.getInstance().createAdvancedSearchQuery(info);
                        queries.add(query);
                    }
                    compositeQuery = CompositePapyrusQuery.compose(queries);
                }
                if (compositeQuery.canRunInBackground()) {
                    NewSearchUI.runQueryInBackground((ISearchQuery)compositeQuery);
                }
                return true;
            }
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SEARCH_ISSUE, (String)REGULAR_EXPRESSION_ILLFORMED);
            return false;
        }
        IScopeEntry scopeEntry = this.getCurrentScopeEntry();
        if (scopeEntry != null) {
            try {
                PivotUtil.checkResourceErrors((String)"", (Resource)this.oclEditor.getResource());
                ExpressionInOCL expressionInOCL = this.parserContext.getExpression((CSResource)this.oclEditor.getResource());
                PapyrusOCLQuery query = new PapyrusOCLQuery((BaseDocument)this.oclEditor.getDocument(), this.parserContext, this.getEnvironmentFactory(), null, this.contextObject, scopeEntry);
                if (query.canRunInBackground()) {
                    NewSearchUI.runQueryInBackground((ISearchQuery)query);
                }
            }
            catch (ParserException e) {
                InvalidValueException value = new InvalidValueException((Exception)((Object)e), Messages.PapyrusSearchPage_35);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SEARCH_ISSUE, (String)OCL_QUERY_ILLFORMED);
                return false;
            }
            return true;
        }
        return false;
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
        this.container.setPerformActionEnabled(true);
    }

    public boolean performReplace() {
        if (this.queryKind.getSelectionIndex() == 0) {
            if (this.container.getSelectedScope() == 1) {
                if (this.validateRegex()) {
                    AbstractPapyrusQuery query;
                    if (this.searchQueryText.getText().length() == 0) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_36, (String)Messages.PapyrusSearchPage_37);
                        return false;
                    }
                    Collection scope = ScopeCollector.getInstance().computeSearchScope(this.container);
                    if (this.searchKind.getSelectionIndex() == 0) {
                        QueryInfo info = new QueryInfo(this.searchQueryText.getText(), this.btnCaseSensitive.getSelection(), this.btnRegularExpression.getSelection(), this.btnSearchAllStringAttributes.getSelection(), scope);
                        query = CompositePapyrusQueryProvider.getInstance().createSimpleSearchQuery(info);
                    } else {
                        ArrayList<ParticipantTypeElement> participantsToEvaluate = new ArrayList<ParticipantTypeElement>();
                        for (ParticipantTypeElement element : this.umlTypeParticipantsList.keySet()) {
                            if (!element.isChecked()) continue;
                            participantsToEvaluate.add(element);
                            if (this.umlTypeParticipantsList.get(element).size() == 0) {
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_38, (String)Messages.PapyrusSearchPage_39);
                                return false;
                            }
                            for (ParticipantTypeAttribute attributesToEvaluate : this.umlTypeParticipantsList.get(element)) {
                                Property property;
                                if (!attributesToEvaluate.isChecked()) continue;
                                participantsToEvaluate.add(attributesToEvaluate);
                                boolean canDoReplace = false;
                                if (attributesToEvaluate.getElement() instanceof EAttribute) {
                                    Object value = element.getElement().eGet((EStructuralFeature)((EAttribute)attributesToEvaluate.getElement()));
                                    if (value instanceof String) {
                                        canDoReplace = true;
                                    }
                                } else if (attributesToEvaluate.getElement() instanceof Property && UMLUtil.isString((Type)(property = (Property)attributesToEvaluate.getElement()).getType())) {
                                    canDoReplace = true;
                                }
                                if (canDoReplace) continue;
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_40, (String)Messages.PapyrusSearchPage_41);
                                return false;
                            }
                        }
                        QueryInfo info = new QueryInfo(this.searchQueryText.getText(), this.btnCaseSensitive.getSelection(), this.btnRegularExpression.getSelection(), participantsToEvaluate, scope, this.fBtnSearchForAllSelected.getSelection(), this.fBtnSearchForAnySelected.getSelection());
                        query = CompositePapyrusQueryProvider.getInstance().createAdvancedSearchQuery(info);
                    }
                    NewSearchUI.runQueryInForeground((IRunnableContext)this.container.getRunnableContext(), (ISearchQuery)query);
                    Display.getCurrent().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ISearchResultPage page;
                            ISearchResultViewPart view = NewSearchUI.activateSearchResultView();
                            if (view != null && (page = view.getActivePage()) instanceof PapyrusSearchResultPage) {
                                PapyrusSearchResultPage resultPage = (PapyrusSearchResultPage)page;
                                ReplaceAction replaceAction = new ReplaceAction(resultPage.getSite().getShell(), resultPage, null);
                                replaceAction.run();
                            }
                        }
                    });
                    NewSearchUI.removeQuery((ISearchQuery)query);
                    return true;
                }
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SEARCH_ISSUE, (String)REGULAR_EXPRESSION_ILLFORMED);
                return false;
            }
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_27, (String)Messages.PapyrusSearchPage_28);
            return false;
        }
        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_42, (String)Messages.PapyrusSearchPage_43);
        return false;
    }

    protected EnvironmentFactory getEnvironmentFactory() {
        return this.oclEditor.getOCL().getEnvironmentFactory();
    }

    protected void flushEvents() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        while (workbench.getDisplay().readAndDispatch()) {
        }
    }

    public void reset() {
        if (this.oclEditor != null) {
            this.flushEvents();
            this.flushEvents();
        }
        this.parserContext = null;
        this.contextObject = null;
    }
}

