/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.bnd;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.bnd.BndModel;
import org.eclipse.pde.internal.ui.editor.context.IInputContextListener;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.plugin.BundleInputContext;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;

public class BndInputContext
extends InputContext
implements IInputContextListener,
IModelChangedListener {
    public static final String CONTEXT_ID = "bnd-context";

    public BndInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    @Override
    protected Charset getDefaultCharset() {
        return StandardCharsets.UTF_8;
    }

    @Override
    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        IDocument document = this.getDocumentProvider().getDocument((Object)input);
        BndModel model = new BndModel(document);
        model.load();
        return model;
    }

    @Override
    public BndModel getModel() {
        return (BndModel)super.getModel();
    }

    @Override
    public String getId() {
        return CONTEXT_ID;
    }

    @Override
    protected void addTextEditOperation(ArrayList<TextEdit> ops, IModelChangedEvent event) {
    }

    @Override
    public void doRevert() {
    }

    @Override
    protected String getPartitionName() {
        return "___bnd_partition";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void contextAdded(InputContext context) {
        InputContext inputContext = context;
        if (inputContext instanceof BundleInputContext) {
            void bundleContext;
            BundleInputContext bundleInputContext = (BundleInputContext)inputContext;
            BundleInputContext cfr_ignored_0 = (BundleInputContext)inputContext;
            bundleContext.getModel().addModelChangedListener((IModelChangedListener)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void contextRemoved(InputContext context) {
        InputContext inputContext = context;
        if (inputContext instanceof BundleInputContext) {
            void bundleContext;
            BundleInputContext bundleInputContext = (BundleInputContext)inputContext;
            BundleInputContext cfr_ignored_0 = (BundleInputContext)inputContext;
            bundleContext.getModel().removeModelChangedListener((IModelChangedListener)this);
        }
    }

    @Override
    public void monitoredFileAdded(IFile monitoredFile) {
    }

    @Override
    public boolean monitoredFileRemoved(IFile monitoredFile) {
        return false;
    }

    public void modelChanged(IModelChangedEvent event) {
        String changedProperty = event.getChangedProperty();
        Object newValue = event.getNewValue();
        BndModel model = this.getModel();
        try {
            model.load();
            model.genericSet(changedProperty, newValue);
            model.saveChanges();
        }
        catch (Exception exception) {}
    }
}

