/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.activity;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.LoopCharacteristics;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.StandardLoopCharacteristics;
import org.eclipse.bpmn2.modeler.core.features.activity.AbstractUpdateMarkerFeature;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;

public class UpdateActivityLoopAndMultiInstanceMarkerFeature
extends AbstractUpdateMarkerFeature<Activity> {
    public UpdateActivityLoopAndMultiInstanceMarkerFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    protected String getPropertyKey() {
        return "marker.loop.or.multi";
    }

    @Override
    protected boolean isPropertyChanged(Activity activity, String propertyValue) {
        return !this.getLoopCharacteristicsValue(activity).getName().equals(propertyValue);
    }

    @Override
    protected void doUpdate(Activity activity, ContainerShape markerContainer) {
        switch (this.getLoopCharacteristicsValue(activity)) {
            case LOOP: {
                ShapeDecoratorUtil.showActivityMarker(markerContainer, "activity.marker.lc.standard");
                ShapeDecoratorUtil.hideActivityMarker(markerContainer, "activity.marker.lc.multi.parallel");
                ShapeDecoratorUtil.hideActivityMarker(markerContainer, "activity.marker.lc.multi.sequential");
                break;
            }
            case MULTI_PARALLEL: {
                ShapeDecoratorUtil.hideActivityMarker(markerContainer, "activity.marker.lc.standard");
                ShapeDecoratorUtil.showActivityMarker(markerContainer, "activity.marker.lc.multi.parallel");
                ShapeDecoratorUtil.hideActivityMarker(markerContainer, "activity.marker.lc.multi.sequential");
                break;
            }
            case MULTI_SEQUENTIAL: {
                ShapeDecoratorUtil.hideActivityMarker(markerContainer, "activity.marker.lc.standard");
                ShapeDecoratorUtil.hideActivityMarker(markerContainer, "activity.marker.lc.multi.parallel");
                ShapeDecoratorUtil.showActivityMarker(markerContainer, "activity.marker.lc.multi.sequential");
                break;
            }
            default: {
                ShapeDecoratorUtil.hideActivityMarker(markerContainer, "activity.marker.lc.standard");
                ShapeDecoratorUtil.hideActivityMarker(markerContainer, "activity.marker.lc.multi.parallel");
                ShapeDecoratorUtil.hideActivityMarker(markerContainer, "activity.marker.lc.multi.sequential");
            }
        }
    }

    @Override
    protected String convertPropertyToString(Activity activity) {
        return this.getLoopCharacteristicsValue(activity).getName();
    }

    private LoopCharacteristicType getLoopCharacteristicsValue(Activity activity) {
        LoopCharacteristics loopCharacteristics = activity.getLoopCharacteristics();
        LoopCharacteristicType type = LoopCharacteristicType.NULL;
        if (loopCharacteristics != null) {
            MultiInstanceLoopCharacteristics multi;
            type = loopCharacteristics instanceof MultiInstanceLoopCharacteristics ? ((multi = (MultiInstanceLoopCharacteristics)loopCharacteristics).isIsSequential() ? LoopCharacteristicType.MULTI_SEQUENTIAL : LoopCharacteristicType.MULTI_PARALLEL) : LoopCharacteristicType.LOOP;
        }
        return type;
    }

    static enum LoopCharacteristicType {
        NULL("null"),
        LOOP(StandardLoopCharacteristics.class.getSimpleName()),
        MULTI_PARALLEL(String.valueOf(MultiInstanceLoopCharacteristics.class.getSimpleName()) + ":parallel"),
        MULTI_SEQUENTIAL(String.valueOf(MultiInstanceLoopCharacteristics.class.getSimpleName()) + ":sequential");

        private String name;

        private LoopCharacteristicType(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

