/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.editor;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DesignEditorSite
extends MultiPageEditorSite {
    final BPMN2Editor bpmn2Editor;

    public DesignEditorSite(MultiPageEditorPart multiPageEditor, IEditorPart editor) {
        super(multiPageEditor, editor);
        this.bpmn2Editor = (BPMN2Editor)editor;
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider parentProvider = this.getMultiPageEditor().getSite().getSelectionProvider();
        if (parentProvider instanceof MultiPageSelectionProvider) {
            SelectionChangedEvent newEvent = this.getNewEvent(parentProvider, event);
            MultiPageSelectionProvider prov = (MultiPageSelectionProvider)parentProvider;
            prov.fireSelectionChanged(newEvent);
        }
    }

    protected void handlePostSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider parentProvider = this.getMultiPageEditor().getSite().getSelectionProvider();
        Diagram currentDiagram = this.bpmn2Editor.getDiagramTypeProvider().getDiagram();
        PictogramElement pe = BusinessObjectUtil.getPictogramElementForSelection((ISelection)event.getSelection());
        try {
            Diagram peDiagram = Graphiti.getPeService().getDiagramForPictogramElement(pe);
            if (currentDiagram != peDiagram) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        if (parentProvider instanceof MultiPageSelectionProvider) {
            SelectionChangedEvent newEvent = this.getNewEvent(parentProvider, event);
            MultiPageSelectionProvider prov = (MultiPageSelectionProvider)parentProvider;
            prov.firePostSelectionChanged(newEvent);
        }
    }

    protected SelectionChangedEvent getNewEvent(ISelectionProvider parentProvider, SelectionChangedEvent event) {
        IStructuredSelection ss;
        Object o;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (o = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof Node) {
            selection = this.getNewSelection((Node)o);
        }
        if (selection != null) {
            return new SelectionChangedEvent(parentProvider, selection);
        }
        return event;
    }

    protected StructuredSelection getNewSelection(Node node) {
        short type = node.getNodeType();
        if (type == 1) {
            PictogramElement pe = null;
            Element elem = (Element)node;
            String value = elem.getAttribute("bpmnElement");
            if (value != null) {
                pe = this.findPictogramElement(value);
            }
            if (pe == null && (value = elem.getAttribute("id")) != null) {
                pe = this.findPictogramElement(value);
            }
            if (pe != null) {
                return new StructuredSelection((Object)pe);
            }
            return this.getNewSelection(node.getParentNode());
        }
        if (type == 2) {
            Attr attr = (Attr)node;
            return this.getNewSelection(attr.getOwnerElement());
        }
        if (type == 3) {
            return this.getNewSelection(node.getParentNode());
        }
        return null;
    }

    protected PictogramElement findPictogramElement(String id) {
        PictogramElement pictogramElement = null;
        if (id != null) {
            BaseElement be = this.bpmn2Editor.getModelHandler().findElement(id);
            List pes = Graphiti.getLinkService().getPictogramElements(this.bpmn2Editor.getDiagramTypeProvider().getDiagram(), (EObject)be);
            for (PictogramElement pe : pes) {
                if (pe instanceof ContainerShape) {
                    pictogramElement = pe;
                    continue;
                }
                if (!(pe instanceof FreeFormConnection)) continue;
                pictogramElement = pe;
            }
        }
        return pictogramElement;
    }
}

