/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.edapt;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.impl.EFactoryImpl;

public class DynamicEcoreFactory
extends EFactoryImpl {
    private static final String E_BIG_DECIMAL = "EBigDecimal";
    private static final String E_BIG_INTEGER = "EBigInteger";
    private static final String E_BOOLEAN = "EBoolean";
    private static final String E_BOOLEAN_OBJECT = "EBooleanObject";
    private static final String E_BYTE = "EByte";
    private static final String E_BYTE_ARRAY = "EByteArray";
    private static final String E_BYTE_OBJECT = "EByteObject";
    private static final String E_CHAR = "EChar";
    private static final String E_CHARACTER_OBJECT = "ECharacterObject";
    private static final String E_DATE = "EDate";
    private static final String E_DOUBLE = "EDouble";
    private static final String E_DOUBLE_OBJECT = "EDoubleObject";
    private static final String E_FLOAT = "EFloat";
    private static final String E_FLOAT_OBJECT = "EFloatObject";
    private static final String E_INT = "EInt";
    private static final String E_INTEGER_OBJECT = "EIntegerObject";
    private static final String E_JAVA_CLASS = "EJavaClass";
    private static final String E_JAVA_OBJECT = "EJavaObject";
    private static final String E_LONG = "ELong";
    private static final String E_LONG_OBJECT = "ELongObject";
    private static final String E_SHORT = "EShort";
    private static final String E_SHORT_OBJECT = "EShortObject";
    private static final String E_STRING = "EString";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Object createFromString(EDataType eDataType, String initialValue) {
        String id = eDataType.getName();
        if (E_BIG_DECIMAL.equals(id)) {
            return this.createEBigDecimalFromString(eDataType, initialValue);
        }
        if (E_BIG_INTEGER.equals(id)) {
            return this.createEBigIntegerFromString(eDataType, initialValue);
        }
        if (E_BOOLEAN.equals(id)) {
            return this.createEBooleanFromString(eDataType, initialValue);
        }
        if (E_BOOLEAN_OBJECT.equals(id)) {
            return this.createEBooleanObjectFromString(eDataType, initialValue);
        }
        if (E_BYTE.equals(id)) {
            return this.createEByteFromString(eDataType, initialValue);
        }
        if (E_BYTE_ARRAY.equals(id)) {
            return this.createEByteArrayFromString(eDataType, initialValue);
        }
        if (E_BYTE_OBJECT.equals(id)) {
            return this.createEByteObjectFromString(eDataType, initialValue);
        }
        if (E_CHAR.equals(id)) {
            return this.createECharFromString(eDataType, initialValue);
        }
        if (E_CHARACTER_OBJECT.equals(id)) {
            return this.createECharacterObjectFromString(eDataType, initialValue);
        }
        if (E_DATE.equals(id)) {
            return this.createEDateFromString(eDataType, initialValue);
        }
        if (E_DOUBLE.equals(id)) {
            return this.createEDoubleFromString(eDataType, initialValue);
        }
        if (E_DOUBLE_OBJECT.equals(id)) {
            return this.createEDoubleObjectFromString(eDataType, initialValue);
        }
        if (E_FLOAT.equals(id)) {
            return this.createEFloatFromString(eDataType, initialValue);
        }
        if (E_FLOAT_OBJECT.equals(id)) {
            return this.createEFloatObjectFromString(eDataType, initialValue);
        }
        if (E_INT.equals(id)) {
            return this.createEIntFromString(eDataType, initialValue);
        }
        if (E_INTEGER_OBJECT.equals(id)) {
            return this.createEIntegerObjectFromString(eDataType, initialValue);
        }
        if (E_JAVA_CLASS.equals(id)) {
            return this.createEJavaClassFromString(eDataType, initialValue);
        }
        if (E_JAVA_OBJECT.equals(id)) {
            return this.createEJavaObjectFromString(eDataType, initialValue);
        }
        if (E_LONG.equals(id)) {
            return this.createELongFromString(eDataType, initialValue);
        }
        if (E_LONG_OBJECT.equals(id)) {
            return this.createELongObjectFromString(eDataType, initialValue);
        }
        if (E_SHORT.equals(id)) {
            return this.createEShortFromString(eDataType, initialValue);
        }
        if (E_SHORT_OBJECT.equals(id)) {
            return this.createEShortObjectFromString(eDataType, initialValue);
        }
        if (E_STRING.equals(id)) {
            return this.createEStringFromString(eDataType, initialValue);
        }
        return super.createFromString(eDataType, initialValue);
    }

    protected EObject basicCreate(EClass eClass) {
        if (eClass.getInstanceClassName() == "java.util.Map$Entry") {
            return super.basicCreate(eClass);
        }
        EObject eObject = EcoreFactory.eINSTANCE.create(eClass);
        ((BasicEObjectImpl)BasicEObjectImpl.class.cast(eObject)).eSetClass(eClass);
        return eObject;
    }

    private Boolean booleanValueOf(String initialValue) {
        if ("true".equalsIgnoreCase(initialValue)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(initialValue)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Expecting true or false");
    }

    private Boolean createEBooleanObjectFromString(EDataType metaObject, String initialValue) {
        return initialValue == null ? null : this.booleanValueOf(initialValue);
    }

    private Character createECharacterObjectFromString(EDataType metaObject, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        char charValue = '\u0000';
        try {
            charValue = (char)Integer.parseInt(initialValue);
        }
        catch (NumberFormatException e) {
            char[] carray = initialValue.toCharArray();
            charValue = carray[0];
        }
        return Character.valueOf(charValue);
    }

    private Date createEDateFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        ParseException exception = null;
        int i = 0;
        while (i < EDATE_FORMATS.length) {
            try {
                return EDATE_FORMATS[i].parse(initialValue);
            }
            catch (ParseException parseException) {
                exception = parseException;
                ++i;
            }
        }
        throw new WrappedException(exception);
    }

    private Double createEDoubleObjectFromString(EDataType metaObject, String initialValue) {
        return initialValue == null ? null : Double.valueOf(initialValue);
    }

    private Float createEFloatObjectFromString(EDataType metaObject, String initialValue) {
        return initialValue == null ? null : Float.valueOf(initialValue);
    }

    private Integer createEIntegerObjectFromString(EDataType metaObject, String initialValue) {
        return initialValue == null ? null : Integer.valueOf(initialValue);
    }

    private BigDecimal createEBigDecimalFromString(EDataType eDataType, String initialValue) {
        return initialValue == null ? null : new BigDecimal(initialValue);
    }

    private BigInteger createEBigIntegerFromString(EDataType eDataType, String initialValue) {
        return initialValue == null ? null : new BigInteger(initialValue);
    }

    private String createEStringFromString(EDataType metaObject, String initialValue) {
        return initialValue;
    }

    private Integer createEIntFromString(EDataType metaObject, String initialValue) {
        return initialValue == null ? null : Integer.valueOf(initialValue);
    }

    private Boolean createEBooleanFromString(EDataType metaObject, String initialValue) {
        return initialValue == null ? null : this.booleanValueOf(initialValue);
    }

    private Byte createEByteObjectFromString(EDataType metaObject, String initialValue) {
        return initialValue == null ? null : Byte.valueOf(initialValue);
    }

    private Float createEFloatFromString(EDataType metaObject, String initialValue) {
        return initialValue == null ? null : Float.valueOf(initialValue);
    }

    private Character createECharFromString(EDataType metaObject, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        char charValue = '\u0000';
        try {
            charValue = (char)Integer.parseInt(initialValue);
        }
        catch (NumberFormatException e) {
            char[] carray = initialValue.toCharArray();
            charValue = carray[0];
        }
        return Character.valueOf(charValue);
    }

    private Long createELongFromString(EDataType metaObject, String initialValue) {
        return initialValue == null ? null : Long.valueOf(initialValue);
    }

    private Double createEDoubleFromString(EDataType metaObject, String initialValue) {
        return initialValue == null ? null : Double.valueOf(initialValue);
    }

    private Byte createEByteFromString(EDataType metaObject, String initialValue) {
        return initialValue == null ? null : Byte.valueOf(initialValue);
    }

    private Short createEShortFromString(EDataType metaObject, String initialValue) {
        return initialValue == null ? null : Short.valueOf(initialValue);
    }

    private Class<?> createEJavaClassFromString(EDataType metaObject, String initialValue) {
        block11: {
            try {
                if (initialValue != null) break block11;
                return null;
            }
            catch (ClassNotFoundException e) {
                throw new WrappedException((Exception)e);
            }
        }
        if ("boolean".equals(initialValue)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(initialValue)) {
            return Byte.TYPE;
        }
        if ("char".equals(initialValue)) {
            return Character.TYPE;
        }
        if ("double".equals(initialValue)) {
            return Double.TYPE;
        }
        if ("float".equals(initialValue)) {
            return Float.TYPE;
        }
        if ("int".equals(initialValue)) {
            return Integer.TYPE;
        }
        if ("long".equals(initialValue)) {
            return Long.TYPE;
        }
        if ("short".equals(initialValue)) {
            return Short.TYPE;
        }
        return Class.forName(initialValue);
    }

    private Object createEJavaObjectFromString(EDataType eDataType, String initialValue) {
        return this.createFromString(initialValue);
    }

    private Long createELongObjectFromString(EDataType metaObject, String initialValue) {
        return initialValue == null ? null : Long.valueOf(initialValue);
    }

    private Short createEShortObjectFromString(EDataType metaObject, String initialValue) {
        return initialValue == null ? null : Short.valueOf(initialValue);
    }

    private byte[] createEByteArrayFromString(EDataType eDataType, String initialValue) {
        return this.hexStringToByteArray(initialValue);
    }

    private byte[] hexStringToByteArray(String initialValue) {
        if (initialValue == null) {
            return null;
        }
        int size = initialValue.length();
        int limit = (size + 1) / 2;
        byte[] result = new byte[limit];
        if (size % 2 != 0) {
            result[--limit] = this.hexCharToByte(initialValue.charAt(size - 1));
        }
        int i = 0;
        int j = 0;
        while (i < limit) {
            byte high = this.hexCharToByte(initialValue.charAt(j++));
            byte low = this.hexCharToByte(initialValue.charAt(j++));
            result[i] = (byte)(high << 4 | low);
            ++i;
        }
        return result;
    }

    private byte hexCharToByte(char character) {
        switch (character) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return (byte)(character - 48);
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return (byte)(character - 97 + 10);
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return (byte)(character - 65 + 10);
            }
        }
        throw new NumberFormatException("Invalid hexadecimal");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        String id = eDataType.getName();
        if (E_BIG_DECIMAL.equals(id)) {
            return this.convertEBigDecimalToString(eDataType, instanceValue);
        }
        if (E_BIG_INTEGER.equals(id)) {
            return this.convertEBigIntegerToString(eDataType, instanceValue);
        }
        if (E_BOOLEAN.equals(id)) {
            return this.convertEBooleanToString(eDataType, instanceValue);
        }
        if (E_BOOLEAN_OBJECT.equals(id)) {
            return this.convertEBooleanObjectToString(eDataType, instanceValue);
        }
        if (E_BYTE.equals(id)) {
            return this.convertEByteToString(eDataType, instanceValue);
        }
        if (E_BYTE_ARRAY.equals(id)) {
            return this.convertEByteArrayToString(eDataType, instanceValue);
        }
        if (E_BYTE_OBJECT.equals(id)) {
            return this.convertEByteObjectToString(eDataType, instanceValue);
        }
        if (E_CHAR.equals(id)) {
            return this.convertECharToString(eDataType, instanceValue);
        }
        if (E_CHARACTER_OBJECT.equals(id)) {
            return this.convertECharacterObjectToString(eDataType, instanceValue);
        }
        if (E_DATE.equals(id)) {
            return this.convertEDateToString(eDataType, instanceValue);
        }
        if (E_DOUBLE.equals(id)) {
            return this.convertEDoubleToString(eDataType, instanceValue);
        }
        if (E_DOUBLE_OBJECT.equals(id)) {
            return this.convertEDoubleObjectToString(eDataType, instanceValue);
        }
        if (E_FLOAT.equals(id)) {
            return this.convertEFloatToString(eDataType, instanceValue);
        }
        if (E_FLOAT_OBJECT.equals(id)) {
            return this.convertEFloatObjectToString(eDataType, instanceValue);
        }
        if (E_INT.equals(id)) {
            return this.convertEIntToString(eDataType, instanceValue);
        }
        if (E_INTEGER_OBJECT.equals(id)) {
            return this.convertEIntegerObjectToString(eDataType, instanceValue);
        }
        if (E_JAVA_CLASS.equals(id)) {
            return this.convertEJavaClassToString(eDataType, instanceValue);
        }
        if (E_JAVA_OBJECT.equals(id)) {
            return this.convertEJavaObjectToString(eDataType, instanceValue);
        }
        if (E_LONG.equals(id)) {
            return this.convertELongToString(eDataType, instanceValue);
        }
        if (E_LONG_OBJECT.equals(id)) {
            return this.convertELongObjectToString(eDataType, instanceValue);
        }
        if (E_SHORT.equals(id)) {
            return this.convertEShortToString(eDataType, instanceValue);
        }
        if (E_SHORT_OBJECT.equals(id)) {
            return this.convertEShortObjectToString(eDataType, instanceValue);
        }
        if (E_STRING.equals(id)) {
            return this.convertEStringToString(eDataType, instanceValue);
        }
        return super.convertToString(eDataType, instanceValue);
    }

    private String convertEBooleanObjectToString(EDataType metaObject, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertECharacterObjectToString(EDataType metaObject, Object instanceValue) {
        if (instanceValue instanceof Character) {
            return Integer.toString(((Character)instanceValue).charValue());
        }
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertEDateToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        return EDATE_FORMATS[0].format((Date)instanceValue);
    }

    private String convertEDoubleObjectToString(EDataType metaObject, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertEFloatObjectToString(EDataType metaObject, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertEIntegerObjectToString(EDataType metaObject, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertEBigDecimalToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertEBigIntegerToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertEStringToString(EDataType metaObject, Object instanceValue) {
        return (String)instanceValue;
    }

    private String convertEIntToString(EDataType metaObject, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertEBooleanToString(EDataType metaObject, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertEByteObjectToString(EDataType metaObject, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertEFloatToString(EDataType metaObject, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertECharToString(EDataType metaObject, Object instanceValue) {
        if (instanceValue instanceof Character) {
            return Integer.toString(((Character)instanceValue).charValue());
        }
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertELongToString(EDataType metaObject, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertEDoubleToString(EDataType metaObject, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertEByteToString(EDataType metaObject, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertEByteArrayToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        byte[] bytes = (byte[])instanceValue;
        return this.convertBytesToHexString(bytes, bytes.length);
    }

    private String convertEShortToString(EDataType metaObject, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertEJavaClassToString(EDataType metaObject, Object instanceValue) {
        return instanceValue == null ? "" : ((Class)instanceValue).getName();
    }

    private String convertEJavaObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertToString(instanceValue);
    }

    private String convertELongObjectToString(EDataType metaObject, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertEShortObjectToString(EDataType metaObject, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    private String convertBytesToHexString(byte[] bytes, int count) {
        if (bytes == null) {
            return null;
        }
        char[] result = new char[2 * count];
        int i = 0;
        int j = 0;
        while (i < count) {
            int high = bytes[i] >> 4 & 0xF;
            int low = bytes[i] & 0xF;
            result[j++] = HEX_DIGITS[high];
            result[j++] = HEX_DIGITS[low];
            ++i;
        }
        return new String(result);
    }
}

