/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.region;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.dom.ElementDOMAdapter;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.IStructuredDocumentContextResolverFactory2;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.internal.region.Region2AttrAdapter;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Region2ElementAdapter
extends ElementDOMAdapter {
    private final RegionProcessorStrategy _regionParser;

    public Region2ElementAdapter(ITextRegion region) throws NoElementException {
        this._regionParser = new RegionProcessorStrategy(region);
    }

    public Map<String, Region2AttrAdapter> getAttributes() {
        return this._regionParser.getAttributes();
    }

    public String getNamespace() {
        return this._regionParser.getNamespace();
    }

    public String getLocalName() {
        return this._regionParser.getLocalName();
    }

    public String getNodeName() {
        return this._regionParser.getNodeName();
    }

    public String getPrefix() {
        return this._regionParser.getPrefix();
    }

    public IStructuredDocumentContext getDocumentContext() {
        return this._regionParser._context;
    }

    public ITextRegionCollection getTextRegion() {
        return this._regionParser._region;
    }

    public Element getElement() {
        return (Element)this._regionParser._node;
    }

    public static class NoElementException
    extends Exception {
        private static final long serialVersionUID = -4479154049727036580L;

        private NoElementException(String reason) {
            super(reason);
        }
    }

    private class RegionProcessorStrategy {
        private final ITextRegionCollection _region;
        private Map<String, Region2AttrAdapter> _attributes;
        private Node _node;
        private IStructuredDocumentContext _context;

        RegionProcessorStrategy(ITextRegion region) throws NoElementException {
            if (!(region instanceof ITextRegionCollection) || ((ITextRegionCollection)region).getFirstRegion().getType() != "XML_TAG_OPEN") {
                throw new NoElementException("Region is not a collection with an open tag");
            }
            this._region = (ITextRegionCollection)region;
            this._context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)((IStructuredDocumentRegion)this._region).getParentDocument(), this._region.getStartOffset());
            if (this._context == null) {
                throw new NoElementException("Couldn't acquire structured document context");
            }
            IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(this._context);
            if (resolver == null) {
                throw new NoElementException("Couldn't acquire dom resolver");
            }
            this._node = resolver.getNode();
            if (this._node == null) {
                throw new NoElementException("Couldn't get Node from region");
            }
        }

        public String getLocalName() {
            return this._node.getLocalName();
        }

        public String getNodeName() {
            return this._node.getNodeName();
        }

        public String getPrefix() {
            return this._node.getPrefix();
        }

        public String getNamespace() {
            ITaglibContextResolver tagLibResolver = IStructuredDocumentContextResolverFactory2.INSTANCE.getTaglibContextResolverFromDelegates(this._context);
            if (tagLibResolver != null) {
                return tagLibResolver.getTagURIForNodeName(this._node);
            }
            return null;
        }

        public Map<String, Region2AttrAdapter> getAttributes() {
            this.mapAttributesOnlyOnce();
            return Collections.unmodifiableMap(this._attributes);
        }

        private void mapAttributesOnlyOnce() {
            if (this._attributes != null) {
                return;
            }
            this._attributes = Collections.EMPTY_MAP;
            NamedNodeMap attributes = this._node.getAttributes();
            if (attributes != null) {
                int numAttrs = attributes.getLength();
                this._attributes = new HashMap<String, Region2AttrAdapter>((int)((float)numAttrs / 0.75f) + 1, 0.75f);
                int i = 0;
                while (i < numAttrs) {
                    Node nodeAttr = attributes.item(i);
                    Region2AttrAdapter attr = new Region2AttrAdapter(Region2ElementAdapter.this, nodeAttr);
                    this._attributes.put(attr.getLocalName(), attr);
                    ++i;
                }
            }
        }
    }
}

